/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.secure;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;

public class JACCPermissions {
    public static void checkPermission(Class clazz, String contextID, EJBMethodPermission methodPerm) throws SecurityException {
        CodeSource ejbCS = clazz.getProtectionDomain().getCodeSource();
        try {
            ProtectionDomain pd;
            JACCPermissions.setContextID(contextID);
            Policy policy = Policy.getPolicy();
            Subject caller = JACCPermissions.getContextSubject();
            Principal[] principals = null;
            if (caller != null) {
                Set<Principal> principalsSet = caller.getPrincipals();
                principals = new Principal[principalsSet.size()];
                principalsSet.toArray(principals);
            }
            if (!policy.implies(pd = new ProtectionDomain(ejbCS, null, null, principals), methodPerm)) {
                String msg = "Denied: " + methodPerm + ", caller=" + caller;
                SecurityException e = new SecurityException(msg);
                throw e;
            }
        }
        catch (PolicyContextException e) {
            throw new RuntimeException(e);
        }
    }

    static Subject getContextSubject() throws PolicyContextException {
        if (System.getSecurityManager() == null) {
            return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
        }
        return PolicyContextActions.PRIVILEGED.getContextSubject();
    }

    static String setContextID(String contextID) {
        SetContextID action = new SetContextID(contextID);
        String previousID = (String)AccessController.doPrivileged(action);
        return previousID;
    }

    private static class SetContextID
    implements PrivilegedAction {
        String contextID;

        SetContextID(String contextID) {
            this.contextID = contextID;
        }

        public Object run() {
            String previousID = PolicyContext.getContextID();
            PolicyContext.setContextID(this.contextID);
            return previousID;
        }
    }

    static interface PolicyContextActions {
        public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        public static final PolicyContextActions PRIVILEGED = new PolicyContextActions(){
            private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return (Subject)PolicyContext.getContext(PolicyContextActions.SUBJECT_CONTEXT_KEY);
                }
            };

            public Subject getContextSubject() throws PolicyContextException {
                try {
                    return (Subject)AccessController.doPrivileged(this.exAction);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof PolicyContextException) {
                        throw (PolicyContextException)ex;
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions(){

            public Subject getContextSubject() throws PolicyContextException {
                return (Subject)PolicyContext.getContext(PolicyContextActions.SUBJECT_CONTEXT_KEY);
            }
        };

        public Subject getContextSubject() throws PolicyContextException;
    }
}

