/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;

public final class ConfigHelper {
    private static final Log log = LogFactory.getLog(ConfigHelper.class);

    public static final URL locateConfig(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return ConfigHelper.findAsResource(path);
        }
    }

    public static final URL findAsResource(String path) {
        URL url = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            url = contextClassLoader.getResource(path);
        }
        if (url != null) {
            return url;
        }
        url = ConfigHelper.class.getClassLoader().getResource(path);
        if (url != null) {
            return url;
        }
        url = ClassLoader.getSystemClassLoader().getResource(path);
        return url;
    }

    public static final InputStream getConfigStream(String path) throws HibernateException {
        URL url = ConfigHelper.locateConfig(path);
        if (url == null) {
            String msg = "Unable to locate config file: " + path;
            log.fatal(msg);
            throw new HibernateException(msg);
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new HibernateException("Unable to open config file: " + path, e);
        }
    }

    public static final Reader getConfigStreamReader(String path) throws HibernateException {
        return new InputStreamReader(ConfigHelper.getConfigStream(path));
    }

    public static final Properties getConfigProperties(String path) throws HibernateException {
        try {
            Properties properties = new Properties();
            properties.load(ConfigHelper.getConfigStream(path));
            return properties;
        }
        catch (IOException e) {
            throw new HibernateException("Unable to load properties from specified config file: " + path, e);
        }
    }

    private ConfigHelper() {
    }

    public static InputStream getResourceAsStream(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = Environment.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = Environment.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new HibernateException(resource + " not found");
        }
        return stream;
    }

    public static InputStream getUserResourceAsStream(String resource) {
        boolean hasLeadingSlash = resource.startsWith("/");
        String stripped = hasLeadingSlash ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (stream = classLoader.getResourceAsStream(resource)) == null && hasLeadingSlash) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = Environment.class.getClassLoader().getResourceAsStream(resource);
        }
        if (stream == null && hasLeadingSlash) {
            stream = Environment.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new HibernateException(resource + " not found");
        }
        return stream;
    }
}

