/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.JoramAdapter;
import org.objectweb.joram.client.connector.ManagedConnectionMetaDataImpl;
import org.objectweb.joram.client.connector.OutboundConnection;
import org.objectweb.joram.client.connector.OutboundQueueConnection;
import org.objectweb.joram.client.connector.OutboundSession;
import org.objectweb.joram.client.connector.OutboundTopicConnection;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.XAConnection;
import org.objectweb.joram.client.jms.XAQueueConnection;
import org.objectweb.joram.client.jms.XAResourceMngr;
import org.objectweb.joram.client.jms.XASession;
import org.objectweb.joram.client.jms.XATopicConnection;
import org.objectweb.util.monolog.api.BasicLevel;

public class ManagedConnectionImpl
implements ManagedConnection,
LocalTransaction,
ExceptionListener {
    private JoramAdapter ra;
    private javax.jms.XAConnection cnx = null;
    private Vector handles;
    private Vector listeners;
    private boolean startedLocalTx = false;
    private ManagedConnectionMetaDataImpl metaData = null;
    private PrintWriter out = null;
    private boolean valid = false;
    private int hashCode = -1;
    String hostName;
    int serverPort;
    String mode;
    String userName;
    Session session = null;

    ManagedConnectionImpl(JoramAdapter ra, javax.jms.XAConnection cnx, String hostName, int serverPort, String userName) {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("ManagedConnectionImpl(" + ra + ", " + cnx + ", " + hostName + ", " + serverPort + ", " + userName + ")"));
        }
        this.ra = ra;
        this.cnx = cnx;
        this.hostName = hostName;
        this.serverPort = serverPort;
        this.userName = userName;
        this.mode = cnx instanceof javax.jms.XAQueueConnection ? "PTP" : (cnx instanceof javax.jms.XATopicConnection ? "PubSub" : "Unified");
        try {
            cnx.setExceptionListener(this);
        }
        catch (JMSException exc) {
            // empty catch block
        }
        this.handles = new Vector();
        this.listeners = new Vector();
        this.valid = true;
        this.hashCode = -1;
        ra.addProducer(this);
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getConnection(" + subject + ", " + cxRequestInfo + ")"));
        }
        if (!this.isValid()) {
            if (this.out != null) {
                this.out.print("Physical connection to the underlying JORAM server has been lost.");
            }
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        OutboundConnection handle = this.cnx instanceof javax.jms.XAQueueConnection ? new OutboundQueueConnection(this, (javax.jms.XAQueueConnection)this.cnx) : (this.cnx instanceof javax.jms.XATopicConnection ? new OutboundTopicConnection(this, (javax.jms.XATopicConnection)this.cnx) : new OutboundConnection(this, this.cnx));
        this.handles.add(handle);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getConnection handles = " + this.handles));
        }
        return handle;
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " associateConnection(" + connection + ")"));
        }
        if (!this.isValid()) {
            if (this.out != null) {
                this.out.print("Physical connection to the underlying JORAM server has been lost.");
            }
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        if (!(connection instanceof OutboundConnection)) {
            if (this.out != null) {
                this.out.print("The provided connection handle is not a JORAM handle.");
            }
            throw new ResourceException("The provided connection handle is not a JORAM handle.");
        }
        OutboundConnection newConn = (OutboundConnection)connection;
        newConn.managedCx = this;
        newConn.xac = (XAConnection)this.cnx;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getXAResource()"));
        }
        if (!this.isValid()) {
            if (this.out != null) {
                this.out.print("Physical connection to the underlying JORAM server has been lost.");
            }
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        try {
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getXAResource session = " + this.session));
            }
            if (this.session == null) {
                OutboundConnection outboundCnx = null;
                Enumeration e = this.handles.elements();
                while (e.hasMoreElements() && !(outboundCnx = (OutboundConnection)e.nextElement()).cnxEquals(this.cnx)) {
                }
                if (outboundCnx == null) {
                    outboundCnx = (OutboundConnection)this.getConnection(null, null);
                }
                if (outboundCnx != null) {
                    if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                        AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getXAResource  outboundCnx = " + outboundCnx + "\n  outboundCnx.sess = " + outboundCnx.sessions));
                    }
                    OutboundSession outboundSession = null;
                    if (outboundCnx.sessions.size() > 0) {
                        outboundSession = (OutboundSession)outboundCnx.sessions.get(0);
                        if (!(outboundSession.sess instanceof javax.jms.XASession)) {
                            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getXAResource  outboundSession.sess = " + outboundSession.sess));
                            }
                            XAResourceMngr xaResourceMngr = null;
                            if (this.cnx instanceof XAConnection) {
                                xaResourceMngr = ((XAConnection)this.cnx).getXAResourceMngr();
                            } else if (this.cnx instanceof XAQueueConnection) {
                                xaResourceMngr = ((XAQueueConnection)this.cnx).getXAResourceMngr();
                            } else if (this.cnx instanceof XATopicConnection) {
                                xaResourceMngr = ((XATopicConnection)this.cnx).getXAResourceMngr();
                            }
                            if (xaResourceMngr == null) {
                                xaResourceMngr = new XAResourceMngr((Connection)((Object)outboundCnx.xac));
                            }
                            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getXAResource  xaResourceMngr = " + xaResourceMngr));
                            }
                            org.objectweb.joram.client.jms.Session sess = (org.objectweb.joram.client.jms.Session)outboundSession.sess;
                            sess.setTransacted(true);
                            this.session = new XASession((Connection)((Object)outboundCnx.xac), sess, xaResourceMngr);
                            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getXAResource  session = " + this.session));
                            }
                        }
                    } else {
                        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getXAResource createXASession"));
                        }
                        this.session = this.cnx.createXASession();
                    }
                }
            } else if (this.session instanceof XASession) {
                if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                    AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getXAResource session is XASession and not null"));
                }
                ((XASession)this.session).getDelegateSession().setTransacted(true);
            } else if (!(this.session instanceof javax.jms.XASession)) {
                if (this.out != null) {
                    this.out.print("Managed connection not involved in a local transaction.");
                }
                throw new javax.resource.spi.IllegalStateException("Managed connection not involved in a local transaction.");
            }
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getXAResource  return = " + ((javax.jms.XASession)this.session).getXAResource()));
            }
            return ((javax.jms.XASession)this.session).getXAResource();
        }
        catch (JMSException exc) {
            if (this.out != null) {
                this.out.print("Could not get XA resource: " + exc);
            }
            throw new ResourceAdapterInternalException("Could not get XA resource: " + exc);
        }
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getLocalTransaction()"));
        }
        if (!this.isValid()) {
            if (this.out != null) {
                this.out.print("Physical connection to the underlying JORAM server has been lost.");
            }
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        try {
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getLocalTransaction session = " + this.session));
            }
            if (this.session == null) {
                this.session = this.cnx.createSession(true, 0);
            } else if (this.session instanceof javax.jms.XASession) {
                if (this.out != null) {
                    this.out.print("Managed connection already involved in a distributed transaction.");
                }
                throw new javax.resource.spi.IllegalStateException("Managed connection already involved in a distributed transaction.");
            }
            return this;
        }
        catch (JMSException exc) {
            if (this.out != null) {
                this.out.print("Could not build underlying transacted JMS session: " + exc);
            }
            throw new LocalTransactionException("Could not build underlying transacted JMS session: " + exc);
        }
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (this.metaData == null) {
            this.metaData = new ManagedConnectionMetaDataImpl(this.userName);
        }
        return this.metaData;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.out = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }

    public synchronized void cleanup() throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " cleanup()"));
        }
        while (!this.handles.isEmpty()) {
            OutboundConnection handle = (OutboundConnection)this.handles.remove(0);
            handle.cleanup();
        }
        this.session = null;
    }

    public synchronized void destroy() throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " destroy()"));
        }
        this.cleanup();
        try {
            this.cnx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ra.removeProducer(this);
        this.valid = false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = (this.mode + ":" + this.hostName + ":" + ":" + this.serverPort + "-" + this.userName).hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        boolean res;
        if (!(o instanceof ManagedConnectionImpl)) {
            return false;
        }
        ManagedConnectionImpl other = (ManagedConnectionImpl)o;
        boolean bl = res = this.mode.equals(other.mode) && this.hostName.equals(other.hostName) && this.serverPort == other.serverPort && this.userName.equals(other.userName) && this.cnx.equals(other.cnx);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " equals = " + res));
        }
        return res;
    }

    public synchronized void onException(JMSException exc) {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " onException(" + exc + ")"));
        }
        if (!this.isValid()) {
            return;
        }
        if (!(exc instanceof IllegalStateException)) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent(this, 5);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
            listener.connectionErrorOccurred(event);
        }
        this.valid = false;
    }

    public synchronized void begin() throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " begin()"));
        }
        if (!this.isValid()) {
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        if (this.startedLocalTx) {
            throw new LocalTransactionException("Local transaction has already begun.");
        }
        ConnectionEvent event = new ConnectionEvent(this, 2);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
            listener.localTransactionStarted(event);
        }
        this.startedLocalTx = true;
    }

    public synchronized void commit() throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " commit()"));
        }
        if (!this.isValid()) {
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        if (!this.startedLocalTx) {
            throw new LocalTransactionException("Local transaction has not begun.");
        }
        try {
            this.session.commit();
        }
        catch (JMSException exc) {
            throw new LocalTransactionException("Commit of the transacted JMS session failed: " + exc);
        }
        ConnectionEvent event = new ConnectionEvent(this, 3);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
            listener.localTransactionCommitted(event);
        }
        this.startedLocalTx = false;
    }

    public synchronized void rollback() throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " rollback()"));
        }
        if (!this.isValid()) {
            throw new CommException("Physical connection to the underlying JORAM server has been lost.");
        }
        if (!this.startedLocalTx) {
            throw new LocalTransactionException("Local transaction has not begun.");
        }
        try {
            this.session.rollback();
        }
        catch (JMSException exc) {
            throw new LocalTransactionException("Rollback of the transacted JMS session failed: " + exc);
        }
        ConnectionEvent event = new ConnectionEvent(this, 4);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
            listener.localTransactionRolledback(event);
        }
        this.startedLocalTx = false;
    }

    boolean matches(String hostName, int serverPort, String userName, String mode) {
        return this.hostName.equals(hostName) && this.serverPort == serverPort && this.userName.equals(userName) && this.mode.equals(mode);
    }

    boolean isValid() {
        return this.valid;
    }

    void closeHandle(OutboundConnection handle) {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " closeHandle(" + handle + ")"));
        }
        ConnectionEvent event = new ConnectionEvent(this, 1);
        event.setConnectionHandle(handle);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this.listeners.get(i);
            listener.connectionClosed(event);
        }
    }
}

