/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.SecurityException;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.ConnectionRequest;
import org.objectweb.joram.client.connector.DefaultConnectionManager;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.util.monolog.api.BasicLevel;

public class OutboundConnectionFactory
implements ConnectionFactory,
Serializable,
Referenceable {
    private static final long serialVersionUID = 1L;
    protected ManagedConnectionFactoryImpl mcf;
    protected ConnectionManager cxManager;
    protected Reference reference;

    OutboundConnectionFactory(ManagedConnectionFactoryImpl mcf, ConnectionManager cxManager) {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("OutboundConnectionFactory(" + mcf + ", " + cxManager + ")"));
        }
        this.mcf = mcf;
        this.cxManager = cxManager != null ? cxManager : DefaultConnectionManager.getRef();
    }

    public Connection createConnection() throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createConnection()"));
        }
        return this.createConnection(this.mcf.userName, this.mcf.password);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createConnection(" + userName + ", " + password + ")"));
        }
        try {
            ConnectionRequest cxRequest = new ConnectionRequest(userName, password);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createConnection cxManager = " + this.cxManager));
            }
            Object o = this.cxManager.allocateConnection(this.mcf, cxRequest);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createConnection connection = " + o));
            }
            return (Connection)o;
        }
        catch (SecurityException exc) {
            throw new JMSSecurityException("Invalid user identification: " + exc);
        }
        catch (CommException exc) {
            throw new IllegalStateException("Could not connect to the JORAM server: " + exc);
        }
        catch (ResourceException exc) {
            throw new JMSException("Could not create connection: " + exc);
        }
    }

    public void setReference(Reference ref) {
        this.reference = ref;
    }

    public Reference getReference() {
        return this.reference;
    }
}

