/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.ha.tcp;

import java.util.StringTokenizer;
import java.util.Timer;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.client.jms.tcp.ReliableTcpClient;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;

public class HATcpConnection
implements RequestChannel {
    private ReliableTcpClient tcpClient;

    public HATcpConnection(String url, FactoryParameters params, String name, String password) throws JMSException {
        this(url, params, name, password, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient");
    }

    public HATcpConnection(String url, FactoryParameters params, String name, String password, String reliableClass) throws JMSException {
        try {
            this.tcpClient = (ReliableTcpClient)Class.forName(reliableClass).newInstance();
        }
        catch (ClassNotFoundException exc) {
            JMSException jmsExc = new JMSException("HATcpConnection: ClassNotFoundException : " + reliableClass);
            jmsExc.setLinkedException(exc);
            throw jmsExc;
        }
        catch (InstantiationException exc) {
            JMSException jmsExc = new JMSException("HATcpConnection: InstantiationException : " + reliableClass);
            jmsExc.setLinkedException(exc);
            throw jmsExc;
        }
        catch (IllegalAccessException exc) {
            JMSException jmsExc = new JMSException("HATcpConnection: IllegalAccessException : " + reliableClass);
            jmsExc.setLinkedException(exc);
            throw jmsExc;
        }
        this.tcpClient.init(params, name, password, true);
        StringTokenizer tokenizer = new StringTokenizer(url, "/:,");
        if (!tokenizer.hasMoreElements()) {
            throw new JMSException("URL not valid:" + url);
        }
        String protocol = tokenizer.nextToken();
        if (protocol.equals("hajoram")) {
            while (tokenizer.hasMoreElements()) {
                this.tcpClient.addServerAddress(tokenizer.nextToken(), Integer.parseInt(tokenizer.nextToken()));
            }
        } else {
            throw new JMSException("Unknown protocol:" + protocol);
        }
    }

    public void setTimer(Timer timer) {
        this.tcpClient.setTimer(timer);
    }

    public void connect() throws Exception {
        this.tcpClient.connect();
    }

    public void send(AbstractJmsRequest request) throws Exception {
        this.tcpClient.send(request);
    }

    public AbstractJmsReply receive() throws Exception {
        return (AbstractJmsReply)this.tcpClient.receive();
    }

    public void close() {
        this.tcpClient.close();
    }
}

