/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.compiler.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerConfigurator;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.generator.api.Generator;
import org.objectweb.jorm.generator.api.MOPFactory;
import org.objectweb.jorm.lib.JormConfiguratorImpl;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.jorm.verifier.api.MappingVerifier;
import org.objectweb.jorm.verifier.api.Verifier;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.LoggerFactory;

public class JormCompilerConfiguratorImpl
extends JormConfiguratorImpl
implements JormCompilerConfigurator {
    private HashMap mapperName2mofFactory = new HashMap();

    public void setLoggerFactory(LoggerFactory lf) {
        this.loggerFactory = lf;
        this.logger = lf.getLogger("org.objectweb.jorm.compiler.config");
    }

    public Verifier getVerifier() throws PException {
        if (this.properties == null) {
            throw new PExceptionCompiler("JORM has not been configured.");
        }
        String cn = this.properties.getProperty("jorm.verifier");
        if (cn == null) {
            throw new PException("Impossible to load a verifier: not configured:" + this.properties);
        }
        try {
            return (Verifier)this.loader.loadClass(cn).newInstance();
        }
        catch (InstantiationException e) {
            throw new PExceptionCompiler(e, "Problem while instantiating " + cn);
        }
        catch (IllegalAccessException e) {
            throw new PExceptionCompiler(e, "Problem while trying to access " + cn);
        }
        catch (ClassNotFoundException e) {
            throw new PExceptionCompiler(e, "Problem while loading class " + cn);
        }
    }

    public Generator getGenerator() throws PException {
        if (this.properties == null) {
            throw new PExceptionCompiler("JORM has not been configured.");
        }
        String cn = this.properties.getProperty("jorm.generator");
        if (cn == null) {
            throw new PException("Impossible to load a generator: not configured:" + this.properties);
        }
        try {
            Generator res = (Generator)this.loader.loadClass(cn).newInstance();
            return res;
        }
        catch (InstantiationException e) {
            throw new PExceptionCompiler(e, "Problem while instantiating " + cn);
        }
        catch (IllegalAccessException e) {
            throw new PExceptionCompiler(e, "Problem while trying to access " + cn);
        }
        catch (ClassNotFoundException e) {
            throw new PExceptionCompiler(e, "Problem while loading class " + cn);
        }
    }

    public String getJormcOptsFile() throws PException {
        if (this.properties == null) {
            throw new PExceptionCompiler("JORM has not been configured.");
        }
        return this.properties.getProperty("jorm.compiler.optsfile");
    }

    public MOPFactory getMOPFactory(String mappername) throws PException {
        MOPFactory mopFactory = (MOPFactory)this.mapperName2mofFactory.get(mappername);
        if (mopFactory != null) {
            return mopFactory;
        }
        if (this.properties == null) {
            throw new PExceptionCompiler("JORM has not been configured.");
        }
        String cn = this.properties.getProperty("jorm.mapper.mopfactory." + mappername);
        if (cn == null) {
            throw new PException("Impossible to load a meta object factory: not configured:" + this.properties);
        }
        try {
            mopFactory = (MOPFactory)this.loader.loadClass(cn).newInstance();
            this.mapperName2mofFactory.put(mappername, mopFactory);
            if (mopFactory instanceof Loggable) {
                if (this.loggerFactory != null) {
                    ((Loggable)((Object)mopFactory)).setLoggerFactory(this.loggerFactory);
                } else if (this.logger != null) {
                    ((Loggable)((Object)mopFactory)).setLogger(this.logger);
                }
            }
            return mopFactory;
        }
        catch (InstantiationException e) {
            throw new PExceptionCompiler(e, "Problem while instantiating " + cn);
        }
        catch (IllegalAccessException e) {
            throw new PExceptionCompiler(e, "Problem while trying to access " + cn);
        }
        catch (ClassNotFoundException e) {
            throw new PExceptionCompiler(e, "Problem while loading class " + cn);
        }
    }

    public InputStream getGlobalJormcOptsFile() throws PException {
        File f;
        InputStream res = null;
        String jormcOptsFile = this.getJormcOptsFile();
        if (this.pathToJormcOpts != null) {
            if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("JormcOptsFile=" + this.pathToJormcOpts + File.separator + jormcOptsFile));
            }
            if ((f = new File(this.pathToJormcOpts + File.separator + jormcOptsFile)).exists()) {
                try {
                    res = new FileInputStream(f);
                }
                catch (FileNotFoundException e) {
                    throw new PException(e, "Cannot find jorm compiler option file.");
                }
            }
        }
        if (res == null) {
            f = new File(jormcOptsFile);
            if (f.exists()) {
                try {
                    res = new FileInputStream(f);
                }
                catch (FileNotFoundException e) {
                    throw new PException(e, "Cannot find jorm compiler option file.");
                }
            } else {
                res = this.loader.getResourceAsStream(jormcOptsFile);
            }
            if (res == null) {
                throw new PExceptionCompiler("Problem while accessing global compiler parameters: unable to locate [" + this.getJormcOptsFile() + "]");
            }
        }
        return res;
    }

    public MappingVerifier getMappingVerifier(String mappername) throws PException {
        if (this.properties == null) {
            throw new PExceptionCompiler("JORM has not been configured.");
        }
        String cn = this.properties.getProperty("jorm.mapper.verifier." + mappername);
        try {
            MappingVerifier v = (MappingVerifier)this.loader.loadClass(cn).newInstance();
            return v;
        }
        catch (InstantiationException e) {
            throw new PExceptionCompiler(e, "Problem while instantiating " + cn);
        }
        catch (IllegalAccessException e) {
            throw new PExceptionCompiler(e, "Problem while trying to access " + cn);
        }
        catch (ClassNotFoundException e) {
            throw new PExceptionCompiler(e, "Problem while loading class " + cn);
        }
    }
}

