/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.genclass;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.api.PAccessor;
import org.objectweb.jorm.api.PBinding;
import org.objectweb.jorm.api.PBindingCtrl;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PExceptionIO;
import org.objectweb.jorm.api.PExceptionProtocol;
import org.objectweb.jorm.api.PGenClassAccessor;
import org.objectweb.jorm.api.PIndexedElem;
import org.objectweb.jorm.api.PMappingCallback;
import org.objectweb.jorm.api.PMappingStructuresManager;
import org.objectweb.jorm.api.PNameIterator;
import org.objectweb.jorm.api.PStateGraph;
import org.objectweb.jorm.genclass.api.FieldDesc;
import org.objectweb.jorm.genclass.lib.GenClassMapping;
import org.objectweb.jorm.lib.PBindingImpl;
import org.objectweb.jorm.mapper.rdb.adapter.api.JoinedTable;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;
import org.objectweb.jorm.mapper.rdb.genclass.RdbFieldDesc;
import org.objectweb.jorm.mapper.rdb.genclass.RdbGenClassNameGetter;
import org.objectweb.jorm.mapper.rdb.genclass.RdbGenClassPNGIterator;
import org.objectweb.jorm.mapper.rdb.genclass.RdbGenClassProp;
import org.objectweb.jorm.mapper.rdb.lib.RdbConnectionWrapper;
import org.objectweb.jorm.mapper.rdb.lib.RdbPPolymorphicClass;
import org.objectweb.jorm.mapper.rdb.lib.RdbPrefetchablePCM;
import org.objectweb.jorm.mapper.rdb.lib.RdbTupleCollection;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbMapping;
import org.objectweb.jorm.mapper.rdb.util.ColumnAliasing;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.jorm.naming.api.PNameGetter;
import org.objectweb.jorm.naming.lib.CTHelper;
import org.objectweb.jorm.type.api.PExceptionTyping;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.util.monolog.api.BasicLevel;

public class RdbGenClassMapping
extends GenClassMapping
implements RdbGenClassProp {
    static final byte ID = 1;
    static final byte INDEX = 2;
    static final byte ELEM = 4;
    static final byte ELEMEXT = 8;
    static final byte PREFETCH = 22;
    static final byte PREFETCH_ID = 50;
    static final String SEPAND = " AND ";
    static final String SEPSCOL = ", ";
    static final String QUOTE = "'";
    static final String ASSIGNVAL = " = ?";
    static final String ASSIGN_NULL = " = null";
    protected String tableName = null;
    protected String refExtTableName = null;
    protected String[] mainCols;
    protected String[] extCols;
    protected RdbPrefetchablePCM prefetchedPCM;
    protected int nbPrefetchCol = 0;
    protected boolean prefetchActivated = true;
    protected RdbAdapter typeConverter = null;
    protected boolean useBatch = true;
    protected boolean colocated = false;
    protected boolean colocatedMaster = false;
    protected boolean readOnly = false;
    private String selectQuery = null;
    private String selectPrefetchQuery = null;
    private String selectAllNamesQuery = null;
    private String insertQuery = null;
    private String deleteAllQuery = null;
    private String deleteElemQuery = null;
    private String updateQuery = null;
    private String updateNullAllQuery = null;
    private String updateNullElemQuery = null;
    private static final String ELEM_INNER = "ELEM_INNER";

    public void setPrefetchActivated(boolean prefetch) {
        this.prefetchActivated = prefetch;
    }

    private String getSelectQuery(boolean withPrefetch) throws PException {
        if (withPrefetch && this.selectPrefetchQuery == null || !withPrefetch && this.selectQuery == null) {
            this.computeSelectQuery(withPrefetch);
        }
        return withPrefetch ? this.selectPrefetchQuery : this.selectQuery;
    }

    private synchronized void computeSelectQuery(boolean withPrefetch) throws PException {
        String mapperName;
        boolean prefetchPolymorphic;
        if (withPrefetch && this.selectPrefetchQuery != null || !withPrefetch && this.selectQuery != null) {
            return;
        }
        boolean bl = prefetchPolymorphic = withPrefetch && this.prefetchedPCM instanceof RdbPPolymorphicClass;
        if (withPrefetch && this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("The inner prefetch class ('" + this.prefetchedPCM.getClassName() + "') is " + (prefetchPolymorphic ? "" : "not ") + "polymorphic"));
        }
        if ((mapperName = this.mapper.getMapperName()).indexOf(".") != -1) {
            mapperName = mapperName.substring(0, mapperName.indexOf("."));
        }
        RdbMapping rdbm = null;
        RdbClassMapping rdbcm = null;
        String innerPrefetchQuery = null;
        if (prefetchPolymorphic) {
            rdbm = (RdbMapping)this.mapper.getMetaInfoManager().getClass(this.prefetchedPCM.getClassName()).getClassProject(this.prefetchedPCM.getProjectName()).getMapping(mapperName);
            rdbcm = (RdbClassMapping)rdbm.getClassMapping();
            RdbPPolymorphicClass rpc = (RdbPPolymorphicClass)((Object)this.prefetchedPCM);
            innerPrefetchQuery = rdbcm.getRdbInheritanceQuery().getExtentQuery(this.mapper, true, false, rpc.getPNameFields(), this.prefetchedPCM);
            if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Inner query:" + innerPrefetchQuery));
            }
        }
        StringBuffer select = new StringBuffer();
        if (withPrefetch) {
            if (prefetchPolymorphic) {
                Collection names = rdbcm.getRdbInheritanceQuery().getExtentFieldsNames(true, false);
                this.nbPrefetchCol = names.size();
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    select.append(ELEM_INNER).append(".");
                    select.append(name);
                    select.append(SEPSCOL);
                }
            } else {
                String[] cols = this.prefetchedPCM.getPrefetchSelectCols();
                this.nbPrefetchCol = cols.length;
                for (int i = 0; i < this.nbPrefetchCol; ++i) {
                    select.append(cols[i]);
                    select.append(SEPSCOL);
                }
            }
        }
        this.defineAllNames(select, (byte)6);
        ArrayList<JoinedTable> jts = new ArrayList<JoinedTable>();
        boolean needJoinForPrefetch = false;
        JoinedTable jtOfGC = new JoinedTable(this.tableName);
        jts.add(jtOfGC);
        if (withPrefetch) {
            if (prefetchPolymorphic) {
                jts.add(new JoinedTable("(" + innerPrefetchQuery + ")", ELEM_INNER));
                needJoinForPrefetch = true;
            } else {
                ArrayList newjts = new ArrayList(this.prefetchedPCM.getPrefetchTables());
                needJoinForPrefetch = true;
                int i = 0;
                while (i < newjts.size()) {
                    JoinedTable jt = (JoinedTable)newjts.get(i);
                    if (this.tableName.equals(jt.tableName)) {
                        if (!jt.joinedTables.isEmpty()) {
                            jtOfGC.joinedTables.addAll(jt.joinedTables);
                            jtOfGC.joins.addAll(jt.joins);
                        }
                        newjts.remove(i);
                        needJoinForPrefetch = false;
                        continue;
                    }
                    ++i;
                }
                jts.addAll(newjts);
            }
        }
        StringBuffer where = new StringBuffer();
        this.defineIdentifierClause(where);
        if (withPrefetch && needJoinForPrefetch) {
            Map<Object, Object> m;
            if (prefetchPolymorphic) {
                NameDef nd = rdbcm.getIdentifierMapping().getNameDef();
                if (nd.isFieldName()) {
                    m = new HashMap();
                    m.put("", nd.getFieldName());
                } else {
                    m = nd.getNameRef().getProjection();
                }
            } else {
                m = this.prefetchedPCM.getCNId2Column();
            }
            if (this.elemFields.length > 1) {
                where.append(SEPAND);
                where.append(" (");
                where.append(this.tableName);
                where.append(".");
                where.append(((RdbFieldDesc)this.elemFields[1]).columnName);
                where.append(" = ");
                String colName = null;
                colName = this.elemFields[1].compositeName == null ? (String)m.get("") : (String)m.get(this.elemFields[1].compositeName);
                if (prefetchPolymorphic) {
                    colName = this.toPolymorphicColName(colName);
                }
                where.append(colName);
                where.append(")");
            }
            if (this.elemFields.length > 2) {
                for (int i = 2; i < this.elemFields.length; ++i) {
                    where.append(SEPAND);
                    where.append(" (");
                    where.append(this.tableName);
                    where.append(".");
                    where.append(((RdbFieldDesc)this.elemFields[i]).columnName);
                    where.append(" = ");
                    String colName = (String)m.get(this.elemFields[i].compositeName);
                    if (prefetchPolymorphic) {
                        colName = this.toPolymorphicColName(colName);
                    }
                    where.append(colName);
                    where.append(")");
                }
            }
        }
        String query = this.typeConverter.getQuery(select.toString(), jts, where.toString(), false, false);
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Computed query (prefetch=" + withPrefetch + "): " + query));
        }
        if (withPrefetch) {
            this.selectPrefetchQuery = query;
        } else {
            this.selectQuery = query;
        }
    }

    private String toPolymorphicColName(String str) {
        int idx = str.indexOf(46);
        return "ELEM_INNER." + ColumnAliasing.getAliasFromColumn(idx == -1 ? str : str.substring(idx + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSelectAllNamesQuery() {
        if (this.selectAllNamesQuery == null) {
            RdbGenClassMapping rdbGenClassMapping = this;
            synchronized (rdbGenClassMapping) {
                if (this.selectAllNamesQuery == null) {
                    StringBuffer sqlstring = new StringBuffer("SELECT ");
                    this.defineAllNames(sqlstring, (byte)1);
                    sqlstring.append(" FROM " + this.tableName);
                    this.selectAllNamesQuery = sqlstring.toString();
                }
            }
        }
        return this.selectAllNamesQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInsertQuery() {
        if (this.insertQuery == null) {
            RdbGenClassMapping rdbGenClassMapping = this;
            synchronized (rdbGenClassMapping) {
                if (this.insertQuery == null) {
                    StringBuffer sqlstring = new StringBuffer("INSERT INTO " + this.tableName);
                    sqlstring.append("(");
                    this.defineNames(this.getIdentifierFields(), sqlstring, true, (short)0, false, false);
                    this.defineNames(this.getElemFields(), sqlstring, false, this.getElemFields().length != 1 ? (byte)1 : 0, false, false);
                    this.defineNames(this.getIndexFields(), sqlstring, false, (short)0, false, false);
                    sqlstring.append(") ");
                    sqlstring.append("VALUES (");
                    int nq = this.getIdentifierFields().length;
                    nq += this.getElemFields().length == 1 ? 1 : this.getElemFields().length - 1;
                    nq += this.getIndexFields().length;
                    String sep = "";
                    while (nq > 0) {
                        sqlstring.append(sep);
                        sep = SEPSCOL;
                        sqlstring.append("?");
                        --nq;
                    }
                    sqlstring.append(")");
                    this.insertQuery = sqlstring.toString();
                }
            }
        }
        return this.insertQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDeleteAllQuery() {
        if (this.deleteAllQuery == null) {
            RdbGenClassMapping rdbGenClassMapping = this;
            synchronized (rdbGenClassMapping) {
                if (this.deleteAllQuery == null) {
                    StringBuffer sqlstring = new StringBuffer("DELETE FROM " + this.tableName + " WHERE ");
                    this.defineIdentifierClause(sqlstring);
                    this.deleteAllQuery = sqlstring.toString();
                }
            }
        }
        return this.deleteAllQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDeleteElemQuery() {
        if (this.deleteElemQuery == null) {
            RdbGenClassMapping rdbGenClassMapping = this;
            synchronized (rdbGenClassMapping) {
                if (this.deleteElemQuery == null) {
                    StringBuffer sqlstring = new StringBuffer("DELETE FROM " + this.tableName + " WHERE ");
                    this.defineIdentifierClause(sqlstring);
                    this.defineIndexClause(sqlstring);
                    this.defineElemClause(sqlstring, false);
                    this.deleteElemQuery = sqlstring.toString();
                }
            }
        }
        return this.deleteElemQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getUpdateQuery() {
        if (this.updateQuery == null) {
            RdbGenClassMapping rdbGenClassMapping = this;
            synchronized (rdbGenClassMapping) {
                if (this.updateQuery == null) {
                    StringBuffer sqlstring = new StringBuffer("UPDATE " + this.tableName + " SET ");
                    if (this.colocated) {
                        this.defineIdentifierSet(sqlstring);
                        this.defineIndexSet(sqlstring);
                        sqlstring.append(" WHERE ");
                        this.defineElemClause(sqlstring, true);
                    } else {
                        this.defineElemSet(sqlstring);
                        sqlstring.append(" WHERE ");
                        this.defineIdentifierClause(sqlstring);
                        this.defineIndexClause(sqlstring);
                    }
                    this.updateQuery = sqlstring.toString();
                }
            }
        }
        return this.updateQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getUpdateNullAllQuery() {
        if (this.updateNullAllQuery == null) {
            RdbGenClassMapping rdbGenClassMapping = this;
            synchronized (rdbGenClassMapping) {
                if (this.updateNullAllQuery == null) {
                    StringBuffer sqlstring = new StringBuffer("UPDATE " + this.tableName + " SET ");
                    this.defineIdentifierSetNull(sqlstring);
                    this.defineIndexSetNull(sqlstring);
                    sqlstring.append(" WHERE ");
                    this.defineIdentifierClause(sqlstring);
                    this.updateNullAllQuery = sqlstring.toString();
                }
            }
        }
        return this.updateNullAllQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getUpdateNullElemQuery() {
        if (this.updateNullElemQuery == null) {
            RdbGenClassMapping rdbGenClassMapping = this;
            synchronized (rdbGenClassMapping) {
                if (this.updateNullElemQuery == null) {
                    StringBuffer sqlstring = new StringBuffer("UPDATE " + this.tableName + " SET ");
                    this.defineIdentifierSetNull(sqlstring);
                    this.defineIndexSetNull(sqlstring);
                    sqlstring.append(" WHERE ");
                    this.defineIdentifierClause(sqlstring);
                    this.defineIndexClause(sqlstring);
                    this.defineElemClause(sqlstring, false);
                    this.updateNullElemQuery = sqlstring.toString();
                }
            }
        }
        return this.updateNullElemQuery;
    }

    public PBinding createPBinding() throws PException {
        return new PBindingImpl(this);
    }

    public PNameIterator getPNameIterator(Object conn, boolean withSubType, boolean prefetching, Object txctx) throws PException {
        Connection sqlconn = RdbConnectionWrapper.narrow2SQL(conn);
        try {
            PreparedStatement ps = sqlconn.prepareStatement(this.getSelectAllNamesQuery());
            return new RdbGenClassPNGIterator(ps, ps.executeQuery(), this.identifierFields, this, prefetching, this.typeConverter);
        }
        catch (SQLException e) {
            throw new PExceptionIO(e, "SQL problem while computing the PName Iterator.");
        }
    }

    public PClassMapping[] getSubPCMs() throws PException {
        return null;
    }

    public boolean isConform(String mappername) {
        return mappername.equals("rdb");
    }

    public boolean exist(PBinding pb, Object conn) throws PException {
        byte status = pb.getStatus();
        byte nextstate = PStateGraph.nextStatePBinding(status, (byte)5);
        if (nextstate == 5) {
            throw new PExceptionProtocol("Cannot perform exist on this GenClass PBinding: " + status);
        }
        ((PBindingCtrl)pb).setStatus(nextstate);
        return true;
    }

    public void read(PBinding pb, Object conn, PAccessor pa) throws PException {
        this.read(pb, conn, pa, null, false);
    }

    public void read(PBinding pb, Object conn, PAccessor pa, Object txctx) throws PException {
        this.read(pb, conn, pa, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void read(PBinding pb, Object conn, PAccessor pa, Object txctx, boolean forUpudate) throws PException {
        byte nextstate;
        block38: {
            boolean withPrefetch;
            PExceptionIO resex;
            ResultSet rs;
            PreparedStatement pstmt;
            block36: {
                PGenClassAccessor paccessorGenClass = (PGenClassAccessor)pa;
                nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)6);
                if (nextstate == 5) {
                    throw new PExceptionProtocol("Cannot perform read on this GenClass PBinding: " + pb.getStatus());
                }
                pstmt = null;
                rs = null;
                resex = null;
                withPrefetch = this.prefetchActivated && txctx != null && this.prefetchedPCM != null;
                Connection sqlconn = RdbConnectionWrapper.narrow2SQL(conn);
                String q = this.getSelectQuery(withPrefetch);
                if (forUpudate) {
                    q = q + " FOR UPDATE";
                }
                pstmt = sqlconn.prepareStatement(q);
                if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Read GC: \n\tprefectActivated=" + this.prefetchActivated + "\n\ttx=" + txctx + "\n\tpcm=" + this.prefetchedPCM + "\n\tquery=" + q));
                }
                this.defineIdentifierVal(pb.getPName(), pstmt, 1);
                rs = pstmt.executeQuery();
                int size = this.typeConverter.fetchResultSetSize(rs);
                paccessorGenClass.paSetNbElem(size);
                PNameGetter png = this.getPNameGetter(rs, withPrefetch);
                RdbTupleCollection tc = null;
                if (withPrefetch) {
                    try {
                        tc = new RdbTupleCollection(txctx, rs, pstmt, this.nbPrefetchCol + 1, this.logger, this.prefetchedPCM, true, png);
                    }
                    catch (MedorException e1) {
                        throw new PException(e1);
                    }
                }
                boolean hasNext = false;
                try {
                    hasNext = tc == null ? rs.next() : tc.next();
                }
                catch (MedorException e1) {
                    throw new PException(e1);
                }
                while (hasNext) {
                    this.passValuesToAccessor(conn, rs, paccessorGenClass, png, tc, withPrefetch);
                    try {
                        hasNext = tc == null ? rs.next() : tc.next();
                    }
                    catch (MedorException e1) {
                        throw new PException(e1);
                    }
                }
                Object var20_23 = null;
                if (withPrefetch) break block36;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (SQLException e2) {
                    if (resex != null) break block36;
                    resex = new PExceptionIO(e2, "Problem while closing ResultSet or Statment.");
                }
            }
            if (resex != null) {
                throw resex;
            }
            break block38;
            {
                catch (SQLException e) {
                    block37: {
                        resex = new PExceptionIO(e, "SQL problem while reading the DSI.");
                        Object var20_24 = null;
                        if (!withPrefetch) {
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                                if (pstmt != null) {
                                    pstmt.close();
                                }
                            }
                            catch (SQLException e2) {
                                if (resex != null) break block37;
                                resex = new PExceptionIO(e2, "Problem while closing ResultSet or Statment.");
                            }
                        }
                    }
                    if (resex != null) {
                        throw resex;
                    }
                    break block38;
                }
                catch (IOException e) {
                    block39: {
                        resex = new PExceptionIO(e, "Stream IO problem while reading the DSI.");
                        Object var20_25 = null;
                        if (!withPrefetch) {
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                                if (pstmt != null) {
                                    pstmt.close();
                                }
                            }
                            catch (SQLException e2) {
                                if (resex != null) break block39;
                                resex = new PExceptionIO(e2, "Problem while closing ResultSet or Statment.");
                            }
                        }
                    }
                    if (resex != null) {
                        throw resex;
                    }
                }
            }
            catch (Throwable throwable) {
                block40: {
                    Object var20_26 = null;
                    if (!withPrefetch) {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            if (pstmt != null) {
                                pstmt.close();
                            }
                        }
                        catch (SQLException e2) {
                            if (resex != null) break block40;
                            resex = new PExceptionIO(e2, "Problem while closing ResultSet or Statment.");
                        }
                    }
                }
                if (resex != null) {
                    throw resex;
                }
                throw throwable;
            }
        }
        ((PBindingCtrl)pb).setStatus(nextstate);
    }

    public void write(PBinding pb, Object conn, PAccessor pa) throws PException {
        PGenClassAccessor paccessorGenClass = (PGenClassAccessor)pa;
        byte status = pb.getStatus();
        byte nextstate = PStateGraph.nextStatePBinding(status, (byte)7);
        if (nextstate == 5) {
            throw new PExceptionProtocol("Cannot perform write on this GenClass PBinding: " + status);
        }
        if (this.readOnly) {
            ((PBindingCtrl)pb).setStatus(nextstate);
            return;
        }
        try {
            Connection sqlconn = RdbConnectionWrapper.narrow2SQL(conn);
            switch (status) {
                case 3: {
                    this.createGcObject(pb.getPName(), sqlconn, paccessorGenClass);
                    break;
                }
                case 2: {
                    this.deleteGcObject(pb.getPName(), sqlconn);
                    break;
                }
                case 1: {
                    if (paccessorGenClass.paDeltaSupported()) {
                        this.updateGcObject(pb.getPName(), sqlconn, paccessorGenClass);
                        break;
                    }
                    this.deleteGcObject(pb.getPName(), sqlconn);
                    this.createGcObject(pb.getPName(), sqlconn, paccessorGenClass);
                    break;
                }
                default: {
                    throw new PExceptionProtocol("unmanaged status: " + status);
                }
            }
        }
        catch (SQLException e) {
            throw new PExceptionIO(e, "SQL problem while writing the DSI.");
        }
        catch (IOException e) {
            throw new PExceptionIO(e, "Stream IO problem while writing the DSI.");
        }
        ((PBindingCtrl)pb).setStatus(nextstate);
    }

    public void setTableName(String tn) {
        this.tableName = tn;
    }

    public void setRefExtTableName(String retn) {
        this.refExtTableName = retn;
    }

    public void setColocated(boolean colocated) {
        this.colocated = colocated;
    }

    public void setColocatedMaster(boolean cm) {
        this.colocatedMaster = cm;
    }

    public void setReadOnly(boolean readonly) {
        this.readOnly = readonly;
    }

    public void setTypeConverter(RdbAdapter tc) {
        this.typeConverter = tc;
        if (this.typeConverter != null) {
            this.useBatch = this.typeConverter.supportBatchPreparedStatement();
        }
    }

    public void defineJoinColumns(String[] maincols, String[] extcols) {
        this.mainCols = maincols;
        this.extCols = extcols;
        if (this.mainCols.length != this.extCols.length) {
            throw new RuntimeException("Need arrays with same size!!");
        }
    }

    public void setPrefetchElementPCM(RdbPrefetchablePCM pcm) {
        this.prefetchedPCM = pcm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createGcObject(PName pName, Connection sqlconn, PGenClassAccessor paccessorGenClass) throws SQLException, PException, IOException {
        PreparedStatement pstmt_upd;
        block11: {
            int size = paccessorGenClass.paGetNbElem();
            if (size == 0) {
                return;
            }
            PreparedStatement pstmt_ins = null;
            pstmt_upd = null;
            try {
                if (this.colocated) {
                    pstmt_upd = sqlconn.prepareStatement(this.getUpdateQuery());
                }
                pstmt_ins = sqlconn.prepareStatement(this.getInsertQuery());
                Iterator iterelem = paccessorGenClass.paIterator();
                boolean batchused = false;
                while (iterelem.hasNext()) {
                    int paramindex;
                    PIndexedElem pie = (PIndexedElem)iterelem.next();
                    if (this.colocated) {
                        paramindex = this.defineIdentifierVal(pName, pstmt_upd, 1);
                        paramindex = this.defineIndexVal(pie, pstmt_upd, paramindex);
                        this.defineElemVal(pie, pstmt_upd, paramindex);
                        if (pstmt_upd.executeUpdate() > 0) continue;
                    }
                    paramindex = this.defineIdentifierVal(pName, pstmt_ins, 1);
                    paramindex = this.defineElemVal(pie, pstmt_ins, paramindex);
                    this.defineIndexVal(pie, pstmt_ins, paramindex);
                    if (this.useBatch && !this.colocated) {
                        batchused = true;
                        pstmt_ins.addBatch();
                        continue;
                    }
                    pstmt_ins.execute();
                }
                if (batchused && this.useBatch) {
                    pstmt_ins.executeBatch();
                }
                Object var12_11 = null;
                if (pstmt_ins == null) break block11;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (pstmt_ins != null) {
                    pstmt_ins.close();
                }
                if (pstmt_upd != null) {
                    pstmt_upd.close();
                }
                throw throwable;
            }
            pstmt_ins.close();
        }
        if (pstmt_upd != null) {
            pstmt_upd.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteGcObject(PName pName, Connection sqlconn) throws SQLException, PException, IOException {
        Statement pstmt = null;
        try {
            pstmt = sqlconn.prepareStatement(this.colocated ? this.getUpdateNullAllQuery() : this.getDeleteAllQuery());
            this.defineIdentifierVal(pName, (PreparedStatement)pstmt, 1);
            pstmt.execute();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGcObject(PName pName, Connection sqlconn, PGenClassAccessor paccessorGenClass) throws SQLException, PException, IOException {
        Statement pstmt_upd_null;
        Statement pstmt_upd;
        Statement pstmt_del;
        block34: {
            Statement pstmt_ins = null;
            pstmt_del = null;
            pstmt_upd = null;
            pstmt_upd_null = null;
            try {
                Iterator iterelem = paccessorGenClass.paIterator();
                block8: while (iterelem.hasNext()) {
                    PIndexedElem pie = (PIndexedElem)iterelem.next();
                    switch (pie.getElemStatus()) {
                        case 1: {
                            int paramindex;
                            if (pstmt_ins == null) {
                                pstmt_ins = sqlconn.prepareStatement(this.getInsertQuery());
                            }
                            if (this.colocated) {
                                if (pstmt_upd == null) {
                                    pstmt_upd = sqlconn.prepareStatement(this.getUpdateQuery());
                                }
                                paramindex = this.defineElemVal(pie, (PreparedStatement)pstmt_upd, 1);
                                paramindex = this.defineIdentifierVal(pName, (PreparedStatement)pstmt_upd, paramindex);
                                this.defineIndexVal(pie, (PreparedStatement)pstmt_upd, paramindex);
                                if (pstmt_upd.executeUpdate() != 0) continue block8;
                                paramindex = this.defineIdentifierVal(pName, (PreparedStatement)pstmt_ins, 1);
                                paramindex = this.defineElemVal(pie, (PreparedStatement)pstmt_ins, paramindex);
                                this.defineIndexVal(pie, (PreparedStatement)pstmt_ins, paramindex);
                                pstmt_ins.execute();
                                continue block8;
                            }
                            paramindex = this.defineIdentifierVal(pName, (PreparedStatement)pstmt_ins, 1);
                            paramindex = this.defineElemVal(pie, (PreparedStatement)pstmt_ins, paramindex);
                            this.defineIndexVal(pie, (PreparedStatement)pstmt_ins, paramindex);
                            if (this.useBatch) {
                                pstmt_ins.addBatch();
                                continue block8;
                            }
                            pstmt_ins.execute();
                            continue block8;
                        }
                        case 2: {
                            int paramindex;
                            if (this.colocated) {
                                if (pstmt_upd_null == null) {
                                    pstmt_upd_null = sqlconn.prepareStatement(this.getUpdateNullElemQuery());
                                }
                                paramindex = this.defineIdentifierVal(pName, (PreparedStatement)pstmt_upd_null, 1);
                                paramindex = this.defineIndexVal(pie, (PreparedStatement)pstmt_upd_null, paramindex);
                                this.defineElemVal(pie, (PreparedStatement)pstmt_upd_null, paramindex);
                                if (this.useBatch) {
                                    pstmt_upd_null.addBatch();
                                    continue block8;
                                }
                                pstmt_upd_null.execute();
                                continue block8;
                            }
                            if (pstmt_del == null) {
                                pstmt_del = sqlconn.prepareStatement(this.getDeleteElemQuery());
                            }
                            paramindex = this.defineIdentifierVal(pName, (PreparedStatement)pstmt_del, 1);
                            paramindex = this.defineIndexVal(pie, (PreparedStatement)pstmt_del, paramindex);
                            this.defineElemVal(pie, (PreparedStatement)pstmt_del, paramindex);
                            if (this.useBatch) {
                                pstmt_del.addBatch();
                                continue block8;
                            }
                            pstmt_del.execute();
                            continue block8;
                        }
                        case 3: {
                            int paramindex;
                            if (pstmt_upd == null) {
                                pstmt_upd = sqlconn.prepareStatement(this.getUpdateQuery());
                            }
                            if (this.colocated) {
                                paramindex = this.defineIdentifierVal(pName, (PreparedStatement)pstmt_upd, 1);
                                paramindex = this.defineIndexVal(pie, (PreparedStatement)pstmt_upd, paramindex);
                                this.defineElemVal(pie, (PreparedStatement)pstmt_upd, paramindex);
                            } else {
                                paramindex = this.defineElemVal(pie, (PreparedStatement)pstmt_upd, 1);
                                paramindex = this.defineIdentifierVal(pName, (PreparedStatement)pstmt_upd, paramindex);
                                this.defineIndexVal(pie, (PreparedStatement)pstmt_upd, paramindex);
                            }
                            if (this.useBatch) {
                                pstmt_upd.addBatch();
                                continue block8;
                            }
                            pstmt_upd.execute();
                            continue block8;
                        }
                        case 4: {
                            continue block8;
                        }
                    }
                    throw new PExceptionProtocol("Unknown modification status for PIndexedElem.");
                }
                if (this.useBatch) {
                    if (pstmt_ins != null) {
                        pstmt_ins.executeBatch();
                    }
                    if (pstmt_upd_null != null) {
                        pstmt_upd_null.executeBatch();
                    }
                    if (pstmt_del != null) {
                        pstmt_del.executeBatch();
                    }
                    if (pstmt_upd != null) {
                        pstmt_upd.executeBatch();
                    }
                }
                Object var12_11 = null;
                if (pstmt_ins == null) break block34;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (pstmt_ins != null) {
                    pstmt_ins.close();
                }
                if (pstmt_upd_null != null) {
                    pstmt_upd_null.close();
                }
                if (pstmt_del != null) {
                    pstmt_del.close();
                }
                if (pstmt_upd != null) {
                    pstmt_upd.close();
                }
                throw throwable;
            }
            pstmt_ins.close();
        }
        if (pstmt_upd_null != null) {
            pstmt_upd_null.close();
        }
        if (pstmt_del != null) {
            pstmt_del.close();
        }
        if (pstmt_upd != null) {
            pstmt_upd.close();
        }
    }

    void defineColumns(FieldDesc[] fields, StringBuffer sqlstring, short start) throws PExceptionProtocol {
        for (short i = start; i < fields.length; i = (short)(i + 1)) {
            RdbFieldDesc field = (RdbFieldDesc)fields[i];
            sqlstring.append(field.columnName);
            sqlstring.append(" ");
            try {
                sqlstring.append(this.typeConverter.getSqlType((short)field.type.getTypeCode(), true, field.size, field.scale));
            }
            catch (RdbAdapterException e) {
                throw new PExceptionProtocol(e, "Impossible to compute the column type of " + field.columnName);
            }
            sqlstring.append(SEPSCOL);
        }
    }

    boolean defineNames(FieldDesc[] fields, StringBuffer sqlstring, boolean firstname, short start, boolean ext, boolean withtabprefix) {
        for (short i = start; i < fields.length; i = (short)(i + 1)) {
            RdbFieldDesc field = (RdbFieldDesc)fields[i];
            if (!ext && field.isRefExtField) continue;
            if (firstname) {
                firstname = false;
            } else {
                sqlstring.append(SEPSCOL);
            }
            if (withtabprefix) {
                sqlstring.append(field.isRefExtField ? this.refExtTableName : this.tableName);
                sqlstring.append('.');
            }
            sqlstring.append(field.columnName);
        }
        return firstname;
    }

    boolean defineNames(FieldDesc[] fields, StringBuffer sqlstring, boolean firstname, short start) {
        return this.defineNames(fields, sqlstring, firstname, start, false, true);
    }

    void defineAllNames(StringBuffer sqlstring, byte whichnames) {
        boolean firstname = true;
        if ((whichnames & 1) == 1) {
            firstname = this.defineNames(this.identifierFields, sqlstring, firstname, (short)0);
        }
        if ((whichnames & 4) == 4) {
            firstname = this.defineNames(this.elemFields, sqlstring, firstname, this.elemFields.length != 1 ? (byte)1 : 0);
        }
        if ((whichnames & 2) == 2) {
            firstname = this.defineNames(this.indexFields, sqlstring, firstname, (short)0);
        }
        if ((whichnames & 8) == 8) {
            // empty if block
        }
    }

    void defineIdentifierClause(StringBuffer sqlstring) {
        if (this.identifierFields.length == 1) {
            sqlstring.append("(");
            sqlstring.append(this.tableName);
            sqlstring.append(".");
            sqlstring.append(((RdbFieldDesc)this.identifierFields[0]).columnName);
            sqlstring.append(ASSIGNVAL);
            sqlstring.append(")");
            return;
        }
        for (int i = 0; i < this.identifierFields.length; i = (int)((short)(i + 1))) {
            if (i != 0) {
                sqlstring.append(" ");
                sqlstring.append(SEPAND);
                sqlstring.append(" ");
            }
            sqlstring.append("(");
            sqlstring.append(this.tableName);
            sqlstring.append(".");
            sqlstring.append(((RdbFieldDesc)this.identifierFields[i]).columnName);
            sqlstring.append(ASSIGNVAL);
            sqlstring.append(")");
        }
    }

    void defineIndexClause(StringBuffer sqlstring) {
        for (int i = 0; i < this.indexFields.length; i = (int)((short)(i + 1))) {
            sqlstring.append(" ");
            sqlstring.append(SEPAND);
            sqlstring.append(" ");
            sqlstring.append("(");
            sqlstring.append(((RdbFieldDesc)this.indexFields[i]).columnName);
            sqlstring.append(ASSIGNVAL);
            sqlstring.append(")");
        }
    }

    void defineElemSet(StringBuffer sqlstring) {
        if (this.elemFields.length == 1) {
            sqlstring.append(((RdbFieldDesc)this.elemFields[0]).columnName);
            sqlstring.append(ASSIGNVAL);
        } else if (this.elemFields.length == 2) {
            sqlstring.append(((RdbFieldDesc)this.elemFields[1]).columnName);
            sqlstring.append(ASSIGNVAL);
        } else {
            for (int i = 1; i < this.elemFields.length; ++i) {
                if (((RdbFieldDesc)this.elemFields[i]).isRefExtField) continue;
                if (i != 1) {
                    sqlstring.append(SEPSCOL);
                }
                sqlstring.append(((RdbFieldDesc)this.elemFields[i]).columnName);
                sqlstring.append(ASSIGNVAL);
            }
        }
    }

    void defineIdentifierSetNull(StringBuffer sqlstring) {
        if (this.identifierFields.length == 1) {
            sqlstring.append(((RdbFieldDesc)this.identifierFields[0]).columnName);
            sqlstring.append(ASSIGN_NULL);
        } else {
            for (int i = 1; i < this.identifierFields.length; ++i) {
                if (i != 1) {
                    sqlstring.append(SEPSCOL);
                }
                sqlstring.append(((RdbFieldDesc)this.identifierFields[i]).columnName);
                sqlstring.append(ASSIGN_NULL);
            }
        }
    }

    void defineIdentifierSet(StringBuffer sqlstring) {
        if (this.identifierFields.length == 1) {
            sqlstring.append(((RdbFieldDesc)this.identifierFields[0]).columnName);
            sqlstring.append(ASSIGNVAL);
        } else {
            for (int i = 0; i < this.identifierFields.length; ++i) {
                if (i != 0) {
                    sqlstring.append(SEPSCOL);
                }
                sqlstring.append(((RdbFieldDesc)this.identifierFields[i]).columnName);
                sqlstring.append(ASSIGNVAL);
            }
        }
    }

    void defineIndexSetNull(StringBuffer sqlstring) {
        for (int i = 1; i < this.indexFields.length; ++i) {
            sqlstring.append(SEPSCOL);
            sqlstring.append(((RdbFieldDesc)this.indexFields[i]).columnName);
            sqlstring.append(ASSIGN_NULL);
        }
    }

    void defineIndexSet(StringBuffer sqlstring) {
        for (int i = 1; i < this.indexFields.length; ++i) {
            sqlstring.append(SEPSCOL);
            sqlstring.append(((RdbFieldDesc)this.indexFields[i]).columnName);
            sqlstring.append(ASSIGNVAL);
        }
    }

    int defineIdentifierVal(PName pname, PreparedStatement pstmt, int paramindex) throws PException, SQLException, IOException {
        if (this.identifierFields.length == 1) {
            if (!pname.codingSupported(CTHelper.ptc2ct(this.identifierFields[0].type.getTypeCode()))) {
                throw new PExceptionNaming("Coding format not supported: \n-pname=" + pname + "\n-identifier field type: " + this.identifierFields[0].type.getJormName() + "(coding type:" + CTHelper.ptc2ct(this.identifierFields[0].type.getTypeCode()) + ")");
            }
            this.defineValEncode(pname, pstmt, paramindex, this.identifierFields[0], ((RdbFieldDesc)this.identifierFields[0]).columnType);
            ++paramindex;
        } else {
            PNameGetter png = (PNameGetter)pname.encodeAbstract();
            for (int i = 0; i < this.identifierFields.length; i = (int)((short)(i + 1))) {
                this.defineValPng(png, pstmt, paramindex, this.identifierFields[i], ((RdbFieldDesc)this.identifierFields[i]).compositeName);
                ++paramindex;
            }
        }
        return paramindex;
    }

    int defineElemVal(PIndexedElem pie, PreparedStatement pstmt, int paramindex) throws PException, SQLException, IOException {
        if (this.elemFields.length == 1) {
            this.defineValBasic(pie, pstmt, paramindex, this.elemFields[0].type.getTypeCode());
            ++paramindex;
        } else if (this.elemFields.length == 2) {
            this.defineValEncode(pie.pieGetRefElem(), pstmt, paramindex, this.elemFields[1], ((RdbFieldDesc)this.elemFields[1]).columnType);
            ++paramindex;
        } else {
            PNameGetter png = (PNameGetter)pie.pieGetRefElem().encodeAbstract();
            for (int i = 1; i < this.elemFields.length; ++i) {
                if (((RdbFieldDesc)this.elemFields[i]).isRefExtField) continue;
                this.defineValPng(png, pstmt, paramindex, this.elemFields[i], ((RdbFieldDesc)this.elemFields[i]).compositeName);
                ++paramindex;
            }
        }
        return paramindex;
    }

    void defineElemClause(StringBuffer sqlstring, boolean isfirst) {
        if (this.elemFields.length == 1) {
            if (!isfirst) {
                sqlstring.append(" ");
                sqlstring.append(SEPAND);
                sqlstring.append(" ");
            }
            sqlstring.append("(");
            sqlstring.append(((RdbFieldDesc)this.elemFields[0]).columnName);
            sqlstring.append(ASSIGNVAL);
            sqlstring.append(")");
        } else {
            for (int i = 1; i < this.elemFields.length; i = (int)((short)(i + 1))) {
                if (((RdbFieldDesc)this.elemFields[i]).isRefExtField) continue;
                if (!isfirst || i > 1) {
                    sqlstring.append(" ");
                    sqlstring.append(SEPAND);
                    sqlstring.append(" ");
                }
                sqlstring.append("(");
                sqlstring.append(((RdbFieldDesc)this.elemFields[i]).columnName);
                sqlstring.append(ASSIGNVAL);
                sqlstring.append(")");
            }
        }
    }

    int defineIndexVal(PIndexedElem pie, PreparedStatement pstmt, int paramindex) throws PException, SQLException, IOException {
        for (int i = 0; i < this.indexFields.length; ++i) {
            this.defineValIndex(pie, pstmt, paramindex, this.indexFields[i], ((RdbFieldDesc)this.indexFields[i]).name);
            ++paramindex;
        }
        return paramindex;
    }

    void defineValBasic(PIndexedElem pie, PreparedStatement pstmt, int paramindex, int typecode) throws PException, SQLException, IOException {
        switch (typecode) {
            case 0: {
                this.typeConverter.setBoolean(pstmt, paramindex, pie.pieGetBooleanElem());
                break;
            }
            case 8: {
                this.typeConverter.setOboolean(pstmt, paramindex, pie.pieGetObooleanElem());
                break;
            }
            case 2: {
                this.typeConverter.setByte(pstmt, paramindex, pie.pieGetByteElem());
                break;
            }
            case 10: {
                this.typeConverter.setObyte(pstmt, paramindex, pie.pieGetObyteElem());
                break;
            }
            case 1: {
                this.typeConverter.setChar(pstmt, paramindex, pie.pieGetCharElem());
                break;
            }
            case 9: {
                this.typeConverter.setOchar(pstmt, paramindex, pie.pieGetOcharElem());
                break;
            }
            case 3: {
                this.typeConverter.setShort(pstmt, paramindex, pie.pieGetShortElem());
                break;
            }
            case 11: {
                this.typeConverter.setOshort(pstmt, paramindex, pie.pieGetOshortElem());
                break;
            }
            case 4: {
                this.typeConverter.setInt(pstmt, paramindex, pie.pieGetIntElem());
                break;
            }
            case 12: {
                this.typeConverter.setOint(pstmt, paramindex, pie.pieGetOintElem());
                break;
            }
            case 5: {
                this.typeConverter.setLong(pstmt, paramindex, pie.pieGetLongElem());
                break;
            }
            case 13: {
                this.typeConverter.setOlong(pstmt, paramindex, pie.pieGetOlongElem());
                break;
            }
            case 6: {
                this.typeConverter.setFloat(pstmt, paramindex, pie.pieGetFloatElem());
                break;
            }
            case 14: {
                this.typeConverter.setOfloat(pstmt, paramindex, pie.pieGetOfloatElem());
                break;
            }
            case 7: {
                this.typeConverter.setDouble(pstmt, paramindex, pie.pieGetDoubleElem());
                break;
            }
            case 15: {
                this.typeConverter.setOdouble(pstmt, paramindex, pie.pieGetOdoubleElem());
                break;
            }
            case 16: {
                this.typeConverter.setString(pstmt, paramindex, pie.pieGetStringElem());
                break;
            }
            case 17: {
                this.typeConverter.setDate(pstmt, paramindex, pie.pieGetDateElem(), ((RdbFieldDesc)this.elemFields[0]).columnType);
                break;
            }
            case 19: {
                this.typeConverter.setByteArray(pstmt, paramindex, pie.pieGetByteArrayElem());
                break;
            }
            case 18: {
                this.typeConverter.setCharArray(pstmt, paramindex, pie.pieGetCharArrayElem());
                break;
            }
            case 22: {
                this.typeConverter.setBigDecimal(pstmt, paramindex, pie.pieGetBigDecimalElem());
                break;
            }
            case 20: {
                this.typeConverter.setSerialized(pstmt, paramindex, pie.pieGetSerializedElem());
                break;
            }
            default: {
                throw new PExceptionTyping("Wrong field type.");
            }
        }
    }

    void defineValEncode(PName pname, PreparedStatement pstmt, int paramindex, FieldDesc fd, String sqlcoltype) throws PException, SQLException, IOException {
        switch (fd.type.getTypeCode()) {
            case 2: {
                this.typeConverter.setByte(pstmt, paramindex, pname.encodeByte());
                break;
            }
            case 10: {
                this.typeConverter.setObyte(pstmt, paramindex, pname.encodeObyte());
                break;
            }
            case 1: {
                this.typeConverter.setChar(pstmt, paramindex, pname.encodeChar());
                break;
            }
            case 9: {
                this.typeConverter.setOchar(pstmt, paramindex, pname.encodeOchar());
                break;
            }
            case 3: {
                this.typeConverter.setShort(pstmt, paramindex, pname.encodeShort());
                break;
            }
            case 11: {
                this.typeConverter.setOshort(pstmt, paramindex, pname.encodeOshort());
                break;
            }
            case 4: {
                this.typeConverter.setInt(pstmt, paramindex, pname.encodeInt());
                break;
            }
            case 12: {
                this.typeConverter.setOint(pstmt, paramindex, pname.encodeOint());
                break;
            }
            case 5: {
                this.typeConverter.setLong(pstmt, paramindex, pname.encodeLong());
                break;
            }
            case 13: {
                this.typeConverter.setOlong(pstmt, paramindex, pname.encodeOlong());
                break;
            }
            case 16: {
                this.typeConverter.setString(pstmt, paramindex, pname.encodeString());
                break;
            }
            case 17: {
                this.typeConverter.setDate(pstmt, paramindex, pname.encodeDate(), ((RdbFieldDesc)fd).columnType);
                break;
            }
            case 19: {
                this.typeConverter.setByteArray(pstmt, paramindex, pname.encode());
                break;
            }
            case 18: {
                this.typeConverter.setCharArray(pstmt, paramindex, pname.encodeCharArray());
                break;
            }
            default: {
                throw new PExceptionTyping("Wrong field type.");
            }
        }
    }

    void defineValPng(PNameGetter png, PreparedStatement pstmt, int paramindex, FieldDesc fd, String compfield) throws PException, SQLException, IOException {
        switch (fd.type.getTypeCode()) {
            case 2: {
                this.typeConverter.setByte(pstmt, paramindex, png.pngetByteField(compfield, null));
                break;
            }
            case 10: {
                this.typeConverter.setObyte(pstmt, paramindex, png.pngetObyteField(compfield, null));
                break;
            }
            case 1: {
                this.typeConverter.setChar(pstmt, paramindex, png.pngetCharField(compfield, null));
                break;
            }
            case 9: {
                this.typeConverter.setOchar(pstmt, paramindex, png.pngetOcharField(compfield, null));
                break;
            }
            case 3: {
                this.typeConverter.setShort(pstmt, paramindex, png.pngetShortField(compfield, null));
                break;
            }
            case 11: {
                this.typeConverter.setOshort(pstmt, paramindex, png.pngetOshortField(compfield, null));
                break;
            }
            case 4: {
                this.typeConverter.setInt(pstmt, paramindex, png.pngetIntField(compfield, null));
                break;
            }
            case 12: {
                this.typeConverter.setOint(pstmt, paramindex, png.pngetOintField(compfield, null));
                break;
            }
            case 5: {
                this.typeConverter.setLong(pstmt, paramindex, png.pngetLongField(compfield, null));
                break;
            }
            case 13: {
                this.typeConverter.setOlong(pstmt, paramindex, png.pngetOlongField(compfield, null));
                break;
            }
            case 16: {
                this.typeConverter.setString(pstmt, paramindex, png.pngetStringField(compfield, null));
                break;
            }
            case 17: {
                this.typeConverter.setDate(pstmt, paramindex, png.pngetDateField(compfield, null), ((RdbFieldDesc)fd).columnType);
                break;
            }
            case 19: {
                this.typeConverter.setByteArray(pstmt, paramindex, png.pngetByteArrayField(compfield, null));
                break;
            }
            case 18: {
                this.typeConverter.setCharArray(pstmt, paramindex, png.pngetCharArrayField(compfield, null));
                break;
            }
            default: {
                throw new PExceptionTyping("Wrong field type.");
            }
        }
    }

    void defineValIndex(PIndexedElem pie, PreparedStatement pstmt, int paramindex, FieldDesc fd, String indexfield) throws PException, SQLException, IOException {
        switch (fd.type.getTypeCode()) {
            case 2: {
                this.typeConverter.setByte(pstmt, paramindex, pie.pieGetByteIndexField(indexfield));
                break;
            }
            case 10: {
                this.typeConverter.setObyte(pstmt, paramindex, pie.pieGetObyteIndexField(indexfield));
                break;
            }
            case 1: {
                this.typeConverter.setChar(pstmt, paramindex, pie.pieGetCharIndexField(indexfield));
                break;
            }
            case 9: {
                this.typeConverter.setOchar(pstmt, paramindex, pie.pieGetOcharIndexField(indexfield));
                break;
            }
            case 3: {
                this.typeConverter.setShort(pstmt, paramindex, pie.pieGetShortIndexField(indexfield));
                break;
            }
            case 11: {
                this.typeConverter.setOshort(pstmt, paramindex, pie.pieGetOshortIndexField(indexfield));
                break;
            }
            case 4: {
                this.typeConverter.setInt(pstmt, paramindex, pie.pieGetIntIndexField(indexfield));
                break;
            }
            case 12: {
                this.typeConverter.setOint(pstmt, paramindex, pie.pieGetOintIndexField(indexfield));
                break;
            }
            case 5: {
                this.typeConverter.setLong(pstmt, paramindex, pie.pieGetLongIndexField(indexfield));
                break;
            }
            case 13: {
                this.typeConverter.setOlong(pstmt, paramindex, pie.pieGetOlongIndexField(indexfield));
                break;
            }
            case 16: {
                this.typeConverter.setString(pstmt, paramindex, pie.pieGetStringIndexField(indexfield));
                break;
            }
            case 17: {
                this.typeConverter.setDate(pstmt, paramindex, pie.pieGetDateIndexField(indexfield), ((RdbFieldDesc)fd).columnType);
                break;
            }
            default: {
                throw new PExceptionTyping("Wrong field type.");
            }
        }
    }

    public void init(PMappingCallback mapper, MetaObject metaclass) throws PException {
        super.init(mapper, metaclass);
    }

    void passValuesToAccessor(Object conn, ResultSet rs, PGenClassAccessor accessor, PNameGetter png, RdbTupleCollection tc, boolean prefetch) throws PException {
        PIndexedElem pie = accessor.createPIndexedElem();
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)"passValuesToAccessor");
        }
        try {
            int indexStart = (this.elemFields.length == 1 ? 2 : this.elemFields.length) + (prefetch ? this.nbPrefetchCol : 0);
            block46: for (int i = 0; i < this.indexFields.length; i = (int)((short)(i + 1))) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("index[" + i + "]:" + this.indexFields[i].name));
                }
                switch (this.indexFields[i].type.getTypeCode()) {
                    case 2: {
                        pie.pieSetByteIndexField(this.indexFields[i].name, this.typeConverter.getByte(rs, i + indexStart, (byte)-1));
                        continue block46;
                    }
                    case 10: {
                        pie.pieSetObyteIndexField(this.indexFields[i].name, this.typeConverter.getObyte(rs, i + indexStart, null));
                        continue block46;
                    }
                    case 1: {
                        pie.pieSetCharIndexField(this.indexFields[i].name, this.typeConverter.getChar(rs, i + indexStart, '\u0000'));
                        continue block46;
                    }
                    case 9: {
                        pie.pieSetOcharIndexField(this.indexFields[i].name, this.typeConverter.getOchar(rs, i + indexStart, null));
                        continue block46;
                    }
                    case 3: {
                        pie.pieSetShortIndexField(this.indexFields[i].name, this.typeConverter.getShort(rs, i + indexStart, (short)-1));
                        continue block46;
                    }
                    case 11: {
                        pie.pieSetOshortIndexField(this.indexFields[i].name, this.typeConverter.getOshort(rs, i + indexStart, null));
                        continue block46;
                    }
                    case 4: {
                        pie.pieSetIntIndexField(this.indexFields[i].name, this.typeConverter.getInt(rs, i + indexStart, -1));
                        continue block46;
                    }
                    case 12: {
                        pie.pieSetOintIndexField(this.indexFields[i].name, this.typeConverter.getOint(rs, i + indexStart, null));
                        continue block46;
                    }
                    case 5: {
                        pie.pieSetLongIndexField(this.indexFields[i].name, this.typeConverter.getLong(rs, i + indexStart, -1L));
                        continue block46;
                    }
                    case 13: {
                        pie.pieSetOlongIndexField(this.indexFields[i].name, this.typeConverter.getOlong(rs, i + indexStart, null));
                        continue block46;
                    }
                    case 16: {
                        pie.pieSetStringIndexField(this.indexFields[i].name, this.typeConverter.getString(rs, i + indexStart, null));
                        continue block46;
                    }
                    case 17: {
                        pie.pieSetDateIndexField(this.indexFields[i].name, this.typeConverter.getDate(rs, i + indexStart, ((RdbFieldDesc)this.indexFields[i]).columnType, null));
                        continue block46;
                    }
                    default: {
                        throw new PExceptionProtocol("Wrong type for an index field of a GenClass");
                    }
                }
            }
            int elemStart = 1 + (prefetch ? this.nbPrefetchCol : 0);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("element type:" + this.elemFields[0].type.getJormName()));
            }
            switch (this.elemFields[0].type.getTypeCode()) {
                case 0: {
                    pie.pieSetBooleanElem(this.typeConverter.getBoolean(rs, elemStart, false));
                    break;
                }
                case 8: {
                    pie.pieSetObooleanElem(this.typeConverter.getOboolean(rs, elemStart, null));
                    break;
                }
                case 1: {
                    pie.pieSetCharElem(this.typeConverter.getChar(rs, elemStart, '\u0000'));
                    break;
                }
                case 9: {
                    pie.pieSetOcharElem(this.typeConverter.getOchar(rs, elemStart, null));
                    break;
                }
                case 2: {
                    pie.pieSetByteElem(this.typeConverter.getByte(rs, elemStart, (byte)-1));
                    break;
                }
                case 10: {
                    pie.pieSetObyteElem(this.typeConverter.getObyte(rs, elemStart, null));
                    break;
                }
                case 3: {
                    pie.pieSetShortElem(this.typeConverter.getShort(rs, elemStart, (short)-1));
                    break;
                }
                case 11: {
                    pie.pieSetOshortElem(this.typeConverter.getOshort(rs, elemStart, null));
                    break;
                }
                case 4: {
                    pie.pieSetIntElem(this.typeConverter.getInt(rs, elemStart, -1));
                    break;
                }
                case 12: {
                    pie.pieSetOintElem(this.typeConverter.getOint(rs, elemStart, null));
                    break;
                }
                case 5: {
                    pie.pieSetLongElem(this.typeConverter.getLong(rs, elemStart, -1L));
                    break;
                }
                case 13: {
                    pie.pieSetOlongElem(this.typeConverter.getOlong(rs, elemStart, null));
                    break;
                }
                case 6: {
                    pie.pieSetFloatElem(this.typeConverter.getFloat(rs, elemStart, 0.0f));
                    break;
                }
                case 14: {
                    pie.pieSetOfloatElem(this.typeConverter.getOfloat(rs, elemStart, null));
                    break;
                }
                case 7: {
                    pie.pieSetDoubleElem(this.typeConverter.getDouble(rs, elemStart, 0.0));
                    break;
                }
                case 15: {
                    pie.pieSetOdoubleElem(this.typeConverter.getOdouble(rs, elemStart, null));
                    break;
                }
                case 16: {
                    pie.pieSetStringElem(this.typeConverter.getString(rs, elemStart, null));
                    break;
                }
                case 17: {
                    pie.pieSetDateElem(this.typeConverter.getDate(rs, elemStart, ((RdbFieldDesc)this.elemFields[0]).columnType, null));
                    break;
                }
                case 18: {
                    pie.pieSetCharArrayElem(this.typeConverter.getCharArray(rs, elemStart, null));
                    break;
                }
                case 19: {
                    pie.pieSetByteArrayElem(this.typeConverter.getByteArray(rs, elemStart, null));
                    break;
                }
                case 20: {
                    pie.pieSetSerializedElem(this.typeConverter.getSerialized(rs, elemStart, null));
                    break;
                }
                case 22: {
                    pie.pieSetBigDecimalElem(this.typeConverter.getBigDecimal(rs, elemStart, null));
                    break;
                }
                case 21: {
                    pie.pieSetBigIntegerElem(this.typeConverter.getBigInteger(rs, elemStart, null));
                    break;
                }
                case 23: {
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("reference size:" + (this.elemFields.length - 1)));
                    }
                    if (this.elemFields.length == 2) {
                        pie.pieSetRefElem(this.decodeSingle(this.elemFields[1], rs, elemStart));
                        break;
                    }
                    pie.pieSetRefElem(this.elemNameCoder.decodeAbstract(png, null));
                    break;
                }
                default: {
                    throw new PExceptionProtocol("Wrong type for an element field of a GenClass");
                }
            }
        }
        catch (SQLException e) {
            throw new PExceptionIO(e, "SQL problem while reading an element.");
        }
        catch (IOException e) {
            throw new PExceptionIO(e, "Stream IO problem while reading an element.");
        }
        catch (ClassNotFoundException e) {
            throw new PExceptionIO(e, "Deserialization problem while reading an element.");
        }
        if (tc != null) {
            try {
                tc.getPrefetchBuffer().addPrefetchTuple();
            }
            catch (MedorException e1) {
                throw new PException(e1);
            }
        }
        accessor.paAdd(pie, conn);
    }

    PNameGetter getPNameGetter(ResultSet rs, boolean prefetch) {
        if (this.elemFields.length < 2) {
            return null;
        }
        if (this.elemFields.length == 2 && (this.elemFields[1].compositeName == null || this.elemFields[1].compositeName.length() == 0)) {
            return null;
        }
        return new RdbGenClassNameGetter(null, rs, this.elemFields, prefetch ? this.nbPrefetchCol : 0, this.typeConverter);
    }

    PName decodeSingle(FieldDesc fd, ResultSet resultSet, int idx) throws PExceptionProtocol, PExceptionNaming, SQLException {
        switch (fd.type.getTypeCode()) {
            case 2: {
                return this.elemNameCoder.decodeByte(this.typeConverter.getByte(resultSet, idx, (byte)-1));
            }
            case 1: {
                return this.elemNameCoder.decodeChar(this.typeConverter.getChar(resultSet, idx, '\u0000'));
            }
            case 3: {
                return this.elemNameCoder.decodeShort(this.typeConverter.getShort(resultSet, idx, (short)-1));
            }
            case 4: {
                return this.elemNameCoder.decodeInt(this.typeConverter.getInt(resultSet, idx, -1));
            }
            case 5: {
                return this.elemNameCoder.decodeLong(this.typeConverter.getLong(resultSet, idx, -1L));
            }
            case 10: {
                return this.elemNameCoder.decodeObyte(this.typeConverter.getObyte(resultSet, idx, null));
            }
            case 9: {
                return this.elemNameCoder.decodeOchar(this.typeConverter.getOchar(resultSet, idx, null));
            }
            case 11: {
                return this.elemNameCoder.decodeOshort(this.typeConverter.getOshort(resultSet, idx, null));
            }
            case 12: {
                return this.elemNameCoder.decodeOint(this.typeConverter.getOint(resultSet, idx, null));
            }
            case 13: {
                return this.elemNameCoder.decodeOlong(this.typeConverter.getOlong(resultSet, idx, null));
            }
            case 16: {
                return this.elemNameCoder.decodeString(this.typeConverter.getString(resultSet, idx, null));
            }
            case 17: {
                return this.elemNameCoder.decodeDate(this.typeConverter.getDate(resultSet, idx, ((RdbFieldDesc)fd).columnType, null));
            }
            case 19: {
                return this.elemNameCoder.decode(this.typeConverter.getByteArray(resultSet, idx, null));
            }
            case 18: {
                return this.elemNameCoder.decodeCharArray(this.typeConverter.getCharArray(resultSet, idx, null));
            }
        }
        throw new PExceptionProtocol("The jorm naming does not manage this type " + fd.type.getJormName());
    }

    public HashMap getAssociationTable() {
        return null;
    }

    public void addAssociation(PClassMapping targetClass, int[] indexes) {
    }

    public int[] getIndexesTable(PClassMapping targetClass) {
        return null;
    }

    public PName resolve(Object conn, PName pname) throws PException {
        return null;
    }

    public boolean match(Object obj, boolean b) throws PException {
        return false;
    }

    public PName getDecodedPName(TupleCollection tc, PName pname, boolean b) throws PException {
        return null;
    }

    public void init(PMappingStructuresManager pmsm) throws PException {
    }

    public void classDefined(PMappingStructuresManager pmsm) throws PException {
    }
}

