/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.ReplayListener;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.howl.log.xa.XALogRecord;
import org.objectweb.howl.log.xa.XALogger;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.JotmRecovery;
import org.objectweb.jotm.RmRegistration;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionRecovery;
import org.objectweb.jotm.TransactionResourceManager;

public class TransactionRecoveryImpl
implements TransactionRecovery {
    private static transient TransactionRecoveryImpl unique = null;
    private static transient Map nameResourceManager = Collections.synchronizedMap(new HashMap());
    private static transient Map nameXAResource = Collections.synchronizedMap(new HashMap());
    private static transient JotmRecovery tmrecovery = null;
    private static transient boolean startrecoverycalled = false;
    private static transient XALogger xaLog = null;
    private static transient XACommittingTx rmCommitTx = null;
    private static transient Vector vRmRegistration = new Vector();
    private RmRegistration myrmRegistration = null;
    private static final String JOTM_BASE = "jotm.base";
    private static final String JONAS_BASE = "jonas.base";
    private static final String CONFIG_DIR = "conf";
    private static Properties systEnv = System.getProperties();
    private static String jonasBase = systEnv.getProperty("jonas.base");
    private static String jotmBase = systEnv.getProperty("jotm.base");
    private static String fileSeparator = systEnv.getProperty("file.separator");

    public TransactionRecoveryImpl() throws LogException, IOException, Exception {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("TransactionRecoveryImpl constructor");
        }
        unique = this;
        String myBase = null;
        if (jonasBase == null) {
            if (jotmBase == null) {
                if (!Current.getDefaultRecovery()) {
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug("JOTM Recovery is disabled");
                    }
                    return;
                }
            } else {
                myBase = jotmBase;
            }
        } else {
            myBase = jonasBase;
        }
        myBase = myBase.trim();
        String fileFullPathname = myBase + fileSeparator + CONFIG_DIR + fileSeparator + "jotm.properties";
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("JOTM properties file= " + fileFullPathname);
        }
        Properties howlprop = new Properties();
        try {
            FileInputStream inStr = new FileInputStream(fileFullPathname);
            systEnv.load(inStr);
        }
        catch (Exception e) {
            Current.setDefaultRecovery(false);
            return;
        }
        if (systEnv.getProperty("jotm.recovery.Enabled").trim().equalsIgnoreCase("true")) {
            Current.setDefaultRecovery(true);
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("JOTM Recovery is enabled");
            }
        } else {
            Current.setDefaultRecovery(false);
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("JOTM Recovery is disabled");
            }
            return;
        }
        String myhowlprop = null;
        myhowlprop = systEnv.getProperty("howl.log.ListConfiguration", "false");
        howlprop.put("listConfig", myhowlprop);
        myhowlprop = systEnv.getProperty("howl.log.BufferSize", "4");
        howlprop.put("bufferSize", myhowlprop);
        myhowlprop = systEnv.getProperty("howl.log.MinimumBuffers", "16");
        howlprop.put("minBuffers", myhowlprop);
        myhowlprop = systEnv.getProperty("howl.log.MaximumBuffers", "16");
        howlprop.put("maxBuffers", myhowlprop);
        myhowlprop = systEnv.getProperty("howl.log.MaximumBlocksPerFile", "200");
        howlprop.put("maxBlocksPerFile", myhowlprop);
        myhowlprop = systEnv.getProperty("howl.log.FileDirectory", systEnv.getProperty("basedir", "."));
        howlprop.put("logFileDir", myhowlprop);
        myhowlprop = systEnv.getProperty("howl.log.FileName", "howl");
        howlprop.put("logFileName", myhowlprop);
        myhowlprop = systEnv.getProperty("howl.log.MaximumFiles", "2");
        howlprop.put("maxLogFiles", myhowlprop);
        try {
            this.howlOpenLog(howlprop);
        }
        catch (Exception e) {
            TraceTm.jotm.warn("howlOpenLog: LogException occured in howlOpenLog() " + e.getMessage());
            Current.setDefaultRecovery(false);
            TraceTm.recovery.warn("JOTM Recovery is disabled");
            return;
        }
    }

    public static TransactionRecoveryImpl getTransactionRecovery() {
        return unique;
    }

    public JotmRecovery getJotmRecovery() {
        return tmrecovery;
    }

    public Vector getRmRegistration() {
        return vRmRegistration;
    }

    public void registerResourceManager(String rmName, XAResource rmXares, String info, Properties rmProperties, TransactionResourceManager trm) throws XAException {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("Register Resource Manager Properties " + rmName + rmProperties + " to Connection " + rmXares);
        }
        this.registerResourceManager(rmName, rmXares, info, trm);
    }

    public void registerResourceManager(String rmName, XAResource rmXares, String info, TransactionResourceManager tranrm) throws XAException {
        if (tranrm != null) {
            tranrm.returnXAResource(rmName, rmXares);
        }
        if (!Current.getDefaultRecovery()) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("JOTM Recovery is disabled");
            }
            return;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("Register Resource Manager " + rmName + " to Connection " + rmXares);
        }
        XAResource xares = null;
        String hash_key = new String(rmName);
        Object myrmXares = nameResourceManager.get(hash_key);
        if (myrmXares == null) {
            nameResourceManager.put(hash_key, rmXares);
        } else {
            xares = (XAResource)myrmXares;
            if (xares.equals(rmXares)) {
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug(rmName + " already registered");
                    return;
                }
            } else {
                nameResourceManager.put(hash_key, rmXares);
            }
        }
        this.myrmRegistration = new RmRegistration();
        this.myrmRegistration.rmAddRegistration(rmName, rmXares, rmXares.getClass().getName());
        vRmRegistration.addElement(this.myrmRegistration);
        if (startrecoverycalled) {
            try {
                this.startResourceManagerRecovery();
            }
            catch (XAException e) {
                throw new XAException("startResourceManagerRecovery failed" + e.getMessage());
            }
        }
    }

    public XAResource reportResourceManager(String rmName) throws XAException {
        String hash_key;
        XAResource myXares;
        if (!Current.getDefaultRecovery()) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("JOTM Recovery is disabled");
            }
            return null;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("get Connection from Resource Manager " + rmName);
        }
        if ((myXares = (XAResource)nameResourceManager.get(hash_key = new String(rmName))) == null) {
            throw new XAException("Named Resource Manager " + rmName + " does not exist");
        }
        return myXares;
    }

    public void unregisterResourceManager(String rmName, XAResource rmXares) throws XAException {
        String hash_key;
        XAResource myrmXares;
        if (!Current.getDefaultRecovery()) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("JOTM Recovery is disabled");
            }
            return;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("Remove Resource Manager " + rmName + " from Connection " + rmXares);
        }
        if (!(myrmXares = (XAResource)nameResourceManager.get(hash_key = new String(rmName))).equals(rmXares)) {
            throw new XAException("Resource Manager " + rmName + " not associated to " + rmXares);
        }
        nameResourceManager.remove(hash_key);
    }

    public void startResourceManagerRecovery() throws XAException {
        if (!Current.getDefaultRecovery()) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("JOTM Recovery is disabled");
            }
            return;
        }
        int rmcount = vRmRegistration.size();
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("LogResourceManager count= " + rmcount);
        }
        if (rmcount == 0) {
            return;
        }
        XACommittingTx myrmCommitTx = null;
        byte[][] rmBuffer = new byte[rmcount + 1][];
        byte[] rmRecord1 = null;
        byte[] rmRecord2 = null;
        String resm1 = "RM1";
        String resm2 = "RM2";
        long rmdate = System.currentTimeMillis();
        rmRecord1 = new byte[15];
        ByteBuffer rm1 = ByteBuffer.wrap(rmRecord1);
        rm1.put(resm1.getBytes());
        rm1.putLong(rmdate);
        rm1.putInt(rmcount);
        rmBuffer[0] = rm1.array();
        for (int i = 0; i < rmcount; ++i) {
            this.myrmRegistration = (RmRegistration)vRmRegistration.elementAt(i);
            String rmName = this.myrmRegistration.rmGetName();
            XAResource xaRes = this.myrmRegistration.rmGetXaRes();
            String xaresName = this.myrmRegistration.rmGetXaResName();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("LogResourceManager rmName= " + rmName);
                TraceTm.recovery.debug("    xaRes= " + xaresName);
                TraceTm.recovery.debug("    rmIndex= " + i);
            }
            int rmlength = rmName.length();
            int xaReslength = xaRes.toString().length();
            int xaResNamelength = xaresName.length();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("rm length=" + rmlength);
                TraceTm.recovery.debug("xaRes length= " + xaReslength);
            }
            rmRecord2 = new byte[7 + rmlength + 4 + xaReslength + 4 + xaResNamelength + 4];
            ByteBuffer rm2 = ByteBuffer.wrap(rmRecord2);
            rm2.put(resm2.getBytes());
            rm2.putInt(rmlength);
            rm2.put(rmName.getBytes());
            rm2.putInt(xaReslength);
            rm2.put(xaRes.toString().getBytes());
            rm2.putInt(xaResNamelength);
            rm2.put(xaresName.getBytes());
            rm2.putInt(i);
            rmBuffer[i + 1] = rm2.array();
        }
        try {
            myrmCommitTx = this.howlCommitLog(rmBuffer);
        }
        catch (Exception e) {
            String howlerror = "Cannot howlCommitLog:" + e + " --" + e.getMessage();
            TraceTm.jotm.error("Got LogException from howlCommitLog: " + howlerror);
            rmCommitTx = null;
            throw new XAException(howlerror);
        }
        if (rmCommitTx != null) {
            byte[] rmDone = new byte[11];
            byte[][] rmDoneRecord = new byte[1][11];
            rmDone = "RM3JOTMDONE".getBytes();
            try {
                rmDoneRecord[0] = rmDone;
                this.howlDoneLog(rmDoneRecord, rmCommitTx);
            }
            catch (Exception f) {
                String howlerror = "Cannot howlDoneLog:" + f + "--" + f.getMessage();
                TraceTm.jotm.error("Got LogException from howlDoneLog: " + howlerror);
            }
        }
        rmCommitTx = myrmCommitTx;
        try {
            this.recoverResourceManager();
        }
        catch (XAException e) {
            throw new XAException("Cannot perform recovery " + e.getMessage());
        }
        startrecoverycalled = true;
    }

    public void recoverResourceManager() throws XAException {
        if (!Current.getDefaultRecovery()) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("JOTM Recovery is disabled");
            }
            return;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("recoverResourceManager");
        }
        if (vRmRegistration.size() == 0) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("Nothing to recover");
            }
            return;
        }
        try {
            tmrecovery.recoverTransactions(vRmRegistration);
        }
        catch (XAException e) {
            throw new XAException("Unable to recover transactions" + e.getMessage());
        }
    }

    synchronized void howlOpenLog(Properties phowlprop) throws SystemException {
        if (xaLog != null) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("Howl Log already opened");
            }
            return;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("Open howl log");
        }
        try {
            Configuration cfg = new Configuration(phowlprop);
            xaLog = new XALogger(cfg);
        }
        catch (LogConfigurationException e) {
            TraceTm.jotm.error("XALogger: LogConfigurationException");
            throw new SystemException("LogConfigurationException occured in XALogger() " + e.getMessage());
        }
        catch (IOException e) {
            TraceTm.jotm.error("XALogger: IOException");
            throw new SystemException("IOException occured in XALogger() " + e.getMessage());
        }
        catch (Exception e) {
            TraceTm.jotm.error("XALogger: Exception");
            throw new SystemException("Exeception occurred in XALogger() " + e.getMessage());
        }
        tmrecovery = new JotmRecovery();
        xaReplayListener myxarl = new xaReplayListener();
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("xaLog.open");
        }
        try {
            xaLog.open(null);
        }
        catch (LogException e) {
            TraceTm.jotm.error("xaLog.open: LogException");
            throw new SystemException("LogException occured in xaLog.open() " + e.getMessage());
        }
        catch (IOException e) {
            TraceTm.jotm.error("xaLog.open: IOException");
            throw new SystemException("IOException occured in xaLog.open() " + e.getMessage());
        }
        catch (InterruptedException e) {
            TraceTm.jotm.error("xaLog.open: InterruptedException");
            throw new SystemException("InterruptedException occured in xaLog.open() " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            TraceTm.jotm.error("xaLog.open: ClassNotFoundException");
            throw new SystemException("ClassNotFoundException occured in xaLog.open() " + e.getMessage());
        }
        catch (Exception e) {
            TraceTm.jotm.error("xaLog.open: Exception " + e.getMessage());
            throw new SystemException("Exception occurred in xaLog.open() " + e.getMessage());
        }
        xaLog.replayActiveTx(myxarl);
    }

    void howlCloseLog() throws SystemException {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("Close howl log");
        }
        if (xaLog == null) {
            return;
        }
        try {
            xaLog.close();
        }
        catch (IOException e) {
            TraceTm.jotm.error("xaLog.close: IOException");
            throw new SystemException("IOException occured in xaLog.close() " + e.getMessage());
        }
        catch (InterruptedException e) {
            TraceTm.jotm.error("xaLog.close: InterruptedException");
            throw new SystemException("InterruptedException occured in xaLog.close() " + e.getMessage());
        }
        xaLog = null;
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("Howl log closed");
        }
    }

    public XACommittingTx howlCommitLog(byte[][] xaCmRec) throws LogException, Exception {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("Commit howl log");
        }
        return xaLog.putCommit(xaCmRec);
    }

    public void howlDoneLog(byte[][] xaDnRec, XACommittingTx xaCmTx) throws LogException, Exception {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("Done howl log");
        }
        xaLog.putDone(xaDnRec, xaCmTx);
    }

    public void forget() throws LogException, Exception {
        if (!Current.getDefaultRecovery()) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("JOTM Recovery is disabled");
            }
        } else {
            this.howlCloseLog();
        }
    }

    private class xaReplayListener
    implements ReplayListener {
        private xaReplayListener() {
        }

        public void onRecord(LogRecord lr) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("LogRecord type= " + lr.type);
            }
            switch (lr.type) {
                case 19979: {
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug("Howl End of Buffer Record");
                    break;
                }
                case 19983: {
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug("Howl End of Log Record");
                    break;
                }
                case 16512: {
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug("Howl XA Commit Record");
                    }
                    tmrecovery.rebuildTransaction((XALogRecord)lr);
                    break;
                }
                case 16448: {
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug("Howl XA Done Record");
                    break;
                }
                case 0: {
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug("Howl User Record");
                    break;
                }
                default: {
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug("Unknown Howl LogRecord");
                }
            }
        }

        public void onError(LogException exception) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("onError");
            }
        }

        public LogRecord getLogRecord() {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("getLogRecord");
            }
            return new XALogRecord(120);
        }
    }
}

