/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.HandlerFactory;
import org.objectweb.util.monolog.api.LevelFactory;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.file.monolog.PropertiesConfAccess;
import org.objectweb.util.monolog.wrapper.printwriter.LoggerImpl;

public class Log
implements LoggerFactory {
    public static final boolean DEBUG = false;
    public static final String MEDOR_PREFIX = "org.objectweb.medor";
    public static LoggerFactory loggerFactory = new LoggerImpl();
    public static final String DEFAULT_LOGGER_FACTORY = "org.objectweb.util.monolog.wrapper.printwriter.LoggerImpl";
    private static LoggerFactory lastLF = null;
    private LoggerFactory delegate = null;
    private String pfn = null;

    public static LoggerFactory getLoggerFactory(String lfClassName) throws Exception {
        if (lfClassName == null) {
            return (LoggerFactory)Class.forName(DEFAULT_LOGGER_FACTORY).newInstance();
        }
        return (LoggerFactory)Class.forName(lfClassName).newInstance();
    }

    public static LoggerFactory loadLoggerFactory(String propFileName) throws Exception {
        if (propFileName == null) {
            return (LoggerFactory)Class.forName(DEFAULT_LOGGER_FACTORY).newInstance();
        }
        File f = new File(propFileName);
        if (f.exists()) {
            Properties p = new Properties();
            p.load(new FileInputStream(propFileName));
            return Log.loadLoggerFactory(p);
        }
        InputStream is = ClassLoader.getSystemResourceAsStream(propFileName);
        if (is != null) {
            Properties p = new Properties();
            p.load(is);
            return Log.loadLoggerFactory(p);
        }
        throw new FileNotFoundException(propFileName + " was not found");
    }

    public static LoggerFactory loadLoggerFactory(Properties prop) throws Exception {
        if (prop == null) {
            return (LoggerFactory)Class.forName(DEFAULT_LOGGER_FACTORY).newInstance();
        }
        String lfn = prop.getProperty("log.config.classname", DEFAULT_LOGGER_FACTORY);
        LoggerFactory factory = (LoggerFactory)Class.forName(lfn).newInstance();
        if (factory instanceof HandlerFactory && factory instanceof LevelFactory) {
            PropertiesConfAccess.load(prop, factory, (HandlerFactory)((Object)factory), (LevelFactory)((Object)factory));
        }
        return factory;
    }

    public static LoggerFactory getLoggerFactory() {
        if (lastLF == null || lastLF == Monolog.getDefaultMonologFactory()) {
            lastLF = Monolog.initialize();
        }
        return lastLF;
    }

    public String getPropertiesFileName() {
        return this.pfn;
    }

    public void setPropertiesFileName(String propfn) {
        if (this.pfn != null && this.pfn.equals(propfn)) {
            return;
        }
        this.pfn = propfn;
        try {
            this.delegate = Log.loadLoggerFactory(this.pfn);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.delegate = Log.loadLoggerFactory((String)null);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        lastLF = this;
    }

    public Logger getLogger(String s) {
        return this.delegate.getLogger(s);
    }

    public Logger getLogger(String s, String s1) {
        return this.delegate.getLogger(s1);
    }

    public String getResourceBundleName() {
        return this.delegate.getResourceBundleName();
    }

    public void setResourceBundleName(String s) {
        this.delegate.setResourceBundleName(s);
    }

    public Logger[] getLoggers() {
        return this.delegate.getLoggers();
    }
}

