/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class DirsCompileClassLoader
extends ClassLoader {
    private long bytecount;
    private Hashtable cache = new Hashtable();
    private HashSet pathList = new HashSet();

    public DirsCompileClassLoader(HashSet classpaths) {
        this.pathList = classpaths;
    }

    private byte[] loadClassData(String name) throws ClassNotFoundException {
        byte[] data = null;
        try {
            String path = this.getJavaPathClass(name);
            File cf = new File(path + File.separatorChar + name.replace('.', File.separatorChar) + ".class");
            FileInputStream in = new FileInputStream(cf);
            this.bytecount = cf.length();
            if (this.bytecount > 0L) {
                data = new byte[(int)this.bytecount];
                in.read(data);
                in.close();
            }
        }
        catch (IOException ioexp) {
            throw new ClassNotFoundException(name);
        }
        return data;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = (Class<?>)this.cache.get(name);
        System.out.println("Loading ..." + name);
        if (c == null) {
            try {
                System.out.println("First try default System loading class... ");
                c = this.findSystemClass(name);
            }
            catch (ClassNotFoundException e) {
                System.err.println("System loading... failed when loading  " + name);
            }
            if (c == null) {
                if (!this.isClass(name) && this.isJavaSource(name)) {
                    Runtime rt = Runtime.getRuntime();
                    try {
                        System.out.println("Launching javac ..." + this.pathList);
                        String classpath = "";
                        Iterator i = this.pathList.iterator();
                        if (i.hasNext()) {
                            classpath = classpath + (String)i.next();
                        }
                        while (i.hasNext()) {
                            classpath = classpath + ";" + (String)i.next();
                        }
                        String cmd = "javac -classpath " + classpath + " " + this.getJavaSourcePath(name) + File.separatorChar + name.replace('.', File.separatorChar) + ".java";
                        System.out.println(cmd);
                        Process p = rt.exec(cmd);
                        p.waitFor();
                        System.out.println("Compilation finisched ...");
                    }
                    catch (IOException e) {
                        System.err.println(" Compilation failed... " + e.getMessage());
                    }
                    catch (InterruptedException e) {
                        System.err.println(" Compilation failed... " + e.getMessage());
                    }
                    c = this.loadClass(name, resolve);
                } else if (this.isClass(name)) {
                    System.err.println("Try loading class data bytes... " + name);
                    byte[] data = this.loadClassData(name);
                    if (data != null) {
                        System.out.println("Byte class loaded...try to define class now");
                        c = this.defineClass(name, data, 0, (int)this.bytecount);
                        if (resolve && c != null) {
                            this.resolveClass(c);
                        }
                    }
                } else {
                    throw new ClassNotFoundException(name);
                }
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        this.cache.put(name, c);
        return c;
    }

    private boolean isClass(String name) {
        boolean isClass = false;
        Iterator it = this.pathList.iterator();
        String dir2 = null;
        while (it.hasNext() & !isClass) {
            dir2 = (String)it.next();
            File cf = new File(dir2 + File.separatorChar + name.replace('.', File.separatorChar) + ".class");
            if (!cf.exists()) continue;
            isClass = true;
        }
        return isClass;
    }

    private boolean isJavaSource(String name) {
        boolean isSource = false;
        Iterator it = this.pathList.iterator();
        String dir2 = null;
        while (it.hasNext() && !isSource) {
            dir2 = (String)it.next();
            File cf = new File(dir2 + File.separator + name.replace('.', File.separatorChar) + ".java");
            if (!cf.exists()) continue;
            isSource = true;
        }
        return isSource;
    }

    private String getJavaSourcePath(String name) {
        Iterator it = this.pathList.iterator();
        String dir2 = null;
        boolean trouv = false;
        while (it.hasNext() && !trouv) {
            dir2 = (String)it.next();
            File sf = new File(dir2 + File.separatorChar + name.replace('.', File.separatorChar) + ".java");
            if (!sf.exists()) continue;
            trouv = true;
        }
        if (trouv) {
            return dir2;
        }
        return null;
    }

    private String getJavaPathClass(String name) {
        Iterator it = this.pathList.iterator();
        String dir2 = null;
        boolean trouv = false;
        while (it.hasNext() && !trouv) {
            dir2 = (String)it.next();
            File sf = new File(dir2 + File.separatorChar + name.replace('.', File.separatorChar) + ".class");
            if (!sf.exists()) continue;
            trouv = true;
        }
        if (trouv) {
            return dir2;
        }
        return null;
    }
}

