/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.rmi.jrmp.interceptor.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.ow2.carol.rmi.jrmp.interceptor.api.JServerRequestInfo;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JContextStore;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorHelper;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JRMPServerRequestInfoImpl;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JServerRequestInterceptor;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JServiceContext;
import org.ow2.carol.util.configuration.TraceCarol;

public class JServerInterceptorHelper
extends JInterceptorHelper {
    private static InheritableThreadLocal<Object> threadCtx = new InheritableThreadLocal();

    public static void receive_request(ObjectInput in, JServerRequestInterceptor[] sis) throws IOException {
        try {
            int ctxValue = in.readInt();
            JRMPServerRequestInfoImpl jsr = new JRMPServerRequestInfoImpl();
            if (sis == null || sis.length == 0) {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JServerInterceptorHelper receive request without interceptors");
                }
                JServerInterceptorHelper.getRequestServerContextFromInput(in, ctxValue, jsr);
            } else {
                if (TraceCarol.isDebugRmiCarol()) {
                    TraceCarol.debugRmiCarol("JServerInterceptorHelper receive request contexts");
                }
                JServerRequestInfo ri = JServerInterceptorHelper.getRequestServerContextFromInput(in, ctxValue, jsr);
                for (int i = 0; i < sis.length; ++i) {
                    sis[i].receive_request(ri);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("" + cnfe);
        }
    }

    public static void send_reply(ObjectOutput out, JServerRequestInterceptor[] sis) throws IOException {
        if (sis == null || sis.length == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send reply without context");
            }
            out.writeInt(0);
        } else {
            JRMPServerRequestInfoImpl jsr = new JRMPServerRequestInfoImpl();
            for (int i = 0; i < sis.length; ++i) {
                sis[i].send_reply(jsr);
            }
            JServerInterceptorHelper.setServerContextInOutput(out, jsr, JServerInterceptorHelper.isLocal());
            threadCtx.set(null);
        }
        out.flush();
    }

    public static void send_exception(ObjectOutput out, JServerRequestInterceptor[] sis) throws IOException {
        if (sis == null || sis.length == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send exception without context");
            }
            out.writeInt(0);
        } else {
            JRMPServerRequestInfoImpl jsr = new JRMPServerRequestInfoImpl();
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send exception contexts");
            }
            for (int i = 0; i < sis.length; ++i) {
                sis[i].send_exception(jsr);
            }
            JServerInterceptorHelper.setServerContextInOutput(out, jsr, JServerInterceptorHelper.isLocal());
            threadCtx.set(null);
        }
        out.flush();
    }

    public static void send_other(ObjectOutput out, JServerRequestInterceptor[] sis) throws IOException {
        if (sis == null || sis.length == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send other with no contexts");
            }
            out.writeInt(0);
        } else {
            JRMPServerRequestInfoImpl jsr = new JRMPServerRequestInfoImpl();
            for (int i = 0; i < sis.length; ++i) {
                sis[i].send_other(jsr);
            }
            JServerInterceptorHelper.setServerContextInOutput(out, jsr, JServerInterceptorHelper.isLocal());
            threadCtx.set(null);
        }
        out.flush();
    }

    public static JServerRequestInfo getRequestServerContextFromInput(ObjectInput in, int ctxValue, JServerRequestInfo jsr) throws ClassNotFoundException, IOException {
        if (ctxValue == 0) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper receive no context");
            }
            return jsr;
        }
        if (ctxValue == 1) {
            int sz = in.readInt();
            for (int i = 0; i < sz; ++i) {
                jsr.add_reply_service_context((JServiceContext)in.readObject());
            }
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper receive remote contexts");
                for (JServiceContext jsc : jsr.get_all_reply_service_context()) {
                    TraceCarol.debugRmiCarol("ctx:" + jsc);
                }
            }
            return jsr;
        }
        if (ctxValue == 2) {
            JServerInterceptorHelper.setLocal();
            int id = in.readInt();
            jsr.add_all_reply_service_context((Collection)JContextStore.getObject(id));
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper receive local contexts id(" + id + ")");
                for (JServiceContext jsc : jsr.get_all_reply_service_context()) {
                    TraceCarol.debugRmiCarol("ctx:" + jsc);
                }
            }
            return jsr;
        }
        throw new IOException("Unknow context type:" + ctxValue);
    }

    public static void setServerContextInOutput(ObjectOutput out, JServerRequestInfo ri, boolean locRef) throws IOException {
        if (!ri.hasContexts()) {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send without contexts");
            }
            out.writeInt(0);
        } else if (locRef) {
            Collection<JServiceContext> ctx = ri.get_all_reply_service_context();
            int k = JContextStore.storeObject(ctx);
            out.writeInt(2);
            out.writeInt(k);
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send with local contexts id(" + k + ")");
            }
        } else {
            if (TraceCarol.isDebugRmiCarol()) {
                TraceCarol.debugRmiCarol("JServerInterceptorHelper send with remote contexts");
            }
            out.writeInt(1);
            Collection<JServiceContext> allCtx = ri.get_all_reply_service_context();
            out.writeInt(allCtx.size());
            for (JServiceContext jsc : allCtx) {
                out.writeObject(jsc);
            }
        }
    }

    public static void setLocal() {
        threadCtx.set("local");
    }

    public static boolean isLocal() {
        return threadCtx.get() != null;
    }
}

