/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.client.xml;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.ow2.easybeans.client.xml.ApplicationClient;
import org.ow2.easybeans.deployment.xml.parsing.EJB3EntityResolver;
import org.ow2.easybeans.deployment.xml.parsing.ParsingException;
import org.ow2.easybeans.deployment.xml.struct.common.EJBRef;
import org.ow2.easybeans.deployment.xml.struct.common.InjectionTarget;
import org.ow2.easybeans.util.url.URLUtils;
import org.ow2.easybeans.util.url.URLUtilsException;
import org.ow2.easybeans.util.xml.DocumentParser;
import org.ow2.easybeans.util.xml.DocumentParserException;
import org.ow2.easybeans.util.xml.XMLUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ApplicationClientLoader {
    private static final String JAVAEE_NS = "http://java.sun.com/xml/ns/javaee";
    private static final String EJB_REF = "ejb-ref";
    private static final String DIRECTORY_APPLICATION_CLIENT_XML_FILE = "META-INF";
    private static final String APPLICATION_CLIENT_XML_FILE = "application-client.xml";
    private static Log logger = LogFactory.getLog(ApplicationClientLoader.class);
    private static boolean validating = true;

    private ApplicationClientLoader() {
    }

    private static ApplicationClient loadXML(URL url) throws ParsingException {
        logger.debug("Analyzing url {0}", url);
        ApplicationClient applicationClient = new ApplicationClient();
        Document document = null;
        try {
            document = DocumentParser.getDocument(url, validating, new EJB3EntityResolver());
        }
        catch (DocumentParserException e) {
            throw new ParsingException("Cannot parse the url", e);
        }
        Element applicationClientRootElement = document.getDocumentElement();
        NodeList ejbRefList = applicationClientRootElement.getElementsByTagNameNS(JAVAEE_NS, EJB_REF);
        for (int i = 0; i < ejbRefList.getLength(); ++i) {
            Element ejbRefElement = (Element)ejbRefList.item(i);
            EJBRef ejbRef = new EJBRef();
            String ejbRefName = XMLUtils.getStringValueElement(JAVAEE_NS, ejbRefElement, "ejb-ref-name");
            ejbRef.setEjbRefName(ejbRefName);
            String ejbRefType = XMLUtils.getStringValueElement(JAVAEE_NS, ejbRefElement, "ejb-ref-type");
            ejbRef.setEjbRefType(ejbRefType);
            String home = XMLUtils.getStringValueElement(JAVAEE_NS, ejbRefElement, "home");
            ejbRef.setHome(home);
            String remote = XMLUtils.getStringValueElement(JAVAEE_NS, ejbRefElement, "remote");
            ejbRef.setRemote(remote);
            String ejbLink = XMLUtils.getStringValueElement(JAVAEE_NS, ejbRefElement, "ejb-link");
            ejbRef.setEjbLink(ejbLink);
            NodeList injectionTargetList = ejbRefElement.getElementsByTagNameNS(JAVAEE_NS, "injection-target");
            for (int j = 0; j < injectionTargetList.getLength(); ++j) {
                Element injectionTargetElement = (Element)injectionTargetList.item(j);
                InjectionTarget injectionTarget = new InjectionTarget();
                ejbRef.addInjectionTarget(injectionTarget);
                String className = XMLUtils.getStringValueElement(JAVAEE_NS, injectionTargetElement, "injection-target-class");
                injectionTarget.setClassname(className);
                String targetName = XMLUtils.getStringValueElement(JAVAEE_NS, injectionTargetElement, "injection-target-name");
                injectionTarget.setTargetName(targetName);
            }
            applicationClient.addEJBRef(ejbRef);
        }
        return applicationClient;
    }

    public static ApplicationClient loadApplicationClient(File archive) throws ParsingException {
        URL applicationClientXmlURL = null;
        if (archive.isFile()) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(archive);
            }
            catch (IOException e) {
                throw new ParsingException("File '" + jarFile + "' is not a valid jar file.", e);
            }
            String applicationClientEntry = "META-INF/application-client.xml";
            ZipEntry zipEntry = jarFile.getEntry(applicationClientEntry);
            if (zipEntry != null) {
                String jarUrl = "jar:file:" + archive.getPath() + "!/" + applicationClientEntry;
                try {
                    applicationClientXmlURL = new URL(jarUrl);
                }
                catch (MalformedURLException e) {
                    throw new ParsingException("Error while trying to build an URL with '" + jarUrl + "'", e);
                }
            }
            try {
                jarFile.close();
            }
            catch (IOException e) {
                logger.error("Problem while closing jar file '" + jarFile + "'.", new Object[0]);
            }
        } else {
            File applicationClientXmlFile = new File(archive, DIRECTORY_APPLICATION_CLIENT_XML_FILE + File.separator + APPLICATION_CLIENT_XML_FILE);
            if (applicationClientXmlFile.exists()) {
                try {
                    applicationClientXmlURL = URLUtils.fileToURL2(applicationClientXmlFile);
                }
                catch (URLUtilsException e) {
                    throw new ParsingException("Cannot get URL from file '" + applicationClientXmlFile + "'.");
                }
            }
        }
        ApplicationClient applicationClient = null;
        if (applicationClientXmlURL != null) {
            try {
                applicationClient = ApplicationClientLoader.loadXML(applicationClientXmlURL);
            }
            catch (ParsingException e) {
                throw new ParsingException("Cannot parse the URL '" + applicationClientXmlURL + "'.", e);
            }
        }
        return applicationClient;
    }
}

