/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component;

import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.api.components.EZBComponentManager;
import org.ow2.easybeans.api.components.EZBComponentRegistry;
import org.ow2.easybeans.component.ComponentRegistry;
import org.ow2.easybeans.component.Components;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ComponentManager
implements EZBComponentManager {
    private static final String COMPONENT_STR = "Component";
    private Log logger = LogFactory.getLog(ComponentManager.class);
    private List<String> componentNames = null;
    private Components components = null;
    private ComponentRegistry componentRegistry = new ComponentRegistry();

    public ComponentManager() {
        this.componentNames = new ArrayList<String>();
    }

    public ComponentManager(Components components) {
        this();
        this.setComponents(components);
    }

    public Components getComponents() {
        return this.components;
    }

    public void setComponents(Components components) {
        this.components = components;
    }

    public void addComponent(EZBComponent component) throws EZBComponentException {
        this.addComponent(this.getComponentName(component), component);
    }

    public void removeComponent(EZBComponent component) throws EZBComponentException {
        String componentName = this.componentRegistry.getComponentName(component);
        this.componentNames.remove(componentName);
        this.componentRegistry.unregister(componentName);
    }

    private String getComponentName(EZBComponent component) {
        String componentName = component.getClass().getCanonicalName();
        int index = 2;
        if (this.componentNames.contains(componentName)) {
            while (this.componentNames.contains(componentName)) {
                componentName = componentName + index++;
            }
        }
        return componentName;
    }

    private void addComponent(String componentName, EZBComponent component) throws EZBComponentException {
        this.componentRegistry.register(componentName, component);
        this.componentNames.add(componentName);
    }

    public void initComponents() throws EZBComponentException {
        if (this.components == null) {
            return;
        }
        List<EZBComponent> componentList = this.components.getEZBComponents();
        if (componentList != null) {
            for (EZBComponent component : componentList) {
                this.addComponent(component);
            }
            for (String componentName : this.componentNames) {
                EZBComponent component = this.componentRegistry.getComponent(componentName);
                component.init();
            }
        }
    }

    public void startComponents() throws EZBComponentException {
        StringBuilder sb = new StringBuilder();
        sb.append("[ Component(s) started : ");
        for (String componentName : this.componentNames) {
            EZBComponent component = this.componentRegistry.getComponent(componentName);
            component.start();
            String name = component.getClass().getSimpleName();
            if (name.endsWith(COMPONENT_STR)) {
                name = name.substring(0, name.lastIndexOf(COMPONENT_STR));
            }
            sb.append(name);
            sb.append(" ");
        }
        sb.append("]");
        this.logger.info(sb.toString(), new Object[0]);
    }

    public void stopComponents() {
        int size = this.componentNames.size();
        for (int i = size - 1; i >= 0; --i) {
            String componentName = this.componentNames.get(i);
            EZBComponent component = this.componentRegistry.getComponent(componentName);
            try {
                component.stop();
                continue;
            }
            catch (EZBComponentException e) {
                this.logger.error("Cannot stop component with name '" + componentName + "'.", e);
            }
        }
    }

    public EZBComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }
}

