/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.carol;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.objectweb.jotm.jta.rmi.JTAInterceptorInitializer;
import org.ow2.carol.jndi.ns.NameServiceManager;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.carol.Protocol;
import org.ow2.easybeans.component.itf.RegistryComponent;
import org.ow2.easybeans.component.util.Property;
import org.ow2.easybeans.security.propagation.rmi.jrmp.interceptors.SecurityInitializer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarolComponent
implements RegistryComponent {
    private Log logger = LogFactory.getLog(CarolComponent.class);
    private static final String DEFAULT_PREFIX_PROTOCOL = "rmi";
    private List<Protocol> protocols = new ArrayList<Protocol>();
    private String initialContextFactory = null;
    private List<Property> carolProperties = null;

    @Override
    public void init() throws EZBComponentException {
        if (this.protocols == null || this.protocols.isEmpty()) {
            this.logger.debug("No protocols, use the existing carol configuration", new Object[0]);
            return;
        }
        this.initialContextFactory = System.getProperty("java.naming.factory.initial");
        String lstProtocol = null;
        Properties carolConf = new Properties();
        System.setProperty("carol.server.mode", "true");
        carolConf.setProperty("carol.jvm.rmi.local.registry", "true");
        for (Protocol protocol : this.protocols) {
            String url;
            String protocolName = protocol.getName();
            if (lstProtocol != null) {
                lstProtocol = lstProtocol + ",";
                lstProtocol = lstProtocol + protocolName;
            } else {
                lstProtocol = protocolName;
            }
            if (protocol.getUrl() != null) {
                url = protocol.getUrl();
            } else {
                String host = protocol.getHostname();
                int portNumber = protocol.getPortNumber();
                url = "rmi://" + host + ":" + portNumber;
            }
            carolConf.setProperty("carol." + protocolName + ".url", url);
        }
        carolConf.setProperty("carol.protocols", lstProtocol);
        if (this.carolProperties != null) {
            for (Property property : this.carolProperties) {
                carolConf.setProperty(property.getName(), property.getValue());
            }
        }
        this.logger.debug("carolProps: {0}", carolConf);
        try {
            ConfigurationRepository.init(carolConf, null, null);
        }
        catch (Exception e) {
            throw new EZBComponentException("Cannot initialize registry", e);
        }
        try {
            ConfigurationRepository.addInterceptors("jrmp", JTAInterceptorInitializer.class);
        }
        catch (Exception e) {
            throw new EZBComponentException("Cannot add JOTM interceptors", e);
        }
        try {
            ConfigurationRepository.addInterceptors("iiop", "org.objectweb.jotm.ots.OTSORBInitializer");
        }
        catch (Exception e) {
            throw new EZBComponentException("Cannot add JOTM interceptors", e);
        }
        try {
            ConfigurationRepository.addInterceptors("jrmp", SecurityInitializer.class);
        }
        catch (Exception e) {
            throw new EZBComponentException("Cannot add Security interceptors", e);
        }
    }

    @Override
    public void start() throws EZBComponentException {
        if (this.protocols != null && !this.protocols.isEmpty()) {
            try {
                NameServiceManager.getNameServiceManager().startNS();
            }
            catch (Exception e) {
                throw new EZBComponentException("Cannot start registry", e);
            }
        }
    }

    @Override
    public void stop() throws EZBComponentException {
        if (this.protocols != null && !this.protocols.isEmpty()) {
            try {
                NameServiceManager.getNameServiceManager().stopNS();
            }
            catch (Exception e) {
                throw new EZBComponentException("Cannot stop the registry", e);
            }
            if (this.initialContextFactory != null) {
                System.setProperty("java.naming.factory.initial", this.initialContextFactory);
            } else {
                System.getProperties().remove("java.naming.factory.initial");
            }
        }
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<Protocol> protocols) {
        this.protocols = protocols;
    }

    @Override
    public String getProviderURL() {
        return org.objectweb.carol.util.configuration.ConfigurationRepository.getCurrentConfiguration().getProviderURL();
    }

    public List<Property> getProperties() {
        return this.carolProperties;
    }

    public void setProperties(List<Property> carolProperties) {
        this.carolProperties = carolProperties;
    }
}

