/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session;

import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.bean.EasyBeansSB;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.container.AbsFactory;
import org.ow2.easybeans.container.info.SessionBeanInfo;
import org.ow2.easybeans.container.session.EasyBeansSessionContext;
import org.ow2.easybeans.rpc.api.EJBRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionFactory<PoolType extends EasyBeansSB<PoolType>>
extends AbsFactory<PoolType> {
    private static Log logger = LogFactory.getLog(SessionFactory.class);
    private SessionBeanInfo sessionBeanInfo = null;

    public SessionFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
    }

    @Override
    public void stop() {
        super.stop();
        try {
            this.getPool().stop();
        }
        catch (PoolException e) {
            logger.error("Problem when stopping the factory", e);
        }
    }

    @Override
    public IBeanInfo getBeanInfo() {
        return this.sessionBeanInfo;
    }

    public SessionBeanInfo getSessionBeanInfo() {
        return this.sessionBeanInfo;
    }

    public void setSessionBeanInfo(SessionBeanInfo sessionBeanInfo) {
        this.sessionBeanInfo = sessionBeanInfo;
    }

    protected abstract Long getId(Long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolType create(Long clue) throws PoolException {
        EasyBeansSB instance = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            try {
                instance = (EasyBeansSB)this.getBeanClass().newInstance();
            }
            catch (InstantiationException e) {
                throw new PoolException("Cannot create a new instance", e);
            }
            catch (IllegalAccessException e) {
                throw new PoolException("Cannot create a new instance", e);
            }
            catch (Exception e) {
                throw new PoolException("Cannot create a new instance", e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        instance.setEasyBeansFactory(this);
        EasyBeansSessionContext<EasyBeansSB> sessionContext = new EasyBeansSessionContext<EasyBeansSB>(instance);
        instance.setEasyBeansContext(sessionContext);
        oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            this.injectResources(instance);
            instance.postConstructEasyBeansLifeCycle();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return (PoolType)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EJBResponse rpcInvoke(EJBRequest request) {
        long hash = request.getMethodHash();
        Object[] args = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            args = request.getMethodArgs();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return this.localCall(hash, args, request.getBeanId());
    }

    protected abstract PoolType getBean(Long var1) throws IllegalArgumentException;

    @Override
    public abstract EJBResponse localCall(long var1, Object[] var3, Long var4);
}

