/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployer;

import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.deployer.AbsDeployer;
import org.ow2.easybeans.persistence.PersistenceUnitManager;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class EasyBeansDeployer
extends AbsDeployer
implements IDeployer {
    private static Log logger = LogFactory.getLog(EasyBeansDeployer.class);

    public void deploy(IDeployable deployable) throws DeployerException {
        this.checkSupportedDeployable(deployable);
        if (deployable instanceof EJBDeployable) {
            this.deployEJB((EJBDeployable)deployable);
        } else if (deployable instanceof EARDeployable) {
            EARDeployable earDeployable = this.unpackEARDeployable((EARDeployable)deployable);
            this.deployEAR(earDeployable);
        }
    }

    public void undeploy(IDeployable deployable) throws DeployerException {
        this.checkSupportedDeployable(deployable);
        if (deployable instanceof EJBDeployable) {
            throw new UnsupportedOperationException("Single EJB jar should not be removed by this deployer");
        }
        if (deployable instanceof EARDeployable) {
            this.undeployEJB3FromEAR((EARDeployable)deployable);
        }
    }

    protected void deployEAR(EARDeployable earDeployable) throws DeployerException {
        logger.info("Deploying {0}", earDeployable);
        List<EJBDeployable<?>> ejbs = earDeployable.getEJBDeployables();
        ClassLoader appClassLoader = this.getClassLoaderForEAR(earDeployable);
        PersistenceUnitManager persistenceUnitManager = this.getPersistenceUnitManager(earDeployable, appClassLoader);
        List<IArchive> libArchives = this.getLibArchives(earDeployable);
        ArrayList<EZBContainer> containers = new ArrayList<EZBContainer>();
        for (EJBDeployable<?> ejb : ejbs) {
            containers.add(this.getEmbedded().createContainer(ejb.getArchive()));
        }
        for (EZBContainer container : containers) {
            container.setClassLoader(appClassLoader);
            container.setPersistenceUnitManager(persistenceUnitManager);
            container.setExtraArchives(libArchives);
        }
        for (EZBContainer container : containers) {
            try {
                container.start();
            }
            catch (EZBContainerException e) {
                logger.error("Cannot start container {0}", container.getName(), e);
            }
        }
    }

    private void checkSupportedDeployable(IDeployable deployable) throws DeployerException {
        if (!(deployable instanceof EARDeployable) && !(deployable instanceof EJBDeployable)) {
            throw new DeployerException("The deployable '" + deployable + "' is not supported by this deployer");
        }
    }
}

