/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployer;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletContextEvent;
import org.ow2.easybeans.deployer.AbsWebContainerDeployer;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JettyDeployer
extends AbsWebContainerDeployer
implements IDeployer {
    private static Log logger = LogFactory.getLog(JettyDeployer.class);
    private static Object jettyServer = null;
    private static final String WEB_APP_CONTEXT_CLASS_NAME = "org.mortbay.jetty.webapp.WebAppContext";
    private Class webAppContextClass = null;
    private static final String GET_CHILD_HANDLER_METHOD_NAME = "getChildHandlerByClass";
    private static final String HANDLER_COLLECTION_CLASS_NAME = "org.mortbay.jetty.handler.HandlerCollection";
    private Object contexts = null;
    private static final String SET_WAR_METHOD_NAME = "setWar";
    private Method setWarMethod = null;
    private static final String SET_CONTEXT_METHOD_NAME = "setContextPath";
    private Method setContextPathMethod = null;
    private static final String GET_CONTEXT_METHOD_NAME = "getContextPath";
    private Method getContextPathMethod = null;
    private static final String START_CONTEXT_METHOD_NAME = "start";
    private Method startContextMethod = null;
    private static final String STOP_CONTEXT_METHOD_NAME = "stop";
    private Method stopContextMethod = null;
    private static final String HANDLER_CLASS_NAME = "org.mortbay.jetty.Handler";
    private static final String ADD_HANDLER_METHOD_NAME = "addHandler";
    private Method addHandlerMethod = null;
    private static final String REMOVE_HANDLER_METHOD_NAME = "removeHandler";
    private Method removeHandlerMethod = null;
    private static final String GET_ALL_HANDLER_METHOD_NAME = "getHandlers";
    private Method getHandlersMethod = null;
    private static final String SET_JAVA_DELEGATION_MODEL_METHOD_NAME = "setParentLoaderPriority";
    private Method javaDelegationModelMethod = null;

    public JettyDeployer() throws DeployerException {
        if (jettyServer == null) {
            throw new DeployerException("This deployer has not be initialized correctly as the Jetty server is null");
        }
        this.webAppContextClass = JettyDeployer.loadClass(WEB_APP_CONTEXT_CLASS_NAME, JettyDeployer.getClassLoader());
        Method getChildHandlerByClassMethod = JettyDeployer.getMethod(jettyServer.getClass(), GET_CHILD_HANDLER_METHOD_NAME, Class.class);
        Class handlerCollectionClass = JettyDeployer.loadClass(HANDLER_COLLECTION_CLASS_NAME, JettyDeployer.getClassLoader());
        Object handlerCollection = JettyDeployer.invoke(getChildHandlerByClassMethod, jettyServer, handlerCollectionClass);
        if (handlerCollection == null) {
            throw new DeployerException("No handler collection has been defined on the jetty server object '" + jettyServer + "'.");
        }
        this.contexts = JettyDeployer.invoke(getChildHandlerByClassMethod, handlerCollection, handlerCollectionClass);
        Class handlerClazz = JettyDeployer.loadClass(HANDLER_CLASS_NAME, JettyDeployer.getClassLoader());
        this.addHandlerMethod = JettyDeployer.getMethod(this.contexts.getClass(), ADD_HANDLER_METHOD_NAME, handlerClazz);
        this.removeHandlerMethod = JettyDeployer.getMethod(this.contexts.getClass(), REMOVE_HANDLER_METHOD_NAME, handlerClazz);
        this.getHandlersMethod = JettyDeployer.getMethod(this.contexts.getClass(), GET_ALL_HANDLER_METHOD_NAME, new Class[0]);
        this.setWarMethod = JettyDeployer.getMethod(this.webAppContextClass, SET_WAR_METHOD_NAME, String.class);
        this.setContextPathMethod = JettyDeployer.getMethod(this.webAppContextClass, SET_CONTEXT_METHOD_NAME, String.class);
        this.javaDelegationModelMethod = JettyDeployer.getMethod(this.webAppContextClass, SET_JAVA_DELEGATION_MODEL_METHOD_NAME, Boolean.TYPE);
        this.getContextPathMethod = JettyDeployer.getMethod(this.webAppContextClass, GET_CONTEXT_METHOD_NAME, new Class[0]);
        this.startContextMethod = JettyDeployer.getMethod(this.webAppContextClass, START_CONTEXT_METHOD_NAME, new Class[0]);
        this.stopContextMethod = JettyDeployer.getMethod(this.webAppContextClass, STOP_CONTEXT_METHOD_NAME, new Class[0]);
    }

    public void deploy(IDeployable deployable) throws DeployerException {
        this.checkSupportedDeployable(deployable);
        if (deployable instanceof EJBDeployable) {
            this.deployEJB((EJBDeployable)deployable);
        } else if (deployable instanceof EARDeployable) {
            EARDeployable earDeployable = this.unpackEARDeployable((EARDeployable)deployable);
            this.deployEAR(earDeployable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployWARs(EARDeployable earDeployable, URL earURL, ClassLoader earClassLoader, ClassLoader parentClassLoader) throws DeployerException {
        List<WARDeployable> wars = earDeployable.getWARDeployables();
        for (WARDeployable war : wars) {
            Object webAppContext = JettyDeployer.newInstance(this.webAppContextClass);
            try {
                JettyDeployer.invoke(this.setWarMethod, webAppContext, war.getArchive().getURL().getPath());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get URL from the archive '" + war.getArchive() + "'.", e);
            }
            JettyDeployer.invoke(this.setContextPathMethod, webAppContext, "/" + war.getContextRoot());
            JettyDeployer.invoke(this.javaDelegationModelMethod, webAppContext, Boolean.TRUE);
            JettyDeployer.invoke(this.addHandlerMethod, this.contexts, webAppContext);
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(parentClassLoader);
            try {
                JettyDeployer.invoke(this.startContextMethod, webAppContext, new Object[0]);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
            logger.info("The war ''{0}'' has been deployed on the ''{1}'' context.", war, war.getContextRoot());
        }
    }

    private static ClassLoader getClassLoader() {
        return jettyServer.getClass().getClassLoader();
    }

    private void checkSupportedDeployable(IDeployable deployable) throws DeployerException {
        if (!(deployable instanceof EARDeployable) && !(deployable instanceof EJBDeployable)) {
            throw new DeployerException("The deployable '" + deployable + "' is not supported by this deployer");
        }
    }

    protected void undeployWAR(WARDeployable warDeployable) throws DeployerException {
        String contextRoot = warDeployable.getContextRoot();
        Object[] handlers = (Object[])JettyDeployer.invoke(this.getHandlersMethod, this.contexts, new Object[0]);
        Object context = null;
        for (Object handler : handlers) {
            String foundCtx;
            if (!handler.getClass().equals(this.webAppContextClass) || !contextRoot.equals(foundCtx = (String)JettyDeployer.invoke(this.getContextPathMethod, handler, new Object[0])) && !("/" + contextRoot).equals(foundCtx)) continue;
            context = handler;
            break;
        }
        if (context == null) {
            throw new DeployerException("Unable to find a context with the name '" + contextRoot + "' for the War deployable '" + warDeployable + "'.");
        }
        JettyDeployer.invoke(this.stopContextMethod, context, new Object[0]);
        JettyDeployer.invoke(this.removeHandlerMethod, this.contexts, context);
        logger.info("The context ''{0}'' of the War ''{1}'' has been undeployed", contextRoot, warDeployable);
    }

    public static void setContextEvent(ServletContextEvent contextEvent) throws DeployerException {
        Object source = contextEvent.getSource();
        if (source == null) {
            throw new DeployerException("No source object on the given contextEvent '" + contextEvent + "'.");
        }
        Method getContextHandlerMethod = JettyDeployer.getMethod(source.getClass(), "getContextHandler", new Class[0]);
        if (getContextHandlerMethod == null) {
            throw new DeployerException("No getContextHandler method was found on the '" + source + "' object");
        }
        Object contextHandler = JettyDeployer.invoke(getContextHandlerMethod, source, new Object[0]);
        if (contextHandler == null) {
            throw new DeployerException("No context handler object was returned from the '" + source + "' object");
        }
        Method getServerMethod = JettyDeployer.getMethod(contextHandler.getClass(), "getServer", new Class[0]);
        if (getContextHandlerMethod == null) {
            throw new DeployerException("No getServer method was found on the '" + contextHandler + "' object");
        }
        jettyServer = JettyDeployer.invoke(getServerMethod, contextHandler, new Object[0]);
        if (jettyServer == null) {
            throw new DeployerException("No Jetty server found on the servlet context event '" + contextEvent + "'.");
        }
    }
}

