/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.deployable.DeployerFactory;
import org.ow2.easybeans.deployer.IRemoteDeployer;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.impl.archive.ArchiveManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class RemoteDeployer
implements IRemoteDeployer {
    private static final String DEFAULT_FOLDER = "EasyBeans-" + RemoteDeployer.class.getSimpleName();
    private static Log logger = LogFactory.getLog(RemoteDeployer.class);
    private IDeployer deployer = null;

    public RemoteDeployer(EZBServer embedded) throws DeployerException {
        this.deployer = DeployerFactory.getDeployer(embedded);
    }

    public String dumpFile(String fileName, byte[] fileContent) {
        logger.info("Dump file to the local filesystem with the name = ''{0}''.", fileName);
        File rootFolder = new File(System.getProperty("java.io.tmpdir") + File.separator + DEFAULT_FOLDER);
        rootFolder.mkdirs();
        File file = new File(rootFolder, fileName);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Cannot build an outputstream on file '" + file + "'.", e);
        }
        try {
            out.write(fileContent);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot write byte in outputstream", e);
        }
        try {
            out.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot close outpustream", e);
        }
        return file.getPath();
    }

    public void deployFile(String fileName, byte[] fileContent) {
        this.deploy(this.dumpFile(fileName, fileContent));
    }

    public void deploy(String fileName) {
        logger.info("Deploying ''{0}''", fileName);
        IDeployable deployable = this.getDeployable(fileName);
        try {
            this.deployer.deploy(deployable);
        }
        catch (DeployerException e) {
            logger.error("Cannot deploy the deployable ''{0}''", deployable, e);
            throw new RuntimeException("Cannot deploy the deployable '" + deployable + "' : " + e.getMessage());
        }
    }

    protected IDeployable getDeployable(String fileName) {
        IDeployable<?> deployable;
        File file = new File(fileName);
        if (!file.exists()) {
            throw new RuntimeException("The file '" + fileName + "' is not present on the filesystem.");
        }
        IArchive archive = ArchiveManager.getInstance().getArchive(file);
        if (archive == null) {
            logger.error("No archive found for the invalid file ''{0}''", file);
            throw new RuntimeException("No archive found for the invalid file '" + file + "'.");
        }
        try {
            deployable = DeployableHelper.getDeployable(archive);
        }
        catch (DeployableHelperException e) {
            logger.error("Cannot get a deployable for the archive ''{0}''", archive, e);
            throw new RuntimeException("Cannot get a deployable for the archive '" + archive + "' : " + e.getMessage());
        }
        return deployable;
    }

    public void undeploy(String fileName) {
        logger.info("Undeploying ''{0}''", fileName);
        IDeployable deployable = this.getDeployable(fileName);
        try {
            this.deployer.undeploy(deployable);
        }
        catch (DeployerException e) {
            logger.error("Cannot undeploy the deployable ''{0}''", deployable, e);
            throw new RuntimeException("Cannot undeploy the deployable '" + deployable + "' : " + e.getMessage());
        }
    }
}

