/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployer;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.easybeans.deployer.AbsWebContainerDeployer;
import org.ow2.easybeans.jmx.CommonsModelerException;
import org.ow2.easybeans.jmx.CommonsModelerHelper;
import org.ow2.easybeans.jmx.JMXRemoteException;
import org.ow2.easybeans.jmx.MBeanServerHelper;
import org.ow2.easybeans.util.files.FileUtils;
import org.ow2.easybeans.util.files.FileUtilsException;
import org.ow2.easybeans.util.url.URLUtils;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class TomcatDeployer
extends AbsWebContainerDeployer
implements IDeployer {
    private static Log logger = LogFactory.getLog(TomcatDeployer.class);
    private static final String CATALINA_CONTEXT_CLASSNAME = "org.apache.catalina.core.StandardContext";
    private Class catalinaContextClass = TomcatDeployer.loadClass("org.apache.catalina.core.StandardContext");
    private static final String START_METHOD_NAME = "start";
    private Method startContextMethod = TomcatDeployer.getMethod(this.catalinaContextClass, "start", new Class[0]);
    private static final String SET_PARENT_CLASSLOADER_METHOD_NAME = "setParentClassLoader";
    private Method setParentClassLoaderMethod = TomcatDeployer.getMethod(this.catalinaContextClass, "setParentClassLoader", ClassLoader.class);
    private static final String SET_DOC_BASE_METHOD_NAME = "setDocBase";
    private Method setDocBaseMethod = TomcatDeployer.getMethod(this.catalinaContextClass, "setDocBase", String.class);
    private static final String SET_PATH_METHOD_NAME = "setPath";
    private Method setPathMethod = TomcatDeployer.getMethod(this.catalinaContextClass, "setPath", String.class);
    private static final String SET_DEFAULT_CONTEXT_XML_METHOD_NAME = "setDefaultContextXml";
    private Method setDefaultContextXmlMethod = TomcatDeployer.getMethod(this.catalinaContextClass, "setDefaultContextXml", String.class);
    private static final String SET_DEFAULT_WEB_XML_METHOD_NAME = "setDefaultWebXml";
    private static final String SET_JAVA_DELEGATION_MODEL_METHOD_NAME = "setDelegate";
    private static final String SET_CONFIG_FILE_METHOD_NAME = "setConfigFile";
    private Method setJavaDelegationModelMethod = null;
    private Method setDefaultWebXmlMethod = TomcatDeployer.getMethod(this.catalinaContextClass, "setDefaultWebXml", String.class);
    private Method setConfigFileMethod = null;
    private static final String ENGINE_OBJECT_NAME = "*:type=Engine";
    private static final String DESTROY_OPERATION = "destroy";

    public TomcatDeployer() throws DeployerException {
        this.setJavaDelegationModelMethod = TomcatDeployer.getMethod(this.catalinaContextClass, SET_JAVA_DELEGATION_MODEL_METHOD_NAME, Boolean.TYPE);
        this.setConfigFileMethod = TomcatDeployer.getMethod(this.catalinaContextClass, SET_CONFIG_FILE_METHOD_NAME, String.class);
    }

    public void deploy(IDeployable deployable) throws DeployerException {
        this.checkSupportedDeployable(deployable);
        if (deployable instanceof EJBDeployable) {
            this.deployEJB((EJBDeployable)deployable);
        } else if (deployable instanceof EARDeployable) {
            EARDeployable earDeployable = this.unpackEARDeployable((EARDeployable)deployable);
            this.deployEAR(earDeployable);
        }
    }

    protected void deployWARs(EARDeployable earDeployable, URL earURL, ClassLoader earClassLoader, ClassLoader parentClassLoader) throws DeployerException {
        List<WARDeployable> wars = earDeployable.getWARDeployables();
        for (WARDeployable war : wars) {
            Object ctx = TomcatDeployer.newInstance(this.catalinaContextClass);
            String objectName = this.buildObjectName(war);
            try {
                CommonsModelerHelper.registerModelerMBean(ctx, objectName);
            }
            catch (CommonsModelerException e) {
                throw new DeployerException("Cannot register the object '" + ctx + "' with the objectname '" + objectName + "'.", e);
            }
            TomcatDeployer.invoke(this.setPathMethod, ctx, war.getContextRoot());
            URL warURL = null;
            try {
                warURL = war.getArchive().getURL();
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + war.getArchive() + "'.", e);
            }
            File warFile = URLUtils.urlToFile(warURL);
            String docBase = warFile.getPath();
            if (warFile.isFile()) {
                File unpackDir = this.unpack(warFile, war, earURL);
                docBase = unpackDir.getPath();
            }
            TomcatDeployer.invoke(this.setDocBaseMethod, ctx, docBase);
            TomcatDeployer.invoke(this.setDefaultWebXmlMethod, ctx, "conf/web.xml");
            TomcatDeployer.invoke(this.setDefaultContextXmlMethod, ctx, "context.xml");
            File contextXmlFile = new File(docBase + File.separator + "META-INF" + File.separator + "context.xml");
            if (contextXmlFile.exists()) {
                TomcatDeployer.invoke(this.setConfigFileMethod, ctx, contextXmlFile.getAbsolutePath());
            }
            TomcatDeployer.invoke(this.setParentClassLoaderMethod, ctx, parentClassLoader);
            TomcatDeployer.invoke(this.setJavaDelegationModelMethod, ctx, Boolean.TRUE);
            TomcatDeployer.invoke(this.startContextMethod, ctx, new Object[0]);
            logger.info("The war ''{0}'' has been deployed on the ''{1}'' context.", war, war.getContextRoot());
        }
    }

    private void checkSupportedDeployable(IDeployable deployable) throws DeployerException {
        if (!(deployable instanceof EARDeployable) && !(deployable instanceof EJBDeployable)) {
            throw new DeployerException("The deployable '" + deployable + "' is not supported by this deployer");
        }
    }

    protected void undeployWAR(WARDeployable warDeployable) throws DeployerException {
        String contextRoot = warDeployable.getContextRoot();
        ObjectName contextObjectName = null;
        try {
            contextObjectName = new ObjectName(this.buildObjectName(warDeployable));
        }
        catch (MalformedObjectNameException e) {
            throw new DeployerException("Cannot get the ObjectName for the WAR deployable '" + warDeployable + "'.", e);
        }
        catch (NullPointerException e) {
            throw new DeployerException("Cannot get the ObjectName for the WAR deployable '" + warDeployable + "'.", e);
        }
        try {
            if (!MBeanServerHelper.getMBeanServerServer().isRegistered(contextObjectName)) {
                throw new DeployerException("There is no MBean with the ObjectName '" + contextObjectName + "' in the MBean Server for the WAR deployable '" + warDeployable + "'.");
            }
        }
        catch (JMXRemoteException e) {
            throw new DeployerException("Cannot check if the MBean with the ObjectName '" + contextObjectName + "'is registered in the MBean Server for the WAR deployable '" + warDeployable + "'.");
        }
        try {
            MBeanServerHelper.getMBeanServerServer().invoke(contextObjectName, DESTROY_OPERATION, null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new DeployerException("Cannot remove the context '" + contextRoot + "' of the war deployable '" + warDeployable + "'.", e);
        }
        catch (MBeanException e) {
            throw new DeployerException("Cannot remove the context '" + contextRoot + "' of the war deployable '" + warDeployable + "'.", e);
        }
        catch (ReflectionException e) {
            throw new DeployerException("Cannot remove the context '" + contextRoot + "' of the war deployable '" + warDeployable + "'.", e);
        }
        catch (JMXRemoteException e) {
            throw new DeployerException("Cannot remove the context '" + contextRoot + "' of the war deployable '" + warDeployable + "'.", e);
        }
        logger.info("The context ''{0}'' of the War ''{1}'' has been undeployed", contextRoot, warDeployable);
    }

    private String buildObjectName(WARDeployable war) throws DeployerException {
        String objectName = this.getDomain() + ":j2eeType=WebModule,name=//" + this.getDefaultHost() + "/" + war.getContextRoot() + ",J2EEServer=EasyBeans,J2EEApplication=EAR";
        return objectName;
    }

    private String getDomain() throws DeployerException {
        return this.getEngineObjectName().getDomain();
    }

    private ObjectName getEngineObjectName() throws DeployerException {
        ObjectName engineObjectName = null;
        try {
            engineObjectName = new ObjectName(ENGINE_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new DeployerException("Cannot build Tomcat Engine MBean.", e);
        }
        catch (NullPointerException e) {
            throw new DeployerException("Cannot build Tomcat Engine MBean.", e);
        }
        Set<ObjectName> objectNames = null;
        try {
            objectNames = MBeanServerHelper.getMBeanServerServer().queryNames(engineObjectName, null);
        }
        catch (JMXRemoteException e) {
            throw new DeployerException("Cannot get Tomcat Engine MBean.", e);
        }
        if (objectNames.size() == 0) {
            throw new DeployerException("No Tomcat Engine MBean was found in the MBean server");
        }
        return objectNames.iterator().next();
    }

    private String getDefaultHost() throws DeployerException {
        ObjectName engineObjectName = this.getEngineObjectName();
        try {
            return MBeanServerHelper.getMBeanServerServer().getAttribute(engineObjectName, "defaultHost").toString();
        }
        catch (AttributeNotFoundException e) {
            throw new DeployerException("Cannot get the default host on the object name '" + engineObjectName + "'.", e);
        }
        catch (InstanceNotFoundException e) {
            throw new DeployerException("Cannot get the default host on the object name '" + engineObjectName + "'.", e);
        }
        catch (MBeanException e) {
            throw new DeployerException("Cannot get the default host on the object name '" + engineObjectName + "'.", e);
        }
        catch (ReflectionException e) {
            throw new DeployerException("Cannot get the default host on the object name '" + engineObjectName + "'.", e);
        }
        catch (JMXRemoteException e) {
            throw new DeployerException("Cannot get the default host on the object name '" + engineObjectName + "'.", e);
        }
    }

    private File unpack(File warFile, WARDeployable war, URL earURL) throws DeployerException {
        JarFile packedJar;
        String earName = URLUtils.urlToFile(earURL).getName();
        String rootUnpackDir = System.getProperty("java.io.tmpdir") + File.separator + System.getProperty("user.name") + "-EasyBeans-unpack" + File.separator;
        File unpackDir = new File(rootUnpackDir, earName + File.separator + warFile.getName());
        try {
            packedJar = new JarFile(warFile);
        }
        catch (IOException e) {
            throw new DeployerException("The war file '" + warFile + "' is not a valid jar file", e);
        }
        try {
            FileUtils.unpack(packedJar, unpackDir);
        }
        catch (FileUtilsException e) {
            throw new DeployerException("Cannot unpack the file '" + packedJar + "' in the directory '" + unpackDir + "'.", e);
        }
        return unpackDir;
    }
}

