/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment;

import java.util.LinkedList;
import java.util.List;
import org.ow2.easybeans.deployment.annotations.analyzer.WarAnnotationDeploymentAnalyzer;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.xml.WARDeploymentDesc;
import org.ow2.easybeans.deployment.xml.WARDeploymentDescException;
import org.ow2.easybeans.deployment.xml.struct.Listener;
import org.ow2.easybeans.deployment.xml.struct.Servlet;
import org.ow2.easybeans.deployment.xml.struct.Tag;
import org.ow2.easybeans.deployment.xml.struct.WAR;
import org.ow2.util.deployment.annotations.analyzer.AnalyzerException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WARDeployment {
    private static Log logger = LogFactory.getLog(WARDeployment.class);
    private IArchive archive = null;
    private WarAnnotationDeploymentAnalyzer warAnnotationDeploymentAnalyzer = null;

    public WARDeployment(IArchive archive, ClassLoader classLoader) {
        this.archive = archive;
        this.warAnnotationDeploymentAnalyzer = new WarAnnotationDeploymentAnalyzer(archive, classLoader);
    }

    public void analyze() throws AnalyzerException, WARDeploymentDescException, ResolverException {
        WAR war = WARDeploymentDesc.getWAR(this.archive);
        long tAnalyzeStart = System.currentTimeMillis();
        LinkedList<String> classNames = new LinkedList<String>();
        for (Servlet servlet : war.getServlets()) {
            this.addClassIfNotAlreadyPresent(servlet.getClassName(), classNames);
        }
        for (Listener listener : war.getListeners()) {
            this.addClassIfNotAlreadyPresent(listener.getListenerClassName(), classNames);
        }
        for (Tag tag : war.getTags()) {
            this.addClassIfNotAlreadyPresent(tag.getTagClassName(), classNames);
        }
        this.warAnnotationDeploymentAnalyzer.analyze(classNames);
        if (logger.isDebugEnabled()) {
            long tAnalyzeStartEnd = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Analyze of file {0} took {1} ms.", this.archive.getName(), tAnalyzeStartEnd - tAnalyzeStart);
            }
        }
    }

    protected void addClassIfNotAlreadyPresent(String className, List<String> classNames) {
        if (className == null) {
            return;
        }
        if (!classNames.contains(className)) {
            classNames.add(className);
        }
    }

    public WarAnnotationDeploymentAnalyzer getAnnotationDeploymentAnalyzer() {
        return this.warAnnotationDeploymentAnalyzer;
    }

    public IArchive getArchive() {
        return this.archive;
    }
}

