/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.resolver;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.container.JContainer3;
import org.ow2.easybeans.deployment.Deployment;
import org.ow2.easybeans.deployment.annotations.impl.JCommonBean;
import org.ow2.easybeans.deployment.annotations.impl.JLocal;
import org.ow2.easybeans.deployment.annotations.impl.JRemote;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.easybeans.util.url.URLUtils;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIResolver {
    private Log logger = LogFactory.getLog(JNDIResolver.class);
    public static final String NAME = "jndi.resolver";
    private Map<String, String> interfaces = new HashMap<String, String>();
    private Map<String, Map<String, String>> beans = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, Map<String, String>>> jndiNameForEjbInJarFile = new HashMap<String, Map<String, Map<String, String>>>();

    public JNDIResolver() {
    }

    public JNDIResolver(Deployment deployment) {
        this();
        this.addDeployment(deployment);
    }

    public void addDeployment(Deployment deployment) {
        URL url;
        EjbJarArchiveMetadata ejbJarAnnotationMetadata = deployment.getEjbJarArchiveMetadata();
        IArchive archive = deployment.getArchive();
        String name = archive.getName();
        try {
            url = archive.getURL();
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot get the URL on the archive '" + archive + "'.", e);
        }
        if ("file".equals(url.getProtocol())) {
            File f = null;
            try {
                f = URLUtils.urlToFile(archive.getURL());
            }
            catch (ArchiveException e) {
                throw new IllegalStateException("Cannot get URL of the archive '" + archive + "'", e);
            }
            name = f.getName();
        }
        this.addEjbJarAnnotationMetadata(ejbJarAnnotationMetadata, name, deployment.getPrefix());
    }

    private void addEjbJarAnnotationMetadata(EjbJarArchiveMetadata ejbJarAnnotationMetadata, String ejbJarFileName, String prefix) {
        for (EjbJarClassMetadata classAnnotationMetadata : ejbJarAnnotationMetadata.getEjbJarClassMetadataCollection()) {
            String localHome;
            String remoteHome;
            if (!classAnnotationMetadata.isBean()) continue;
            JCommonBean jCommonBean = classAnnotationMetadata.getJCommonBean();
            String mappedName = null;
            String beanName = null;
            List<String> aliases = null;
            if (jCommonBean != null) {
                mappedName = jCommonBean.getMappedName();
                beanName = jCommonBean.getName();
                aliases = jCommonBean.getAliases();
            }
            JLocal localItfs = classAnnotationMetadata.getLocalInterfaces();
            JRemote remoteItfs = classAnnotationMetadata.getRemoteInterfaces();
            if (localItfs != null) {
                for (String itf : localItfs.getInterfaces()) {
                    this.addInterface(itf, classAnnotationMetadata.getClassName(), "Local", mappedName, beanName, aliases, ejbJarFileName, prefix);
                }
            }
            if (remoteItfs != null) {
                for (String itf : remoteItfs.getInterfaces()) {
                    this.addInterface(itf, classAnnotationMetadata.getClassName(), "Remote", mappedName, beanName, aliases, ejbJarFileName, prefix);
                }
            }
            if ((remoteHome = classAnnotationMetadata.getRemoteHome()) != null) {
                this.addInterface(remoteHome, classAnnotationMetadata.getClassName(), null, null, beanName, null, ejbJarFileName, prefix);
            }
            if ((localHome = classAnnotationMetadata.getLocalHome()) == null) continue;
            this.addInterface(localHome, classAnnotationMetadata.getClassName(), null, null, beanName, null, ejbJarFileName, prefix);
        }
    }

    private void addInterface(String itf, String beanClassName, String mode, String mappedName, String beanName, List<String> aliases, String ejbJarFileName, String prefix) {
        String jndiName = JContainer3.jndiNameEncode(beanClassName, itf, mode);
        if (mappedName != null) {
            jndiName = mappedName;
        }
        String itfName = itf.replace('/', '.');
        this.interfaces.put(itfName, jndiName);
        ArrayList<String> ejbNames = new ArrayList<String>();
        if (beanName != null && !beanName.equals("")) {
            ejbNames.add(beanName);
        }
        if (aliases != null) {
            for (String alias : aliases) {
                ejbNames.add(alias);
            }
        }
        if (prefix != null) {
            ArrayList<String> ejbNamesWithPrefixes = new ArrayList<String>(2 * ejbNames.size());
            for (String ejbName : ejbNames) {
                ejbNamesWithPrefixes.add(ejbName);
                ejbNamesWithPrefixes.add(prefix + "_" + ejbName);
            }
            ejbNames = ejbNamesWithPrefixes;
        }
        for (String ejbName : ejbNames) {
            Map<String, String> dataForBean;
            Map<String, String> tmpBeanMap = this.beans.get(ejbName);
            if (tmpBeanMap == null) {
                tmpBeanMap = new HashMap<String, String>();
                this.beans.put(ejbName, tmpBeanMap);
            }
            tmpBeanMap.put(itfName, jndiName);
            this.beans.put(ejbName, tmpBeanMap);
            this.logger.debug("Adding jndi name {0} for beanName {1} with itf {2} and className {3}", jndiName, ejbName, itfName, beanClassName);
            Map<String, Map<String, String>> jndiNameForBeans = this.jndiNameForEjbInJarFile.get(ejbJarFileName);
            if (jndiNameForBeans == null) {
                jndiNameForBeans = new HashMap<String, Map<String, String>>();
                this.jndiNameForEjbInJarFile.put(ejbJarFileName, jndiNameForBeans);
            }
            if ((dataForBean = jndiNameForBeans.get(ejbName)) == null) {
                dataForBean = new HashMap<String, String>();
                jndiNameForBeans.put(ejbName, dataForBean);
            }
            dataForBean.put(itfName, jndiName);
        }
        if (ejbNames.size() == 0) {
            this.logger.debug("Adding jndi name {0} with itf {1} and className {2}", jndiName, itfName, beanClassName);
        }
    }

    public String getJndiNameInterface(String itf, String beanName) {
        if (beanName != null && beanName.indexOf("#") > 0) {
            String[] data = beanName.split("#");
            String fName = data[0];
            String ejbName = data[1];
            Map<String, Map<String, String>> beans = this.jndiNameForEjbInJarFile.get(fName);
            Map<String, String> bean = beans.get(ejbName);
            if (bean != null) {
                return bean.get(itf);
            }
            throw new IllegalStateException("No bean with name '" + ejbName + "' was found with ejb-link '" + beanName + "' in jar file '" + this.jndiNameForEjbInJarFile + "'.");
        }
        if (beanName != null && !beanName.equals("")) {
            Map<String, String> lst = this.beans.get(beanName);
            if (lst != null) {
                return lst.get(itf);
            }
            throw new IllegalStateException("No bean with name '" + beanName + "' was found.");
        }
        return this.interfaces.get(itf);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JNDIResolver[");
        sb.append("Interfaces =[");
        sb.append(this.interfaces);
        sb.append("], Beans =");
        sb.append(this.beans);
        sb.append("]]");
        return sb.toString();
    }
}

