/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.injection;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.container.EZBEJBContext;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class EntityManagerHelper {
    private static Log logger = LogFactory.getLog(EntityManagerHelper.class);

    private EntityManagerHelper() {
    }

    public static EntityManager getEntityManager(EZBEJBContext ejbContext, String unitName, PersistenceContextType type) {
        Factory factory = ejbContext.getBean().getEasyBeansFactory();
        EZBPersistenceUnitManager persistenceUnitManager = factory.getContainer().getPersistenceUnitManager();
        if (persistenceUnitManager != null) {
            return persistenceUnitManager.getEntityManager(unitName, type);
        }
        logger.warn("Requested an EntityManager object but there is no persistenceUnitManager associated to this bean/interceptor : {0}", factory);
        return null;
    }

    public static EntityManagerFactory getEntityManagerFactory(EZBEJBContext ejbContext, String unitName) {
        Factory factory = ejbContext.getBean().getEasyBeansFactory();
        EZBPersistenceUnitManager persistenceUnitManager = factory.getContainer().getPersistenceUnitManager();
        if (persistenceUnitManager != null) {
            return persistenceUnitManager.getEntityManagerFactory(unitName);
        }
        logger.warn("Requested an EntityManagerFactory but there is no persistenceUnitManager associated to this bean/interceptor : {0}", factory);
        return null;
    }
}

