/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.ejbjar;

import java.net.URL;
import org.osgi.framework.BundleContext;
import org.ow2.easybeans.loader.EasyBeansClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackedClassLoader
extends EasyBeansClassLoader
implements Cloneable {
    private BundleContext bc;
    private ClassLoader coreClassLoader;
    private URL[] urls;

    public BackedClassLoader(URL[] urls, ClassLoader coreClassLoader, BundleContext bc) {
        super(urls, coreClassLoader);
        this.coreClassLoader = coreClassLoader;
        this.urls = urls;
        this.bc = bc;
    }

    @Override
    public URL getResource(String name) {
        URL resource = null;
        boolean caughtException = false;
        try {
            resource = super.getResource(name);
        }
        catch (RuntimeException e) {
            caughtException = true;
        }
        if (resource == null || caughtException) {
            resource = this.bc.getBundle().getResource(name);
        }
        return resource;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        boolean caughtException = false;
        Class clazz = null;
        try {
            return super.loadClass(name);
        }
        catch (Exception e) {
            caughtException = true;
            if (clazz == null || caughtException) {
                clazz = this.bc.getBundle().loadClass(name);
            }
            return clazz;
        }
    }

    @Override
    public Object clone() {
        return new BackedClassLoader(this.urls, this.coreClassLoader, this.bc);
    }
}

