/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.extension;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.osgi.framework.BundleContext;
import org.ow2.easybeans.api.bean.EasyBeansBean;
import org.ow2.easybeans.api.injection.ResourceInjector;
import org.ow2.easybeans.osgi.annotation.OSGiResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiResourceInjector
implements ResourceInjector {
    private BundleContext bundleContext;

    public OSGiResourceInjector() {
    }

    public OSGiResourceInjector(BundleContext bundleContext) {
        this.setBundleContext(bundleContext);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void preEasyBeansInject(EasyBeansBean bean) {
        this.processFields(bean);
        this.processMethods(bean);
    }

    protected void processFields(EasyBeansBean bean) {
        Field[] fields = bean.getClass().getDeclaredFields();
        if (fields == null) {
            return;
        }
        for (Field field : fields) {
            if (!field.isAnnotationPresent(OSGiResource.class)) continue;
            Class<?> fieldClassType = field.getType();
            if (!BundleContext.class.getName().equals(fieldClassType.getName())) continue;
            this.injectField(field, bean, this.bundleContext);
        }
    }

    protected void processMethods(EasyBeansBean bean) {
        Method[] methods = bean.getClass().getDeclaredMethods();
        if (methods == null) {
            return;
        }
        for (Method method : methods) {
            if (!method.isAnnotationPresent(OSGiResource.class) || !method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
            Class<?> parameterClass = method.getParameterTypes()[0];
            if (!BundleContext.class.getName().equals(parameterClass.getName())) continue;
            this.invokeMethod(method, bean, this.bundleContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void injectField(Field field, EasyBeansBean bean, T value) {
        boolean isAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            try {
                field.set(bean, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unable to inject value '" + value + "' in the bean '" + bean + "' for the field '" + field + "'.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to inject value '" + value + "' in the bean '" + bean + "' for the field '" + field + "'.", e);
            }
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void invokeMethod(Method method, EasyBeansBean bean, T value) {
        boolean isAccessible = method.isAccessible();
        try {
            method.setAccessible(true);
            try {
                method.invoke((Object)bean, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unable to call setter method '" + method + "' in the bean '" + bean + "' for the value '" + value + "'.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to call setter method '" + method + "' in the bean '" + bean + "' for the value '" + value + "'.", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Unable to call setter method '" + method + "' in the bean '" + bean + "' for the value '" + value + "'.", e);
            }
        }
        finally {
            method.setAccessible(isAccessible);
        }
    }

    @Override
    public void postEasyBeansInject(EasyBeansBean bean) {
    }
}

