/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.security.permissions;

import java.net.URL;
import java.security.Policy;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.ow2.easybeans.api.PermissionManagerException;

public abstract class AbsPermissionManager {
    private PolicyConfiguration policyConfiguration = null;
    private URL contextIdURL = null;
    private String contextId = null;
    private static Policy policy = null;

    public AbsPermissionManager(URL contextIdURL) throws PermissionManagerException {
        this(contextIdURL, true);
    }

    public AbsPermissionManager(URL contextIdURL, boolean remove) throws PermissionManagerException {
        this.contextIdURL = contextIdURL;
        this.contextId = contextIdURL.toString();
        PolicyConfigurationFactory policyConfigurationFactory = null;
        try {
            policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (ClassNotFoundException e) {
            throw new PermissionManagerException("Error when trying to get the PolicyConfigurationFactory object", e);
        }
        catch (PolicyContextException e) {
            throw new PermissionManagerException("Error when trying to get the PolicyConfigurationFactory object", e);
        }
        try {
            this.policyConfiguration = policyConfigurationFactory.getPolicyConfiguration(this.contextId, remove);
        }
        catch (PolicyContextException pce) {
            throw new PermissionManagerException("Error when trying to get the PolicyConfiguration object with contextId '" + this.contextId + "'.'", pce);
        }
        policy = Policy.getPolicy();
    }

    public void delete() throws PermissionManagerException {
        try {
            this.policyConfiguration.delete();
        }
        catch (PolicyContextException pce) {
            throw new PermissionManagerException("Cannot delete policyConfiguration object", pce);
        }
        this.policyConfiguration = null;
        policy.refresh();
    }

    public void commit() throws PermissionManagerException {
        try {
            this.policyConfiguration.commit();
            policy.refresh();
        }
        catch (PolicyContextException pce) {
            throw new PermissionManagerException("Cannot commit configuration", pce);
        }
    }

    protected static Policy getPolicy() {
        return policy;
    }

    protected String getContextId() {
        return this.contextId;
    }

    protected void setContextId(String contextId) {
        this.contextId = contextId;
    }

    protected PolicyConfiguration getPolicyConfiguration() {
        return this.policyConfiguration;
    }

    protected void setPolicyConfiguration(PolicyConfiguration policyConfiguration) {
        this.policyConfiguration = policyConfiguration;
    }

    protected URL getContextIdURL() {
        return this.contextIdURL;
    }
}

