/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.util.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.ow2.easybeans.util.files.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class FileUtils {
    private static final int BUFFER_SIZE = 2048;
    private static Log logger = LogFactory.getLog(FileUtils.class);

    private FileUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unpack(JarFile packedJar, File dest) throws FileUtilsException {
        JarEntry entry = null;
        Enumeration<JarEntry> entries = packedJar.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            File entryFile = new File(dest, entry.getName());
            if (entry.isDirectory()) {
                if (entryFile.exists() || entryFile.mkdirs()) continue;
                String err = "Can not create directory " + entryFile + ", Check the write access.";
                throw new FileUtilsException(err);
            }
            entryFile.getParentFile().mkdirs();
            InputStream is = null;
            try {
                is = packedJar.getInputStream(entry);
                FileUtils.dump(is, entryFile);
            }
            catch (IOException ioe) {
                try {
                    throw new FileUtilsException("Cannot get inputstream of entry '" + entry + "' of file '" + packedJar + "'.");
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException ioe2) {
                        logger.debug("Cannot close input stream", ioe2);
                    }
                    throw throwable;
                }
            }
            try {
                is.close();
            }
            catch (IOException ioe) {
                logger.debug("Cannot close input stream", ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(InputStream in, File entryFile) throws FileUtilsException {
        try {
            FileOutputStream out = new FileOutputStream(entryFile);
            int n = 0;
            try {
                byte[] buffer = new byte[2048];
                n = in.read(buffer);
                while (n > 0) {
                    out.write(buffer, 0, n);
                    n = in.read(buffer);
                }
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            String err = "Error while unpacking entry " + entryFile + " : ";
            throw new FileUtilsException(err, e);
        }
    }

    public static void copyFile(String src, String dest) throws FileUtilsException {
        FileUtils.copyFile(new File(src), new File(dest));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File src, File dest) throws FileUtilsException {
        File newDest = null;
        if (dest.isDirectory()) {
            logger.debug("Copy a file to a directory, append source filename to directory.", new Object[0]);
            newDest = new File(dest, src.getName());
        } else {
            newDest = dest;
        }
        FileInputStream fIn = null;
        FileOutputStream fOut = null;
        AbstractInterruptibleChannel fcIn = null;
        try {
            fIn = new FileInputStream(src);
            fOut = new FileOutputStream(newDest);
            FileChannel sourceFC = fIn.getChannel();
            FileChannel targetFC = fOut.getChannel();
            targetFC.transferFrom(sourceFC, 0L, sourceFC.size());
        }
        catch (Exception e) {
            try {
                throw new FileUtilsException("Error during copy file : " + src + " -> " + dest, e);
            }
            catch (Throwable throwable) {
                try {
                    fOut.close();
                    fIn.close();
                    fcIn.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    logger.debug("Cannot close some i/o which are open.", e2);
                }
                throw throwable;
            }
        }
        try {
            fOut.close();
            fIn.close();
            fcIn.close();
            return;
        }
        catch (Exception e) {
            logger.debug("Cannot close some i/o which are open.", e);
            return;
        }
    }

    public static boolean delete(String path) {
        return FileUtils.delete(new File(path));
    }

    public static boolean delete(File f) {
        if (f.isFile()) {
            return f.delete();
        }
        File[] children = f.listFiles();
        if (children == null) {
            return f.delete();
        }
        boolean result = true;
        for (int i = 0; i < children.length; ++i) {
            result &= FileUtils.delete(children[i]);
        }
        return result && f.delete();
    }

    public static void copyDirectory(String src, String dest) throws FileUtilsException {
        FileUtils.copyDirectory(new File(src), new File(dest));
    }

    public static void copyDirectory(File src, File dest) throws FileUtilsException {
        File[] childs;
        if (!src.isDirectory()) {
            throw new IllegalArgumentException("Source '" + src + "' must be a directory");
        }
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if ((childs = src.listFiles()) != null) {
            for (int i = 0; i < childs.length; ++i) {
                File child = childs[i];
                if (child.isFile()) {
                    FileUtils.copyFile(child, dest);
                    continue;
                }
                FileUtils.copyDirectory(child, new File(dest, child.getName()));
            }
        }
    }
}

