/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployablemonitor;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.ow2.jonas.deployablemonitor.DeployableMonitor;
import org.ow2.jonas.depmonitor.MonitoringService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DeployableMonitorService
extends AbsServiceImpl
implements MonitoringService {
    public static final String DEVELOPMENT_MODE_PROPERTY = "development";
    public static final String DIRECTORIES_LIST_PROPERTY = "directories";
    protected static final String JONAS_BASE = JProp.getJonasBase();
    public static final String DEFAULT_DIRECTORY = JONAS_BASE + File.separator + "deploy";
    private Log logger = LogFactory.getLog(DeployableMonitor.class);
    private boolean developmentMode = true;
    private JmxService jmxService = null;
    private List<File> directories = new LinkedList<File>();
    private DeployableMonitor deployableMonitor = new DeployableMonitor(this);
    private boolean readyToRunning = false;

    protected void doStart() throws ServiceException {
        File defaultDirectory;
        this.logger.info("Use the deploy directories ''{0}'', development mode is ''{1}''", this.directories, this.developmentMode);
        if (this.deployableMonitor == null) {
            this.deployableMonitor = new DeployableMonitor(this);
        }
        if (!(defaultDirectory = new File(DEFAULT_DIRECTORY)).exists()) {
            this.logger.info("Creating default deploy directory ''{0}''", defaultDirectory);
            defaultDirectory.mkdirs();
        }
        this.directories.add(defaultDirectory);
        if (this.jmxService != null) {
            this.jmxService.loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
            try {
                this.jmxService.registerModelMBean((Object)this, JonasObjectName.deployableMonitorService(this.getDomainName()));
            }
            catch (Exception e) {
                this.logger.warn("Cannot register MBean for Deployable Monitor service", e);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void startMonitoring() {
        this.logger.debug("Start DeployableMonitor", new Object[0]);
        this.deployableMonitor.start();
    }

    protected void doStop() throws ServiceException {
        if (this.jmxService != null) {
            try {
                this.jmxService.unregisterModelMBean(JonasObjectName.deployableMonitorService(this.getDomainName()));
            }
            catch (Exception e) {
                this.logger.warn("Cannot unregister MBean for Deployable Monitor service", e);
            }
        }
        this.deployableMonitor.stopOrder();
        this.deployableMonitor = null;
        this.logger.info("DeployableMonitor stopped successfully", new Object[0]);
    }

    public void setDevelopment(boolean mode) {
        this.developmentMode = mode;
        this.deployableMonitor.setDevelopmentMode(mode);
    }

    public void setDirectories(String dirs) {
        List<String> additionalDirectories = DeployableMonitorService.convertToList(dirs);
        for (String dir2 : additionalDirectories) {
            File tmpFile = new File(dir2);
            if (!tmpFile.isAbsolute()) {
                tmpFile = new File(JONAS_BASE + File.separator + dir2);
            }
            if (!tmpFile.exists()) {
                this.logger.warn("The given directory ''{0}'' is neither present on the filesystem or in JONAS_BASE ''{1}''", tmpFile, JONAS_BASE);
                continue;
            }
            this.directories.add(tmpFile);
        }
        this.deployableMonitor.setDirectories(this.directories);
    }

    public void setExclusions(String exclusionList) {
        List<String> exclusions = DeployableMonitorService.convertToList(exclusionList);
        this.deployableMonitor.setExclusionPatterns(exclusions);
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployableMonitor.setDeployerManager(deployerManager);
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void firstCheckEnded() {
        try {
            ObjectName on = JonasObjectName.deployableMonitorService(this.getDomainName());
            Attribute att = new Attribute("readyToRunning", true);
            this.jmxService.getJmxServer().setAttribute(on, att);
        }
        catch (Exception e) {
            this.logger.warn("Problem when trying to modify 'readyToRunning' attribute", new Object[0]);
        }
    }

    public boolean isReadyToRunning() {
        return this.readyToRunning;
    }

    public void setReadyToRunning(boolean readyToRunning) {
        this.readyToRunning = readyToRunning;
    }
}

