/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.jgroups;

import java.util.ArrayList;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.base.BaseDiscovery;
import org.ow2.jonas.discovery.jgroups.JgroupsDiscoveryServiceImplMBean;
import org.ow2.jonas.discovery.jgroups.comm.exception.StopDiscException;
import org.ow2.jonas.discovery.jgroups.manager.DiscoveryManager;
import org.ow2.jonas.discovery.jgroups.utils.JGroupsDiscoveryUtils;
import org.ow2.jonas.ha.HaService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JgroupsDiscoveryServiceImpl
extends BaseDiscovery
implements JgroupsDiscoveryServiceImplMBean {
    private static final String DEFAULT_RECONNECTION_TIMEOUT = "5000";
    private static Logger logger = Log.getLogger("org.ow2.jonas.discovery");
    private long reconnectionTimeout;
    private String groupName;
    private String conf;
    private DiscoveryManager dm = null;
    String multicastAddress = null;
    String multicastPort = null;
    private HaService haService;

    @Override
    public void doStart() throws ServiceException {
        String discoveryType = "SLAVE";
        this.isDiscoveryMaster = this.getServerProperties().isMaster();
        if (this.isDiscoveryMaster) {
            discoveryType = "MASTER";
        }
        logger.log(BasicLevel.DEBUG, (Object)("Starting discovery " + discoveryType + " on " + this.jmxService.getDomainName() + "for " + this.jmxService.getJonasServerName() + " server.\n"));
        logger = Log.getLogger("org.ow2.jonas.discovery");
        String domainName = this.jmxService.getDomainName();
        JMXServiceURL[] connectorServerURLs = this.jmxService.getConnectorServerURLs();
        this.urlsList = new ArrayList();
        for (int i = 0; i < connectorServerURLs.length; ++i) {
            if (connectorServerURLs[i] == null) continue;
            this.urlsList.add(connectorServerURLs[i].toString());
        }
        String[] urls = new String[this.urlsList.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = (String)this.urlsList.get(i);
        }
        try {
            JGroupsDiscoveryUtils.init(this.jmxService.getJonasServerName(), this.jmxService.getDomainName(), discoveryType, this.conf, this.groupName, this.jmxService.getJmxServer(), urls, this.reconnectionTimeout);
        }
        catch (Throwable e) {
            throw new ServiceException(e.getMessage());
        }
        this.startDomainMonitor(discoveryType);
        try {
            this.multicastAddress = JGroupsDiscoveryUtils.getMulticastAddress();
            this.multicastPort = JGroupsDiscoveryUtils.getMulticastPort();
        }
        catch (Exception e1) {
            logger.log(BasicLevel.DEBUG, (Object)"Cannot retrieve multicast address. Communication protocol is not multicast \n");
        }
        try {
            this.jmxService.registerMBean((Object)this, JonasObjectName.discoveryService(domainName));
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, (Object)" Unable to register discovery MBean: ", (Throwable)e);
        }
        logger.log(BasicLevel.INFO, (Object)("JGroups based Discovery service started from " + this.conf + " Stack file \n"));
    }

    private void startDomainMonitor(String discoveryType) throws ServiceException {
        this.ttl = JGroupsDiscoveryUtils.getInstance().getTtl();
        this.dm = new DiscoveryManager(discoveryType);
        try {
            this.dm.start();
        }
        catch (StopDiscException e) {
            logger.log(BasicLevel.DEBUG, (Object)"Discovery manager failed to start due to a pre-existing server in the domain with the same name.", (Throwable)e);
            throw new ServiceException("Problem when starting the Discovery Service: ", e);
        }
    }

    public void start(HashMap<String, Object> env, MBeanServer mbeanSrv, String discoveryType) throws Exception {
        if (discoveryType.equals("CLUSTERD")) {
            this.isDiscoveryMaster = false;
            this.groupName = (String)env.get("group.name");
            this.conf = (String)env.get("jgroups.conf");
            String hostName = (String)env.get("host.name");
            String domainName = (String)env.get("domain.name");
            String reconnectionTimeoutStr = (String)env.get("reconnection.timeout");
            if (reconnectionTimeoutStr == null) {
                reconnectionTimeoutStr = DEFAULT_RECONNECTION_TIMEOUT;
                logger.log(BasicLevel.DEBUG, (Object)" Reconnection timeout is set to default value\n");
            }
            long reconnectionTimeout = new Long(reconnectionTimeoutStr);
            logger.log(BasicLevel.DEBUG, (Object)(" Cluster daemon named " + hostName + " is starting discovery on domain " + domainName + ".\n"));
            String[] urls = null;
            if (this.urlsList == null) {
                this.urlsList = new ArrayList();
                try {
                    urls = (String[])env.get("connector.urls");
                    for (int i = 0; i < urls.length; ++i) {
                        this.urlsList.add(urls[i]);
                    }
                }
                catch (Exception e) {
                    logger.log(BasicLevel.DEBUG, (Object)(" Exception occurred while getting connector urls for host named " + hostName + " in JGrpups discovery \n"));
                    throw new Exception(e.getMessage() + " Exception occurred while getting connector urls for host named " + hostName + " in JGrpups discovery \n");
                }
            }
            try {
                JGroupsDiscoveryUtils.init(hostName, domainName, "CLUSTERD", this.conf, this.groupName, mbeanSrv, urls, reconnectionTimeout);
            }
            catch (Throwable e) {
                throw new ServiceException(e.getMessage());
            }
            this.startDomainMonitor(discoveryType);
        } else {
            logger.log(BasicLevel.DEBUG, (Object)" JOnAS instance should not use this method");
        }
    }

    @Override
    public void doStop() throws ServiceException {
        this.dm.stop();
        if (JGroupsDiscoveryUtils.isRegistered(JonasObjectName.discoveryService(JGroupsDiscoveryUtils.getInstance().getDomainName()))) {
            logger.log(BasicLevel.DEBUG, (Object)" Discovery MBean is unregistered from the host MBean server\n");
            try {
                JGroupsDiscoveryUtils.unRegisterMBean(JonasObjectName.discoveryService(JGroupsDiscoveryUtils.getInstance().getDomainName()));
            }
            catch (InstanceNotFoundException e) {
                throw new ServiceException(e.getMessage());
            }
            catch (MBeanRegistrationException e) {
                throw new ServiceException(e.getMessage());
            }
        }
    }

    @Override
    public String getDiscoveryProtocolVersion() {
        return "1.3";
    }

    @Override
    public String getDiscoveryTtl() {
        return new Integer(this.ttl).toString();
    }

    @Override
    public void startDiscoveryMaster() throws JMException {
    }

    @Override
    public String getJonasName() {
        return JGroupsDiscoveryUtils.getInstance().getJonasName();
    }

    @Override
    public MBeanServer getMbeanServer() {
        return this.jmxService.getJmxServer();
    }

    @Override
    public ObjectName getMyOn() {
        return JonasObjectName.discoveryService(JGroupsDiscoveryUtils.getInstance().getDomainName());
    }

    @Override
    public String getServerId() {
        return JGroupsDiscoveryUtils.getInstance().getServerId();
    }

    @Override
    public String[] getUrls() {
        return (String[])this.urlsList.toArray();
    }

    @Override
    public void setDomainName(String domainName) {
        JGroupsDiscoveryUtils.getInstance().setDomainName(domainName);
    }

    @Override
    public void setJonasName(String jonasName) {
        JGroupsDiscoveryUtils.getInstance().setJonasName(jonasName);
    }

    @Override
    public void setMbeanServer(MBeanServer mbeanServer) {
        JGroupsDiscoveryUtils.getInstance().setMbeanServer(mbeanServer);
    }

    @Override
    public void setMyOn(ObjectName myOn) {
    }

    @Override
    public void setServerId(String serverId) {
        JGroupsDiscoveryUtils.getInstance().setServerId(serverId);
    }

    @Override
    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    @Override
    public void setUrls(String[] urls) {
        this.urlsList = this.toArrayList(urls);
    }

    private ArrayList toArrayList(String[] urls) throws NullPointerException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            for (int i = 0; i < urls.length; ++i) {
                ret.add(urls[i]);
            }
        }
        catch (NullPointerException e) {
            throw new NullPointerException("NullPointerException occurred in JgroupsDiscoveryServiceImpl. Urls list must not be null in toArrayList method \n" + e);
        }
        return ret;
    }

    @Override
    public void start() throws ServiceException {
        this.doStart();
    }

    @Override
    public void stop() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to stop discovery service \n" + e));
        }
        logger.log(BasicLevel.INFO, (Object)"Discovery servive stopped \n");
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getJgroupsConf() {
        return this.conf;
    }

    public void setJgroupsConf(String conf) {
        this.conf = conf;
    }

    @Override
    public void setMaster(boolean isMaster) {
        this.isDiscoveryMaster = isMaster;
    }

    @Override
    public int getGreetingTimeout() {
        return this.greetingAckTimeOut;
    }

    @Override
    public JmxService getJmxService() {
        return this.jmxService;
    }

    @Override
    public String getListeningIp() {
        return JGroupsDiscoveryUtils.getInstance().getLocalAddress().getIpAddress().toString();
    }

    @Override
    public int getListeningPort() {
        return JGroupsDiscoveryUtils.getInstance().getDiscPort();
    }

    @Override
    public int getTtl() {
        return this.ttl;
    }

    @Override
    public ArrayList getUrlsList() {
        return this.urlsList;
    }

    @Override
    public boolean isDiscoveryMaster() {
        return new Boolean(this.isDiscoveryMaster);
    }

    @Override
    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    @Override
    public void setListeningIp(String listeningIp) {
    }

    @Override
    public void setListeningPort(int listeningPort) {
    }

    @Override
    public void setUrlsList(ArrayList urlsList) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting urls \n");
        this.urlsList = urlsList;
    }

    public int getGreetingListeningPort() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting listening port \n");
        return JGroupsDiscoveryUtils.getInstance().getDiscPort();
    }

    public void setTimeToLive(int ttl) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting ttl: not yet implemented \n");
    }

    @Override
    public void setGreetingTimeout(int greetingAckTimeOut) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting greeting timeout \n");
        this.greetingAckTimeOut = greetingAckTimeOut;
    }

    @Override
    public Boolean getIsDiscoveryMaster() {
        logger.log(BasicLevel.DEBUG, (Object)"Checking if discovery is master \n");
        return new Boolean(this.isDiscoveryMaster);
    }

    @Override
    public String getMulticastAddress() {
        return this.multicastAddress;
    }

    @Override
    public String getMulticastPort() {
        return this.multicastPort;
    }

    public String isMulticast() {
        return new Boolean(JGroupsDiscoveryUtils.getInstance().isMulticast()).toString();
    }

    public long getReconnectionTimeout() {
        return this.reconnectionTimeout;
    }

    public void setReconnectionTimeout(long reconnectionTimeout) {
        this.reconnectionTimeout = reconnectionTimeout;
    }

    public HaService getHaService() {
        return this.haService;
    }

    public void setHaService(HaService haService) {
        this.haService = haService;
    }
}

