/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ear.internal;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.deployment.InjectionHolder;
import org.ow2.easybeans.deployment.api.EZBInjectionHolder;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.naming.context.ContextImpl;
import org.ow2.easybeans.persistence.PersistenceUnitManager;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzer;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzerException;
import org.ow2.jonas.deployment.client.wrapper.ClientManagerWrapper;
import org.ow2.jonas.deployment.ear.EarDeploymentDesc;
import org.ow2.jonas.deployment.ear.EarDeploymentDescException;
import org.ow2.jonas.deployment.ear.wrapper.EarManagerWrapper;
import org.ow2.jonas.deployment.ejb.wrapper.EjbManagerWrapper;
import org.ow2.jonas.deployment.web.wrapper.WebManagerWrapper;
import org.ow2.jonas.ear.EarServiceException;
import org.ow2.jonas.ear.internal.EARModule;
import org.ow2.jonas.ejb2.EJBService;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.wsgen.WsGen;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.util.ModuleNamingUtils;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.resource.ResourceServiceException;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.ws.WebServicesService;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJB21Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.LibDeployable;
import org.ow2.util.ee.deploy.api.deployable.RARDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.impl.archive.ArchiveManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.file.FileUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarDeployer
implements IDeployer {
    public static final String DEFAULT_FOLDER = "JOnAS-Deployer";
    private Log logger = LogFactory.getLog(EarDeployer.class);
    private WebServicesService wsService = null;
    private JmxService jmxService = null;
    private ResourceService resourceService = null;
    private EJBService ejb21Service = null;
    private JWebContainerService webContainerService = null;
    private ClassLoader appsClassLoader;
    private Map<URL, EARDeployable> ears = new HashMap<URL, EARDeployable>();
    private ServerProperties serverProperties = null;
    private static final String WORK_DIR = JProp.getWorkDir();
    private static final String WORK_APPS_DIR = WORK_DIR + File.separator + "apps";
    protected static final String WORK_WEBAPPS_DIR = WORK_DIR + File.separator + "webapps";
    protected static final String INEAR_WORK_WEBAPPS_DIR_SUFFIX = "ear";
    private EZBServer embedded = null;
    private DeployerLog deployerLog;
    private static final String WSDL_DIRECTORY = "META-INF/wsdl/";

    public EZBServer getEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(EZBServer embedded) {
        this.embedded = embedded;
    }

    @Override
    public void deploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof EARDeployable) {
            try {
                File folder = new File(WORK_APPS_DIR, this.getServerProperties().getServerName());
                File originalFile = URLUtils.urlToFile(deployable.getArchive().getURL());
                String archiveName = FileUtils.lastModifiedFileName(originalFile);
                EARDeployable earDeployable = UnpackDeployableHelper.unpack((EARDeployable)deployable, folder, archiveName, false);
                this.deployEAR(earDeployable);
            }
            catch (Exception e) {
                throw new DeployerException("Cannot deploy archive for '" + deployable.getArchive() + "'", e);
            }
        }
    }

    protected EARDeployable applyWSGenIfNeeded(final IArchive archive, final EARDeployable deployable) throws DeployerException {
        if (this.wsService == null) {
            this.logger.debug("The WS service is not present, no need to call WSGen", new Object[0]);
            return deployable;
        }
        if (!this.wsService.isAutoWsGenEngaged()) {
            this.logger.debug("Automatic WsGen is not enabled, no need to call WSGen", new Object[0]);
            return deployable;
        }
        IExecution<EARDeployable> exec = new IExecution<EARDeployable>(){

            @Override
            public EARDeployable execute() throws Exception {
                EARDeployable earDeployable = deployable;
                WsGen wsGen = new WsGen();
                Config config = new Config();
                config.setInputname(deployable.getArchive().getURL().toURI().getPath());
                config.setOut(new File(JProp.getWorkDir(), "wsgen"));
                try {
                    String path = wsGen.execute(config, deployable);
                    if (!path.equals(deployable.getArchive().getURL().getPath())) {
                        IArchive archive2 = ArchiveManager.getInstance().getArchive(new File(path));
                        EARDeployable newDeployable = (EARDeployable)DeployableHelper.getDeployable(archive2);
                        File folder = new File(WORK_APPS_DIR, EarDeployer.this.getServerProperties().getServerName());
                        String archiveName = URLUtils.urlToFile(deployable.getArchive().getURL()).getName();
                        earDeployable = UnpackDeployableHelper.unpack(newDeployable, folder, archiveName, false);
                        earDeployable.setOriginalDeployable(deployable.getOriginalDeployable());
                    }
                }
                catch (Exception e) {
                    throw new DeployerException("Cannot execute WSGen on archive '" + archive + "'", e);
                }
                finally {
                    FileUtils.delete(config.getOut());
                }
                return earDeployable;
            }
        };
        ExecutionResult<EARDeployable> result = null;
        try {
            result = RunnableHelper.execute(LoaderManager.getInstance().getExternalLoader(), exec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result.hasException()) {
            throw new DeployerException(result.getException().getMessage(), result.getException());
        }
        return result.getResult();
    }

    protected void deployEAR(EARDeployable deployable) throws DeployerException {
        File file;
        URL originalURL;
        URL earURL;
        IArchive earArchive = deployable.getArchive();
        EARDeployable earDeployable = this.applyWSGenIfNeeded(earArchive, deployable);
        try {
            earURL = earArchive.getURL();
            if ("file".equals(earURL.getProtocol())) {
                File file2 = URLUtils.urlToFile(earURL);
                earURL = file2.toURL();
            }
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get URL from archive '" + earArchive + "'", e);
        }
        try {
            originalURL = ((EARDeployable)earDeployable.getOriginalDeployable()).getArchive().getURL();
            if ("file".equals(originalURL.getProtocol())) {
                File file3 = URLUtils.urlToFile(originalURL);
                originalURL = file3.toURL();
            }
            if (this.deployerLog != null) {
                this.deployerLog.addEntry(new File(originalURL.getFile()), new File(earURL.getFile()));
            }
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get the url of the initial deployable for the EAR Module '" + earDeployable.getOriginalDeployable() + "'.", e);
        }
        URLClassLoader loaderCls = new URLClassLoader(new URL[]{earURL}, this.appsClassLoader);
        EarDeploymentDesc earDD = null;
        URL applicationXML = null;
        try {
            applicationXML = earArchive.getResource("META-INF/application.xml");
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get resource META-INF/application.xml", e);
        }
        if (applicationXML != null) {
            try {
                earDD = EarManagerWrapper.getDeploymentDesc(earDeployable, loaderCls);
            }
            catch (EarDeploymentDescException e) {
                String err = "Error in the Deployment descriptor '" + earDeployable.getOriginalDeployable() + "': " + e;
                this.logger.error(err, new Object[0]);
                throw new EarServiceException(err, e);
            }
        }
        String[] securityRoles = new String[]{};
        if (earDD != null) {
            securityRoles = earDD.getSecurityRolesNames();
        }
        this.logger.debug("Creating the EAR classLoader", new Object[0]);
        JClassLoader earClassLoader = new JClassLoader(earURL.toExternalForm(), new URL[0], this.appsClassLoader);
        String[] roleNames = new String[securityRoles.length];
        String affRoleNames = "";
        for (int i = 0; i < securityRoles.length; ++i) {
            roleNames[i] = securityRoles[i];
            affRoleNames = affRoleNames + roleNames[i] + ";";
        }
        this.logger.debug("role names = ''{0}''", affRoleNames);
        LinkedList<URL> urlsEJB = new LinkedList<URL>();
        LinkedList<URL> urlsAltDDEJB = new LinkedList<URL>();
        for (EJBDeployable<?> ejb : earDeployable.getEJBDeployables()) {
            try {
                URL ejbURL = ejb.getArchive().getURL();
                if ("file".equals(ejbURL.getProtocol())) {
                    File file4 = URLUtils.urlToFile(ejbURL);
                    ejbURL = file4.toURL();
                }
                urlsEJB.add(ejbURL);
                urlsAltDDEJB.add(earDeployable.getAltDDURL(ejb));
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get the URL for the archive '" + ejb.getArchive() + "'", e);
            }
        }
        LinkedList<URL> urlsWAR = new LinkedList<URL>();
        LinkedList<URL> urlslAtDDWAR = new LinkedList<URL>();
        for (WARDeployable war : earDeployable.getWARDeployables()) {
            try {
                URL warURL = war.getArchive().getURL();
                if ("file".equals(warURL.getProtocol())) {
                    File file5 = URLUtils.urlToFile(warURL);
                    warURL = file5.toURL();
                }
                urlsWAR.add(warURL);
                urlslAtDDWAR.add(earDeployable.getAltDDURL(war));
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get the URL for the archive '" + war.getArchive() + "'", e);
            }
        }
        if (urlsWAR.size() > 0 && this.deployerLog != null) {
            try {
                File unpackedWarFile = new File(WORK_WEBAPPS_DIR, this.getServerProperties().getServerName() + File.separator + INEAR_WORK_WEBAPPS_DIR_SUFFIX + File.separator + URLUtils.shorterName(earDeployable.getArchive().getURL()));
                this.deployerLog.addEntry(new File(originalURL.getFile()), unpackedWarFile);
            }
            catch (Exception e) {
                this.logger.warn("Error when adding the log entry for unpacked wars directory.", new Object[0]);
            }
        }
        LinkedList<URL> urlsRAR = new LinkedList<URL>();
        LinkedList<URL> urlsAtDDRAR = new LinkedList<URL>();
        for (RARDeployable rar : earDeployable.getRARDeployables()) {
            try {
                URL rarURL = rar.getArchive().getURL();
                if ("file".equals(rarURL.getProtocol())) {
                    File file6 = URLUtils.urlToFile(rarURL);
                    rarURL = file6.toURL();
                }
                urlsRAR.add(rarURL);
                urlsAtDDRAR.add(earDeployable.getAltDDURL(rar));
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get the URL for the archive '" + rar.getArchive() + "'", e);
            }
        }
        LinkedList<URL> urlsClient = new LinkedList<URL>();
        LinkedList<URL> urlsAtDDClient = new LinkedList<URL>();
        for (CARDeployable car : earDeployable.getCARDeployables()) {
            try {
                URL carURL = car.getArchive().getURL();
                if ("file".equals(carURL.getProtocol())) {
                    File file7 = URLUtils.urlToFile(carURL);
                    carURL = file7.toURL();
                }
                urlsClient.add(carURL);
                urlsAtDDClient.add(earDeployable.getAltDDURL(car));
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get the URL for the archive '" + car.getArchive() + "'", e);
            }
        }
        EjbManagerWrapper.setAvailableEjbJarsAndAltDDs(earClassLoader, urlsEJB.toArray(new URL[urlsEJB.size()]), urlsAltDDEJB.toArray(new URL[urlsAltDDEJB.size()]));
        WebManagerWrapper.setAltDD(earClassLoader, urlsWAR.toArray(new URL[urlsWAR.size()]), urlslAtDDWAR.toArray(new URL[urlslAtDDWAR.size()]));
        ClientManagerWrapper.setAltDD(earClassLoader, urlsClient.toArray(new URL[urlsClient.size()]), urlsAtDDClient.toArray(new URL[urlsAtDDClient.size()]));
        this.deployRARs(earDeployable, earURL, earClassLoader);
        List<EJB3Deployable> ejb3s = earDeployable.getEJB3Deployables();
        List<EJBDeployable<?>> ejbs = earDeployable.getEJBDeployables();
        List<LibDeployable> libs = earDeployable.getLibDeployables();
        LinkedList<URL> urls = new LinkedList<URL>();
        for (EJBDeployable<?> ejb : ejbs) {
            try {
                URL ejbURL = ejb.getArchive().getURL();
                if ("file".equals(ejbURL.getProtocol())) {
                    file = URLUtils.urlToFile(ejbURL);
                    ejbURL = file.toURL();
                }
                urls.add(ejbURL);
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + ejb.getArchive() + "'.", e);
            }
        }
        for (LibDeployable lib : libs) {
            try {
                URL libURL = lib.getArchive().getURL();
                if ("file".equals(libURL.getProtocol())) {
                    file = URLUtils.urlToFile(libURL);
                    libURL = file.toURL();
                }
                urls.add(libURL);
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + lib.getArchive() + "'.", e);
            }
        }
        URL[] arrayURLs = urls.toArray(new URL[urls.size()]);
        EasyBeansClassLoader ejbClassLoader = new EasyBeansClassLoader(arrayURLs, (ClassLoader)earClassLoader);
        List<IArchive> libArchives = this.getLibArchives(earDeployable);
        EZBPersistenceUnitManager persistenceUnitManager = this.getPersistenceUnitManager(earDeployable, ejbClassLoader);
        this.addEjbContextIdToList(earDeployable, new LinkedList<String>(), true);
        LinkedList<EZBContainer> containers = new LinkedList<EZBContainer>();
        for (EJB3Deployable ejb : ejb3s) {
            if (this.getEmbedded() == null) {
                throw new DeployerException("No EJB3 service, but there are EJB3s in the given EAR archive '" + earDeployable.getArchive() + "'.");
            }
            EZBContainer container = this.getEmbedded().createContainer(ejb.getArchive());
            container.setApplicationName(ModuleNamingUtils.fromURL(earURL));
            container.setExtraArchives(libArchives);
            containers.add(container);
        }
        for (EZBContainer container : containers) {
            container.setClassLoader(ejbClassLoader);
            container.setPersistenceUnitManager(persistenceUnitManager);
        }
        InjectionHolder ejbInjectionHolder = new InjectionHolder();
        ejbInjectionHolder.setPersistenceUnitManager(persistenceUnitManager);
        for (EZBContainer container : containers) {
            try {
                container.start();
            }
            catch (Exception e) {
                this.logger.error("Cannot start container {0}", container.getName(), e);
                try {
                    container.stop();
                    this.getEmbedded().removeContainer(container);
                }
                catch (Exception se) {
                    this.logger.error("Cannot stop failing container {0}", container.getName(), se);
                }
                throw new DeployerException("Container '" + container.getName() + "' has failed", e);
            }
        }
        this.deployEJB21s(earDeployable, earURL, earClassLoader, ejbClassLoader, roleNames);
        this.deployWebServices(earDeployable, earURL, earClassLoader, ejbClassLoader, urlsEJB, urlsWAR);
        this.linkPolicyObjects(earDeployable);
        this.commitEJBPolicyObjects(earDeployable);
        this.deployWARs(earDeployable, earURL, earClassLoader, ejbClassLoader, ejbInjectionHolder);
        this.commitWebBPolicyObjects(earDeployable);
        this.completeWebServicesDeployment(earURL, earClassLoader);
        EARModule earModule = new EARModule(earDeployable, "");
        try {
            this.jmxService.registerMBean(earModule);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot register the MBean for the EAR Module of EARDeployable '" + earDeployable.getOriginalDeployable() + "'.", e);
        }
        if (this.ejb21Service != null) {
            this.ejb21Service.removeCache(earClassLoader);
        }
        if (this.webContainerService != null) {
            this.webContainerService.removeCache(earClassLoader);
        }
        if (this.wsService != null) {
            this.wsService.removeCache(earClassLoader);
        }
        this.ears.put(originalURL, earDeployable);
        this.logger.info("''{0}'' EAR Deployable is now deployed", earDeployable.getOriginalDeployable());
    }

    protected EZBPersistenceUnitManager getPersistenceUnitManager(EARDeployable earDeployable, ClassLoader appClassLoader) {
        List<LibDeployable> libs = earDeployable.getLibDeployables();
        PersistenceUnitManager persistenceUnitManager = null;
        for (LibDeployable lib : libs) {
            PersistenceUnitManager builtPersistenceUnitManager = null;
            try {
                builtPersistenceUnitManager = PersistenceXmlFileAnalyzer.analyzePersistenceXmlFile(lib.getArchive(), appClassLoader);
            }
            catch (PersistenceXmlFileAnalyzerException e) {
                throw new IllegalStateException("Failure when analyzing the persistence.xml file", e);
            }
            if (persistenceUnitManager != null) {
                if (builtPersistenceUnitManager == null) continue;
                persistenceUnitManager.addExtraPersistenceUnitInfos(builtPersistenceUnitManager.getPersistenceUnitInfos());
                continue;
            }
            persistenceUnitManager = builtPersistenceUnitManager;
        }
        return persistenceUnitManager;
    }

    protected void undeployEAR(EARDeployable tmpEARDeployable) throws DeployerException {
        List<EJB21Deployable> ejb21Deployables;
        URL earURL;
        this.logger.info("Undeploying {0}", tmpEARDeployable);
        EARDeployable earDeployable = tmpEARDeployable;
        try {
            earURL = earDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL on the EAR deployable '" + earDeployable + "'.", e);
        }
        EARDeployable unpackedDeployable = (EARDeployable)earDeployable.getUnpackedDeployable();
        if (unpackedDeployable != null) {
            earDeployable = unpackedDeployable;
        } else if (this.ears.containsKey(earURL)) {
            earDeployable = this.ears.get(earURL);
        }
        List<WARDeployable> warDeployables = earDeployable.getWARDeployables();
        if (warDeployables != null && this.webContainerService != null) {
            LinkedList<URL> urls = new LinkedList<URL>();
            for (WARDeployable warDeployable : warDeployables) {
                try {
                    urls.add(warDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    this.logger.error("Cannot get the URL from the Deployable ''{0}''", warDeployable, e);
                }
            }
            URL[] warURLs = urls.toArray(new URL[urls.size()]);
            this.webContainerService.unDeployWars(warURLs);
        }
        if ((ejb21Deployables = earDeployable.getEJB21Deployables()) != null && this.ejb21Service != null) {
            LinkedList<URL> urls = new LinkedList<URL>();
            for (EJB21Deployable ejbDeployable : ejb21Deployables) {
                try {
                    urls.add(ejbDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    this.logger.error("Cannot get the URL from the Deployable ''{0}''", ejbDeployable, e);
                }
            }
            URL[] ejbJarURLs = urls.toArray(new URL[urls.size()]);
            this.ejb21Service.unDeployJars(ejbJarURLs);
        }
        this.undeployEJB3FromEAR(earDeployable);
        List<RARDeployable> rarDeployables = earDeployable.getRARDeployables();
        if (rarDeployables != null && this.resourceService != null) {
            LinkedList<URL> urls = new LinkedList<URL>();
            for (RARDeployable rarDeployable : rarDeployables) {
                try {
                    urls.add(rarDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    this.logger.error("Cannot get the URL from the Deployable ''{0}''", rarDeployable, e);
                }
            }
            URL[] rarURLs = urls.toArray(new URL[urls.size()]);
            this.resourceService.unDeployRars(rarURLs, earURL);
        }
        EARModule earModule = new EARModule(earDeployable, "");
        try {
            this.jmxService.unregisterMBean(earModule);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot unregister the MBean for the EAR Module of EARDeployable '" + earDeployable + "'.", e);
        }
        this.ears.remove(earURL);
        this.logger.info("''{0}'' EAR Deployable is now undeployed", tmpEARDeployable);
    }

    protected void undeployEJB3FromEAR(EARDeployable earDeployable) throws DeployerException {
        EARDeployable workingDeployable = earDeployable;
        EARDeployable unpackedDeployable = (EARDeployable)earDeployable.getUnpackedDeployable();
        if (unpackedDeployable != null) {
            workingDeployable = unpackedDeployable;
        }
        LinkedList<EZBContainer> containers = new LinkedList<EZBContainer>();
        for (EJB3Deployable ejb3 : workingDeployable.getEJB3Deployables()) {
            EZBContainer container = this.getEmbedded().findContainer(ejb3.getArchive());
            if (container == null) {
                this.logger.warn("No container found for the archive ''{0}'', creation has maybe failed", ejb3.getArchive());
                continue;
            }
            containers.add(container);
        }
        for (EZBContainer container : containers) {
            container.stop();
            this.getEmbedded().removeContainer(container);
        }
    }

    private void check(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }

    @Override
    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof EARDeployable) {
            this.undeployEAR((EARDeployable)deployable);
        }
    }

    @Override
    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        throw new UnsupportedOperationException("IsDeployed not yet supported");
    }

    @Override
    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof EARDeployable;
    }

    protected void deployWARs(EARDeployable earDeployable, URL earURL, ClassLoader earClassLoader, ClassLoader parentClassLoader, EZBInjectionHolder ejbInjectionHolder) throws DeployerException {
        List<WARDeployable> wars = earDeployable.getWARDeployables();
        if (wars.size() > 0) {
            if (this.webContainerService == null) {
                this.logger.warn("There are WAR files in the EAR ''{0}'' but the 'web' service is not available", earDeployable);
                return;
            }
            ContextImpl ctx = new ContextImpl(earURL.toExternalForm());
            try {
                ctx.rebind("earDeployable", (Object)earDeployable);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the EAR deployable parameter '" + earDeployable + "'", e);
            }
            try {
                ctx.rebind("earURL", (Object)earURL);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the EAR URL parameter '" + earURL + "'", e);
            }
            LinkedList<URL> urls = new LinkedList<URL>();
            LinkedList<String> ctxRoots = new LinkedList<String>();
            for (WARDeployable warDeployable : wars) {
                URL url = null;
                try {
                    url = warDeployable.getArchive().getURL();
                    if ("file".equals(url.getProtocol())) {
                        File file = URLUtils.urlToFile(url);
                        url = file.toURL();
                    }
                }
                catch (Exception e) {
                    throw new DeployerException("Cannot get the URL for the archive '" + warDeployable.getArchive() + "'", e);
                }
                urls.add(url);
                ctxRoots.add(warDeployable.getContextRoot());
            }
            try {
                ctx.rebind("urls", (Object)urls.toArray(new URL[urls.size()]));
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the urls parameter '" + urls + "'", e);
            }
            try {
                ctx.rebind("parentClassLoader", (Object)parentClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the parentClassLoader parameter '" + parentClassLoader + "'", e);
            }
            try {
                ctx.rebind("earClassLoader", (Object)earClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", e);
            }
            try {
                ctx.rebind("altDDs", (Object)new URL[urls.size()]);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the altDDs parameter.'", e);
            }
            try {
                ctx.rebind("contextRoots", (Object)ctxRoots.toArray(new String[ctxRoots.size()]));
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the contextRoots parameter '" + urls + "'", e);
            }
            try {
                ctx.rebind(EZBInjectionHolder.class.getName(), (Object)ejbInjectionHolder);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the ejb injection holder parameter '" + ejbInjectionHolder + "'", e);
            }
            try {
                this.webContainerService.deployWars(ctx);
            }
            catch (JWebContainerServiceException e) {
                throw new DeployerException("Cannot deploy the WARs.'", e);
            }
        }
    }

    protected void deployEJB21s(EARDeployable earDeployable, URL earURL, URLClassLoader earClassLoader, ClassLoader ejbClassLoader, String[] roleNames) throws DeployerException {
        List<EJB21Deployable> ejbs = earDeployable.getEJB21Deployables();
        if (ejbs.size() > 0) {
            if (this.ejb21Service == null) {
                this.logger.warn("There are EJB 2.1 files in the EAR ''{0}'' but the EJB 2.1 service is not available", earDeployable);
                return;
            }
            LinkedList<URL> urls = new LinkedList<URL>();
            for (EJB21Deployable ejb21Deployable : ejbs) {
                try {
                    urls.add(ejb21Deployable.getArchive().getURL());
                    URL wsdlDirectory = ejb21Deployable.getArchive().getResource(WSDL_DIRECTORY);
                    if (wsdlDirectory == null) continue;
                    try {
                        Method addURLMethod = ejbClassLoader.getClass().getSuperclass().getDeclaredMethod("addURL", URL.class);
                        addURLMethod.setAccessible(true);
                        addURLMethod.invoke((Object)ejbClassLoader, wsdlDirectory);
                    }
                    catch (Exception e) {
                        this.logger.warn("Cannot add URL for META-INF/wsdl directory to the EasyBeansClassloader", e);
                    }
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get the URL for the archive '" + ejb21Deployable.getArchive() + "'", e);
                }
            }
            URL[] compilationURLs = null;
            URL[] myApplicationJars = earClassLoader.getURLs();
            URL[] appsJars = ((URLClassLoader)earClassLoader.getParent()).getURLs();
            compilationURLs = new URL[myApplicationJars.length + appsJars.length + urls.size()];
            System.arraycopy(urls.toArray(new URL[urls.size()]), 0, compilationURLs, 0, urls.size());
            System.arraycopy(appsJars, 0, compilationURLs, urls.size(), appsJars.length);
            System.arraycopy(myApplicationJars, 0, compilationURLs, urls.size() + appsJars.length, myApplicationJars.length);
            for (EJB21Deployable ejb : ejbs) {
                URL ejbURL = null;
                try {
                    ejbURL = ejb.getArchive().getURL();
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get the URL on the deployable '" + ejb + "'", e);
                }
                this.logger.debug("Calling GenIC on the EJB ''{0}'' with compilation URL ''{1}''.", ejbURL, Arrays.asList(compilationURLs));
                this.ejb21Service.checkGenIC(ejbURL.getFile(), compilationURLs);
            }
            ContextImpl ctx = new ContextImpl(earURL.toExternalForm());
            try {
                ctx.rebind("earUrl", (Object)earURL);
                ctx.rebind("earRootUrl", (Object)earURL);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the EAR URL parameter '" + earURL + "'", e);
            }
            try {
                ctx.rebind("jarURLs", (Object)urls.toArray(new URL[urls.size()]));
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the urls parameter '" + urls + "'", e);
            }
            try {
                ctx.rebind("earClassLoader", (Object)earClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", e);
            }
            try {
                ctx.rebind("ejbClassLoader", (Object)ejbClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the ejbClassLoader parameter '" + ejbClassLoader + "'", e);
            }
            try {
                ctx.rebind("roleNames", (Object)roleNames);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the altDDs parameter.'", e);
            }
            try {
                this.ejb21Service.deployJars(ctx);
            }
            catch (ServiceException e) {
                throw new DeployerException("Cannot deploy the EJB 2.1'", e);
            }
        }
    }

    protected void deployRARs(EARDeployable earDeployable, URL earURL, ClassLoader earClassLoader) throws DeployerException {
        List<RARDeployable> rars = earDeployable.getRARDeployables();
        if (rars.size() > 0) {
            if (this.resourceService == null) {
                this.logger.warn("There are RAR files in the EAR ''{0}'' but the resource service is not available", earDeployable);
                return;
            }
            ContextImpl ctx = new ContextImpl(earURL.toExternalForm());
            try {
                ctx.rebind("earUrl", (Object)earURL);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the EAR URL parameter '" + earURL + "'", e);
            }
            LinkedList<URL> urls = new LinkedList<URL>();
            for (RARDeployable rarDeployable : rars) {
                try {
                    urls.add(rarDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get the URL for the archive '" + rarDeployable.getArchive() + "'", e);
                }
            }
            try {
                ctx.rebind("urls", (Object)urls.toArray(new URL[urls.size()]));
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the urls parameter '" + urls + "'", e);
            }
            try {
                ctx.rebind("earClassLoader", (Object)earClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", e);
            }
            try {
                ctx.rebind("altDDs", (Object)new URL[urls.size()]);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the altDDs parameter.'", e);
            }
            try {
                this.resourceService.deployRars(ctx);
            }
            catch (ResourceServiceException e) {
                throw new DeployerException("Cannot deploy the RARs.'", e);
            }
        }
    }

    protected void deployWebServices(EARDeployable earDeployable, URL earURL, ClassLoader earClassLoader, ClassLoader ejbClassLoader, List<URL> urlsEJB, List<URL> urlsWAR) throws DeployerException {
        if (this.wsService == null) {
            return;
        }
        ContextImpl ctx = new ContextImpl(earURL.toExternalForm());
        try {
            ctx.rebind("unpackDir", (Object)earURL.toExternalForm());
        }
        catch (NamingException e) {
            throw new DeployerException("Cannot add the 'unpackDir' parameter '", e);
        }
        try {
            ctx.rebind("jarUrls", (Object)urlsEJB.toArray(new URL[urlsEJB.size()]));
        }
        catch (NamingException e) {
            throw new DeployerException("Cannot add the 'jarUrls' parameter '", e);
        }
        URL[] warURLs = urlsWAR.toArray(new URL[urlsWAR.size()]);
        try {
            ctx.rebind("warUrls", (Object)warURLs);
        }
        catch (NamingException e) {
            throw new DeployerException("Cannot add the 'warUrls' parameter '", e);
        }
        try {
            Hashtable<URL, String> ctxRoots = new Hashtable<URL, String>();
            List<WARDeployable> wars = earDeployable.getWARDeployables();
            for (WARDeployable deployable : wars) {
                ctxRoots.put(deployable.getArchive().getURL(), deployable.getContextRoot());
            }
            ctx.rebind("warCtxRootMapping", ctxRoots);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot add the 'warCtxRootMapping' parameter '", e);
        }
        try {
            ctx.rebind("earURL", (Object)earURL);
        }
        catch (NamingException e) {
            throw new DeployerException("Cannot add the 'earURL' parameter '" + earURL + "'", e);
        }
        try {
            ctx.rebind("ejbClassLoader", (Object)ejbClassLoader);
        }
        catch (NamingException e) {
            throw new DeployerException("Cannot add the ejbClassLoader parameter '" + ejbClassLoader + "'", e);
        }
        try {
            ctx.rebind("earClassLoader", (Object)earClassLoader);
        }
        catch (NamingException e) {
            throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", e);
        }
        try {
            this.wsService.deployWebServices(ctx);
        }
        catch (JWebContainerServiceException e) {
            throw new DeployerException("Cannot deploy the Web Services.", e);
        }
    }

    protected void completeWebServicesDeployment(URL earURL, ClassLoader earClassLoader) throws DeployerException {
        if (this.wsService != null) {
            try {
                ComponentContext contctx = null;
                try {
                    contctx = new ComponentContext(earURL.toExternalForm());
                    contctx.rebind("classloader", (Object)earClassLoader);
                    ObjectName name = J2eeObjectName.J2EEApplication(this.getServerProperties().getDomainName(), this.getServerProperties().getServerName(), ModuleNamingUtils.fromURL(earURL));
                    contctx.rebind("parentObjectName", (Object)name);
                    contctx.rebind("isInEar", (Object)Boolean.TRUE);
                }
                catch (NamingException e) {
                    String err = "Can not bind params for the WebServices service, can't complete deployment of Web Services Endpoints";
                    throw new JWebContainerServiceException(err, e);
                }
                this.wsService.completeWSDeployment(contctx);
            }
            catch (Exception e) {
                throw new DeployerException("Cannot complete Web Services deployment.", e);
            }
        }
    }

    private void linkPolicyObjects(EARDeployable earDeployable) throws DeployerException {
        LinkedList<String> ctxIDs = new LinkedList<String>();
        this.addEjbContextIdToList(earDeployable, ctxIDs, false);
        this.addWebBContextIdToList(earDeployable, ctxIDs, true);
        try {
            for (String toBeLinkedCtxId : ctxIDs) {
                PolicyConfiguration toBeLinkedPC = this.getPolicyConfigurationFactory().getPolicyConfiguration(toBeLinkedCtxId, false);
                for (String linkedCtxId : ctxIDs) {
                    if (toBeLinkedCtxId.equals(linkedCtxId)) continue;
                    PolicyConfiguration linkedPC = this.getPolicyConfigurationFactory().getPolicyConfiguration(linkedCtxId, false);
                    toBeLinkedPC.linkConfiguration(linkedPC);
                }
            }
        }
        catch (PolicyContextException pce) {
            throw new DeployerException("Cannot retrieve a policy configuration", pce);
        }
    }

    private void addEjbContextIdToList(EARDeployable earDeployable, List<String> contextIDs, boolean resetPolicyConfiguration) throws DeployerException {
        List<EJBDeployable<?>> ejbDeployables = earDeployable.getEJBDeployables();
        LinkedList<URL> urls = new LinkedList<URL>();
        if (ejbDeployables != null) {
            for (EJBDeployable<?> ejbDeployable : ejbDeployables) {
                try {
                    urls.add(ejbDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get URL on the deployable '" + ejbDeployable + "'.", e);
                }
            }
        }
        URL[] jarUrls = urls.toArray(new URL[urls.size()]);
        for (int u = 0; u < jarUrls.length; ++u) {
            String ctxId = jarUrls[u].getPath();
            if (resetPolicyConfiguration) {
                try {
                    this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId, true);
                }
                catch (PolicyContextException pce) {
                    throw new DeployerException("Cannot retrieve a policy configuration", pce);
                }
            }
            contextIDs.add(ctxId);
        }
    }

    private void addWebBContextIdToList(EARDeployable earDeployable, List<String> contextIDs, boolean resetPolicyConfiguration) throws DeployerException {
        List<WARDeployable> warDeployables = earDeployable.getWARDeployables();
        if (warDeployables != null) {
            for (WARDeployable warDeployable : warDeployables) {
                URL warURL = null;
                try {
                    warURL = warDeployable.getArchive().getURL();
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get URL on the deployable '" + warDeployable + "'.", e);
                }
                String ctxId = warURL.getFile() + warDeployable.getContextRoot();
                if (resetPolicyConfiguration) {
                    try {
                        this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId, true);
                    }
                    catch (PolicyContextException pce) {
                        throw new DeployerException("Cannot retrieve a policy configuration", pce);
                    }
                }
                contextIDs.add(ctxId);
            }
        }
    }

    private void commitEJBPolicyObjects(EARDeployable earDeployable) throws DeployerException {
        LinkedList<String> ctxIDs = new LinkedList<String>();
        this.addEjbContextIdToList(earDeployable, ctxIDs, false);
        this.commitPolicyObjects(ctxIDs);
    }

    private void commitWebBPolicyObjects(EARDeployable earDeployable) throws DeployerException {
        LinkedList<String> ctxIDs = new LinkedList<String>();
        this.addWebBContextIdToList(earDeployable, ctxIDs, false);
        this.commitPolicyObjects(ctxIDs);
    }

    private PolicyConfigurationFactory getPolicyConfigurationFactory() throws DeployerException {
        PolicyConfigurationFactory pcFactory = null;
        try {
            pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (Exception cnfe) {
            throw new DeployerException("Cannot retrieve current policy configuration factory", cnfe);
        }
        return pcFactory;
    }

    private void commitPolicyObjects(List<String> ctxIDs) throws DeployerException {
        String ctxId2 = null;
        try {
            for (String ctxId2 : ctxIDs) {
                PolicyConfiguration pc = this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId2, false);
                pc.commit();
            }
        }
        catch (PolicyContextException pce) {
            throw new DeployerException("Cannot commit policy configuration with Id '" + ctxId2 + "'", pce);
        }
        Policy.getPolicy().refresh();
    }

    public void setWsService(WebServicesService wsService) {
        this.wsService = wsService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setEjb21Service(EJBService ejb21Service) {
        this.ejb21Service = ejb21Service;
    }

    public void setJMXService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setWebContainerService(JWebContainerService webContainerService) {
        this.webContainerService = webContainerService;
    }

    public void setAppsClassLoader(ClassLoader appsClassLoader) {
        this.appsClassLoader = appsClassLoader;
    }

    protected List<IArchive> getLibArchives(EARDeployable earDeployable) {
        LinkedList<IArchive> libArchives = new LinkedList<IArchive>();
        for (LibDeployable lib : earDeployable.getLibDeployables()) {
            libArchives.add(lib.getArchive());
        }
        return libArchives;
    }

    public ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setDeployerLog(DeployerLog deployerLog) {
        this.deployerLog = deployerLog;
    }

    public Map<URL, EARDeployable> getEars() {
        return this.ears;
    }
}

