/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb2.internal.mbean;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.management.ObjectName;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.management.javaee.J2EEModule;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;

public class EJBModule
extends J2EEModule {
    protected JContainer cont;
    private ArrayList ejbs = new ArrayList();
    String containerName = null;
    String fileName = null;
    private String earON = null;
    private URL earURL = null;
    private boolean inEarCase = false;

    public EJBModule(ObjectName objectName, JContainer cont, String fileName, String containerName, String j2eeAppName, URL earUrl) {
        super(objectName.toString());
        this.cont = cont;
        this.fileName = fileName;
        this.containerName = containerName;
        if (j2eeAppName != null && earUrl != null) {
            ObjectName j2eeAppOn = J2eeObjectName.J2EEApplication(objectName.getDomain(), objectName.getKeyProperty("J2EEServer"), j2eeAppName);
            this.earON = j2eeAppOn.toString();
            this.earURL = earUrl;
            this.inEarCase = true;
        }
    }

    public String[] getEjbs() {
        return this.ejbs.toArray(new String[this.ejbs.size()]);
    }

    public void addEjb(String ejbObjectName) {
        this.ejbs.add(ejbObjectName);
    }

    public int getCurrentNumberOfEJB() {
        return this.ejbs.size();
    }

    public int getCurrentNumberOfBMP() {
        return this.cont.getEntityBMPNb();
    }

    public int getCurrentNumberOfCMP() {
        return this.cont.getEntityCMPNb();
    }

    public int getCurrentNumberOfSBF() {
        return this.cont.getStatefulSessionNb();
    }

    public int getCurrentNumberOfSBL() {
        return this.cont.getStatelessSessionNb();
    }

    public int getCurrentNumberOfMDB() {
        return this.cont.getMessageDrivenNb();
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public URL getUrl() {
        try {
            return new File(this.fileName).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot get URL for fileName '" + this.fileName + "'.", e);
        }
    }

    public String getEarON() {
        return this.earON;
    }

    public URL getEarURL() {
        return this.earURL;
    }

    public boolean isInEarCase() {
        return this.inEarCase;
    }
}

