/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.ddmodifier;

import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.generators.wsgen.ddmodifier.DeploymentDescModifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WsEndpointDDModifier
extends DeploymentDescModifier {
    private static final String SERVLET = "servlet";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String SERVLET_CLASS = "servlet-class";
    private static final String SERVLET_MAPPING = "servlet-mapping";
    private static final String URL_MAPPING = "url-pattern";
    private static final String INIT_PARAM = "init-param";
    private static final String PARAM_NAME = "param-name";
    private static final String PARAM_VALUE = "param-value";
    private static final String SECURITY_ROLE_REF = "security-role-ref";
    private static final String URL_PATTERN = "url-pattern";
    private static final String SECURITY_CONSTRAINT = "security-constraint";
    private static final String LOGIN_CONFIG = "login-config";
    private static final String SECURITY_ROLE = "security-role";
    private static final String ROLE_NAME = "role-name";
    private static final String ANY_TAG_NAME = "*";

    public WsEndpointDDModifier(Document web) {
        super(web.getDocumentElement(), web);
    }

    public void addServlet(String name, String classname) {
        Element servlet = this.newJ2EEElement(SERVLET);
        Element servletName = this.newJ2EEElement(SERVLET_NAME, name);
        Element servletClass = this.newJ2EEElement(SERVLET_CLASS, classname);
        servlet.appendChild(servletName);
        servlet.appendChild(servletClass);
        this.getElement().appendChild(servlet);
    }

    public void addEndpointSecurityConstraint(Node securityConstraint) {
        Element sConstraintElement = this.newJ2EEElement(SECURITY_CONSTRAINT);
        Node newSecurityConstraint = this.getDocument().importNode(securityConstraint, true);
        while (newSecurityConstraint.hasChildNodes()) {
            sConstraintElement.appendChild(newSecurityConstraint.getFirstChild());
        }
        this.getElement().appendChild(sConstraintElement);
    }

    public void addEndpointLoginConfig(Element loginConfig) {
        NodeList configs = this.getElement().getElementsByTagNameNS("http://java.sun.com/xml/ns/j2ee", LOGIN_CONFIG);
        if (configs.getLength() == 0) {
            Element myLoginConfig = this.newJ2EEElement(LOGIN_CONFIG);
            Node importedLoginConfig = this.getDocument().importNode(loginConfig, true);
            while (importedLoginConfig.hasChildNodes()) {
                myLoginConfig.appendChild(importedLoginConfig.getFirstChild());
            }
            this.getElement().appendChild(myLoginConfig);
        } else {
            Element config = (Element)configs.item(0);
            if (!WsEndpointDDModifier.areChildNodesIdentical(config, loginConfig)) {
                String msg = "Cannot insert the new login-config element (login-config cannot be defined twice, even with different values !) : " + loginConfig;
                throw new IllegalStateException(msg);
            }
        }
    }

    private static boolean areChildNodesIdentical(Element first, Element second) {
        boolean identical = true;
        NodeList firstChilds = first.getElementsByTagName(ANY_TAG_NAME);
        NodeList secondChilds = second.getElementsByTagName(ANY_TAG_NAME);
        if (firstChilds.getLength() != secondChilds.getLength()) {
            return false;
        }
        if (firstChilds.getLength() == 0) {
            String one = first.getFirstChild().getNodeValue();
            String two = second.getFirstChild().getNodeValue();
            return one.equals(two);
        }
        boolean childrensIdentical = true;
        for (int index = 0; index < firstChilds.getLength() && childrensIdentical; ++index) {
            Element firstChild = (Element)firstChilds.item(index);
            Element secondChild = (Element)secondChilds.item(index);
            childrensIdentical = WsEndpointDDModifier.areElementIdentical(firstChild, secondChild);
        }
        return identical &= childrensIdentical;
    }

    private static boolean areElementIdentical(Element first, Element second) {
        if (!first.getNamespaceURI().equals(second.getNamespaceURI())) {
            return false;
        }
        if (!first.getLocalName().equals(second.getLocalName())) {
            return false;
        }
        return WsEndpointDDModifier.areChildNodesIdentical(first, second);
    }

    public void addSecurityRole(Node securityRole) {
        Element foundSecurityRole = this.findSecurityRole((Element)securityRole);
        if (foundSecurityRole == null) {
            Element mySecurityRole = this.newJ2EEElement(SECURITY_ROLE);
            Node importedSecurityRole = this.getDocument().importNode(securityRole, true);
            while (importedSecurityRole.hasChildNodes()) {
                mySecurityRole.appendChild(importedSecurityRole.getFirstChild());
            }
            this.getElement().appendChild(mySecurityRole);
        }
    }

    private Element findSecurityRole(Element securityRole) {
        NodeList potentialSecurityRoles = this.getElement().getElementsByTagNameNS("http://java.sun.com/xml/ns/j2ee", SECURITY_ROLE);
        if (potentialSecurityRoles.getLength() == 0) {
            return null;
        }
        Element found = null;
        String requiredRoleName = WsEndpointDDModifier.getRoleName(securityRole);
        for (int index = 0; index < potentialSecurityRoles.getLength() && found == null; ++index) {
            Element potentialSR = (Element)potentialSecurityRoles.item(index);
            String roleName = WsEndpointDDModifier.getRoleName(potentialSR);
            if (!requiredRoleName.equals(roleName)) continue;
            found = potentialSR;
        }
        return found;
    }

    private static String getRoleName(Element securityRole) {
        Node roleName = securityRole.getElementsByTagNameNS("http://java.sun.com/xml/ns/j2ee", ROLE_NAME).item(0);
        return roleName.getFirstChild().getNodeValue().trim();
    }

    public void removeServlet(String name) {
        Element servlet = this.findServlet(name);
        if (servlet != null) {
            this.getElement().removeChild(servlet);
        }
    }

    public NodeList removeServletWithSecurity(String name) {
        Element servlet = this.findServlet(name);
        NodeList elements = null;
        if (servlet != null) {
            elements = servlet.getElementsByTagNameNS("http://java.sun.com/xml/ns/j2ee", SECURITY_ROLE_REF);
            if (elements.getLength() == 0) {
                elements = null;
            }
            this.getElement().removeChild(servlet);
        }
        return elements;
    }

    public void addServletMapping(String name, String mapping) {
        Element servletMapping = this.newJ2EEElement(SERVLET_MAPPING);
        Element servletName = this.newJ2EEElement(SERVLET_NAME, name);
        Element urlMapping = this.newJ2EEElement("url-pattern", mapping);
        servletMapping.appendChild(servletName);
        servletMapping.appendChild(urlMapping);
        this.getElement().appendChild(servletMapping);
    }

    public void addServletParam(String servletName, String pName, String pValue) {
        Element ip = this.newJ2EEElement(INIT_PARAM);
        Element pn = this.newJ2EEElement(PARAM_NAME, pName);
        Element pv = this.newJ2EEElement(PARAM_VALUE, pValue);
        ip.appendChild(pn);
        ip.appendChild(pv);
        Element servlet = this.findServlet(servletName);
        servlet.appendChild(ip);
    }

    public void addServletSecurityRoleRefs(String servletName, NodeList securityRoleRefs) {
        Element servlet = this.findServlet(servletName);
        for (int i = 0; i < securityRoleRefs.getLength(); ++i) {
            Node securityRoleRefItem = securityRoleRefs.item(i);
            servlet.appendChild(securityRoleRefItem);
        }
    }

    private Element findServlet(String name) {
        NodeList nl = this.getElement().getElementsByTagNameNS("http://java.sun.com/xml/ns/j2ee", SERVLET);
        Element servlet = null;
        for (int i = 0; i < nl.getLength() && servlet == null; ++i) {
            Element e = (Element)nl.item(i);
            NodeList names = e.getElementsByTagNameNS("http://java.sun.com/xml/ns/j2ee", SERVLET_NAME);
            if (!names.item(0).getFirstChild().getNodeValue().equals(name)) continue;
            servlet = e;
        }
        return servlet;
    }

    public String removeServletMapping(String sName) {
        NodeList nl = this.getElement().getElementsByTagNameNS("http://java.sun.com/xml/ns/j2ee", SERVLET_MAPPING);
        Element mapping = null;
        String urlPatternValue = null;
        for (int i = 0; i < nl.getLength() && mapping == null; ++i) {
            Element e = (Element)nl.item(i);
            NodeList names = e.getElementsByTagNameNS("http://java.sun.com/xml/ns/j2ee", SERVLET_NAME);
            if (!names.item(0).getFirstChild().getNodeValue().equals(sName)) continue;
            mapping = e;
        }
        if (mapping != null) {
            if (WsEndpointDDModifier.getLogger().isLoggable(BasicLevel.DEBUG)) {
                WsEndpointDDModifier.getLogger().log(BasicLevel.DEBUG, (Object)("mapping element found : " + mapping));
            }
            NodeList urlPatterns = mapping.getElementsByTagNameNS("http://java.sun.com/xml/ns/j2ee", "url-pattern");
            urlPatternValue = urlPatterns.item(0).getFirstChild().getNodeValue();
            this.getElement().removeChild(mapping);
        }
        return urlPatternValue;
    }

    public void updateSecurityConstraint(String oldUrlPatter, String newUrlPatterValue) {
        NodeList nl = this.getElement().getElementsByTagNameNS("http://java.sun.com/xml/ns/j2ee", SECURITY_CONSTRAINT);
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            NodeList urlPatternCollection = e.getElementsByTagNameNS("http://java.sun.com/xml/ns/j2ee", "url-pattern");
            for (int j = 0; j < urlPatternCollection.getLength(); ++j) {
                Element urlPatternElement = (Element)urlPatternCollection.item(j);
                Text urlPatternText = (Text)urlPatternElement.getFirstChild();
                if (!urlPatternText.getNodeValue().equals(oldUrlPatter)) continue;
                urlPatternText.setNodeValue(newUrlPatterValue);
            }
        }
    }

    public void addEjbRef(String name, String home, String remote, String link) {
        Element ejbRef = this.newJ2EEElement("ejb-ref");
        Element ejbRefName = this.newJ2EEElement("ejb-ref-name", name);
        Element ejbRefType = this.newJ2EEElement("ejb-ref-type", "Session");
        Element ejbHome = this.newJ2EEElement("home", home);
        Element ejbRemote = this.newJ2EEElement("remote", remote);
        Element ejbLink = this.newJ2EEElement("ejb-link", link);
        ejbRef.appendChild(ejbRefName);
        ejbRef.appendChild(ejbRefType);
        ejbRef.appendChild(ejbHome);
        ejbRef.appendChild(ejbRemote);
        ejbRef.appendChild(ejbLink);
        this.getElement().appendChild(ejbRef);
    }

    public void addEjbLocalRef(String name, String home, String remote, String link) {
        Element ejbRef = this.newJ2EEElement("ejb-local-ref");
        Element ejbRefName = this.newJ2EEElement("ejb-ref-name", name);
        Element ejbRefType = this.newJ2EEElement("ejb-ref-type", "Session");
        Element ejbHome = this.newJ2EEElement("local-home", home);
        Element ejbRemote = this.newJ2EEElement("local", remote);
        Element ejbLink = this.newJ2EEElement("ejb-link", link);
        ejbRef.appendChild(ejbRefName);
        ejbRef.appendChild(ejbRefType);
        ejbRef.appendChild(ejbHome);
        ejbRef.appendChild(ejbRemote);
        ejbRef.appendChild(ejbLink);
        this.getElement().appendChild(ejbRef);
    }
}

