/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.modifier;

import java.io.File;
import java.util.List;
import java.util.jar.Attributes;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.Version;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.deployment.ws.ServiceRefDesc;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.genbase.modifier.ArchiveModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.ContextDDModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WebJettyDDModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WebServicesDDModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WsClientDDModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WsEndpointDDModifier;
import org.ow2.jonas.generators.wsgen.generator.GeneratorFactory;
import org.ow2.jonas.generators.wsgen.generator.SecurityGenerator;
import org.ow2.jonas.generators.wsgen.generator.WsClientGenerator;
import org.ow2.jonas.generators.wsgen.generator.WsEndpointGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebAppModifier
extends ArchiveModifier {
    private WebApp web;

    public WebAppModifier(WebApp webapp) {
        super(webapp);
        this.web = webapp;
    }

    public Archive modify() throws GenBaseException {
        WebAppModifier.getLogger().log(BasicLevel.INFO, (Object)("Processing WebApp " + this.web.getName()));
        Attributes main = this.web.getManifest().getMainAttributes();
        main.put(new Attributes.Name("WsGen-JOnAS-Version"), Version.getNumber());
        GeneratorFactory gf = GeneratorFactory.getInstance();
        Document jwebapp = this.web.getJonasWebAppDoc();
        Document webapp = this.web.getWebAppDoc();
        Document webservices = this.web.getWebservicesDoc();
        Document jonasWebservices = this.web.getJonasWebservicesDoc();
        List refs = this.web.getServiceRefDescs();
        for (ServiceRefDesc ref : refs) {
            Element base = null;
            if (jwebapp != null) {
                base = jwebapp.getDocumentElement();
            }
            WsClientDDModifier ddm = new WsClientDDModifier(ref.getServiceRefName(), jwebapp, base);
            WsClientGenerator g = gf.newGenerator(ref, ddm, this.web);
            g.generate();
            g.compile();
            g.addFiles(this.web);
            jwebapp = ddm.getDocument();
        }
        WsEndpointDDModifier ddm = new WsEndpointDDModifier(webapp);
        WebServicesDDModifier wsddm = null;
        if (webservices != null) {
            wsddm = new WebServicesDDModifier(webservices);
        }
        List sds = this.web.getServiceDescs();
        for (ServiceDesc sd : sds) {
            WsEndpointGenerator g = gf.newGenerator(sd, ddm, wsddm, this.web);
            g.generate();
            g.compile();
            g.addFiles(this.web);
            Document context = this.web.getContextDoc();
            if (context == null) {
                context = this.web.newContextDoc();
            }
            ContextDDModifier cddm = new ContextDDModifier(context);
            Document webJetty = this.web.getWebJettyDoc();
            if (webJetty == null) {
                webJetty = this.web.newWebJettyDoc();
            }
            WebJettyDDModifier wjddm = new WebJettyDDModifier(webJetty);
            SecurityGenerator sm = new SecurityGenerator(jonasWebservices);
            sm.generate(ddm, cddm, wjddm);
        }
        return this.save(gf.getConfiguration(), "webapps" + File.separator + this.web.getName());
    }
}

