/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.work.WorkManager;
import javax.security.jacc.PolicyContext;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.cmi.CmiService;
import org.ow2.jonas.deployment.api.IEnvEntryDesc;
import org.ow2.jonas.deployment.api.IResourceEnvRefDesc;
import org.ow2.jonas.deployment.api.IResourceRefDesc;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.EjbLocalRefDesc;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.common.MessageDestinationRefDesc;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDescEjb2;
import org.ow2.jonas.deployment.ejb.EntityBmpDesc;
import org.ow2.jonas.deployment.ejb.EntityCmpDesc;
import org.ow2.jonas.deployment.ejb.EntityDesc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp1Desc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp2Desc;
import org.ow2.jonas.deployment.ejb.MessageDrivenDesc;
import org.ow2.jonas.deployment.ejb.SessionStatefulDesc;
import org.ow2.jonas.deployment.ejb.SessionStatelessDesc;
import org.ow2.jonas.ha.HaService;
import org.ow2.jonas.jms.JmsManager;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.ejb21.BeanFactory;
import org.ow2.jonas.lib.ejb21.Container;
import org.ow2.jonas.lib.ejb21.EJBInvocation;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.JMdbEndpointFactory;
import org.ow2.jonas.lib.ejb21.JMdbFactory;
import org.ow2.jonas.lib.ejb21.JStatefulFactory;
import org.ow2.jonas.lib.ejb21.JStatelessFactory;
import org.ow2.jonas.lib.ejb21.PermissionManager;
import org.ow2.jonas.lib.ejb21.PrincipalFactory;
import org.ow2.jonas.lib.ejb21.Swapper;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.ejb21.jorm.RdbFactory;
import org.ow2.jonas.lib.ejb21.jorm.RdbMappingBuilder;
import org.ow2.jonas.lib.naming.URLFactory;
import org.ow2.jonas.lib.security.PermissionManagerException;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JNamingManager;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.tm.TransactionManager;
import org.ow2.jonas.ws.WebServicesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JContainer
implements Container {
    public static final String DEFAULT_FACTORY_CLASS_NAME = "org.ow2.jonas.lib.ejb21.JEntityFactory";
    private static WorkManager workManager = null;
    private HashMap beanList = new HashMap();
    private String earFileName = null;
    private String fileName;
    private String externalFileName;
    private JmsManager jms = null;
    private ClassLoader loader = null;
    private String myname;
    private JNamingManager naming = null;
    private PermissionManager permissionManager = null;
    private PrincipalFactory principalFactory = null;
    private boolean securityFlag = true;
    private Swapper swapper;
    private TransactionManager tm = null;
    private String tmpDirName = null;
    private JComponentContextFactory componentContextFactory = null;
    private static final String DEFAULT_ACTIVATION_SPEC_NAME = "joramActivationSpec";
    private DeploymentDesc ddesc;
    private RdbMappingBuilder jormMapping = null;
    private MBeanServer mbeanServer = null;
    private WebServicesService wsService = null;
    private CmiService cmiService;
    private HaService haService;
    private ResourceService rserv;

    public JContainer(String name, String extFileName, String file, ClassLoader ld, DeploymentDesc dd, CmiService cmiService, HaService haService, WebServicesService webService, MBeanServer jmxserver, ResourceService resService) {
        this.myname = name;
        this.externalFileName = extFileName;
        this.fileName = file;
        this.loader = ld;
        this.ddesc = dd;
        this.swapper = new Swapper(this);
        this.swapper.start();
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("New Container extFN= " + this.externalFileName + " filename=" + this.fileName));
        }
        this.tmpDirName = JProp.getJonasBase() + File.separator + "work" + File.separator + "beans";
        File d = new File(this.tmpDirName);
        d.mkdir();
        this.mbeanServer = jmxserver;
        this.cmiService = cmiService;
        this.wsService = webService;
        this.haService = haService;
        this.rserv = resService;
    }

    public String getTmpDirName() {
        return this.tmpDirName;
    }

    public RdbMappingBuilder getJormMapping() {
        return this.jormMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized BeanFactory addBean(BeanDesc dd) {
        void var2_11;
        String beanName;
        block37: {
            JEntityFactory jEntityFactory;
            block41: {
                String destJName;
                InitialContext ictx;
                Object obj;
                block36: {
                    block40: {
                        block39: {
                            Object var2_2 = null;
                            beanName = dd.getEjbName();
                            if (!(dd instanceof SessionStatefulDesc)) break block39;
                            if (TraceEjb.isDebugIc()) {
                                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("add SessionStatefulBean " + beanName));
                            }
                            JStatefulFactory jStatefulFactory = new JStatefulFactory((SessionStatefulDesc)dd, this);
                            break block37;
                        }
                        if (!(dd instanceof SessionStatelessDesc)) break block40;
                        if (TraceEjb.isDebugIc()) {
                            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("add SessionStatelessBean " + beanName));
                        }
                        JStatelessFactory jStatelessFactory = new JStatelessFactory((SessionStatelessDesc)dd, this);
                        break block37;
                    }
                    if (!(dd instanceof MessageDrivenDesc)) break block41;
                    if (TraceEjb.isDebugIc()) {
                        TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("add MessageDrivenBean " + beanName));
                    }
                    obj = null;
                    ictx = null;
                    destJName = ((MessageDrivenDesc)dd).getDestinationJndiName();
                    try {
                        ictx = this.naming.getInitialContext();
                        obj = this.getActivationSpecFromContext(ictx, destJName);
                    }
                    catch (NamingException ex) {
                        if (!(ex instanceof NameNotFoundException)) {
                            if (!(ex.getCause() instanceof NameNotFoundException)) throw new EJBException(ex);
                        }
                        if (!TraceEjb.isDebugIc()) break block36;
                        TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("Cannot find destination JNDI name " + destJName), (Throwable)ex);
                    }
                }
                if (obj != null && obj instanceof ActivationSpec) {
                    JMdbEndpointFactory jMdbEndpointFactory = new JMdbEndpointFactory((MessageDrivenDesc)dd, this, (ActivationSpec)obj, this.rserv);
                    break block37;
                } else {
                    if (this.getJmsManager() == null) {
                        if (((MessageDrivenDesc)dd).getDestination() != null) {
                            if (!TraceEjb.isDebugIc()) throw new EJBException("JMS service not started and specified ActivationSpec(" + destJName + ") not deployed");
                            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("JMS service not started and specified ActivationSpec(" + destJName + ") not deployed"));
                            throw new EJBException("JMS service not started and specified ActivationSpec(" + destJName + ") not deployed");
                        }
                        String dest = DEFAULT_ACTIVATION_SPEC_NAME;
                        try {
                            obj = this.getActivationSpecFromContext(ictx, dest);
                        }
                        catch (Exception ex) {
                            if (!TraceEjb.isDebugIc()) throw new EJBException("JMS service not started and default ActivationSpec(" + dest + ") not deployed", ex);
                            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("JMS service not started and default ActivationSpec(" + dest + ") not deployed"));
                            throw new EJBException("JMS service not started and default ActivationSpec(" + dest + ") not deployed", ex);
                        }
                        if (obj != null && obj instanceof ActivationSpec) {
                            JMdbEndpointFactory jMdbEndpointFactory = new JMdbEndpointFactory((MessageDrivenDesc)dd, dest, this, (ActivationSpec)obj, this.rserv);
                            break block37;
                        } else {
                            if (!TraceEjb.isDebugIc()) throw new EJBException("Invalid destination: No ActivationSpec deployed matching " + dest);
                            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("Invalid destination: No ActivationSpec deployed matching " + dest));
                            throw new EJBException("Invalid destination: No ActivationSpec deployed matching " + dest);
                        }
                    }
                    if (((MessageDrivenDesc)dd).getDestination() != null) {
                        if (!TraceEjb.isDebugIc()) throw new EJBException("JMS service started and specified ActivationSpec(" + destJName + ") not deployed");
                        TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("JMS service started and specified ActivationSpec(" + destJName + ") not deployed"));
                        throw new EJBException("JMS service started and specified ActivationSpec(" + destJName + ") not deployed");
                    }
                    JMdbFactory jMdbFactory = new JMdbFactory((MessageDrivenDesc)dd, this);
                }
                break block37;
            }
            if (dd instanceof EntityJdbcCmp2Desc) {
                EntityJdbcCmp2Desc ecd = (EntityJdbcCmp2Desc)dd;
                if (TraceEjb.isDebugIc()) {
                    TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("add CMP2 EntityBean " + beanName));
                }
                if (this.jormMapping == null) {
                    try {
                        this.jormMapping = new RdbMappingBuilder((DeploymentDescEjb2)this.ddesc);
                    }
                    catch (DeploymentDescException e) {
                        TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"Cannot build Jorm MetaInfo", (Throwable)e);
                        throw new EJBException(e);
                    }
                }
                String cn = null;
                try {
                    String dsn = ecd.getDatasourceJndiName();
                    InitialContext ictx = this.naming.getInitialContext();
                    String mapperName = null;
                    ClassLoader old = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(this.loader);
                        Object cls = ictx.lookup(dsn);
                        Method meth = cls.getClass().getMethod("getMapperName", null);
                        mapperName = (String)meth.invoke(cls, (Object[])null);
                    }
                    catch (Exception e1) {
                        TraceEjb.interp.log(BasicLevel.WARN, (Object)"Cannot get mapper name from datasource: ", (Throwable)e1);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(old);
                    }
                    if (mapperName == null || mapperName.trim().length() == 0) {
                        try {
                            JProp dsProps = JProp.getInstance("mapper");
                            mapperName = dsProps.getValue(dsn, "");
                        }
                        catch (Exception e2) {
                            throw new EJBException("Unable to retrieve mapperName for " + dsn, e2);
                        }
                        if (mapperName == null) {
                            throw new EJBException("Unable to retrieve mapperName for " + dsn + ". mappername is null.");
                        }
                    }
                    cn = ecd.getFactoryClassName();
                    JEntityFactory jEntityFactory2 = (JEntityFactory)this.loader.loadClass(cn).newInstance();
                    ((RdbFactory)jEntityFactory2).init(ecd, this, mapperName);
                    this.setSwapTime(ecd.getPassivationTimeout());
                    TraceEjb.interp.log(BasicLevel.INFO, (Object)(beanName + " is loaded and using " + mapperName));
                }
                catch (Exception e) {
                    TraceEjb.interp.log(BasicLevel.ERROR, (Object)("Impossible to instanciate the entity factory: " + cn), (Throwable)e);
                    throw new EJBException("Impossible to instanciate the entity factory: " + cn, e);
                }
            }
            if (!(dd instanceof EntityDesc)) throw new EJBException("Bad Descriptor Type for " + beanName);
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("add EntityBean " + beanName));
            }
            String cn = null;
            try {
                cn = DEFAULT_FACTORY_CLASS_NAME;
                jEntityFactory = (JEntityFactory)this.loader.loadClass(cn).newInstance();
            }
            catch (Exception e) {
                throw new EJBException("Impossible to instanciate the specified entity factory: " + cn, e);
            }
            jEntityFactory.init((EntityDesc)dd, this);
            this.setSwapTime(((EntityDesc)dd).getPassivationTimeout());
        }
        this.beanList.put(beanName, var2_11);
        TraceEjb.interp.log(BasicLevel.INFO, (Object)(beanName + " available"));
        try {
            Object[] params = new Object[]{this.fileName};
            String[] signature = new String[]{"java.lang.String"};
            ObjectName areaServiceName = new ObjectName("AreaService", "name", "Service");
            if (!this.mbeanServer.isRegistered(areaServiceName)) return var2_11;
            this.mbeanServer.invoke(areaServiceName, "addPackageInEJBArea", params, signature);
            return var2_11;
        }
        catch (Exception e) {
            TraceEjb.interp.log(BasicLevel.ERROR, (Object)("Area service unreachable : " + e.getMessage()), (Throwable)e);
        }
        return var2_11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getActivationSpecFromContext(InitialContext context, String jndiName) throws NamingException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Object obj = null;
        try {
            Thread.currentThread().setContextClassLoader(this.loader);
            obj = context.lookup(jndiName);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        return obj;
    }

    private Set<Properties> beansDependence(Enumeration<BeanFactory> beanFactories, String rName, boolean isResRef) {
        HashSet<Properties> result = new HashSet<Properties>();
        BeanFactory bf = null;
        while (beanFactories.hasMoreElements()) {
            int i;
            bf = beanFactories.nextElement();
            BeanDesc ejbDesc = bf.getDeploymentDescriptor();
            boolean isDependent = false;
            String ejbType = null;
            if (bf instanceof JEntityFactory) {
                if (ejbDesc instanceof EntityBmpDesc) {
                    ejbType = "ejbbmp";
                }
                if (ejbDesc instanceof EntityCmpDesc) {
                    ejbType = "ejbcmp";
                }
            } else if (bf instanceof JStatefulFactory) {
                ejbType = "ejbsbf";
            } else if (bf instanceof JStatelessFactory) {
                ejbType = "ejbsbl";
            } else if (bf instanceof JMdbFactory || bf instanceof JMdbEndpointFactory) {
                ejbType = "ejbmdb";
            }
            if (isResRef) {
                if (ejbType.equals("ejbcmp")) {
                    String jndiName = null;
                    if (ejbDesc instanceof EntityJdbcCmp1Desc) {
                        jndiName = ((EntityJdbcCmp1Desc)ejbDesc).getDatasourceJndiName();
                    } else if (ejbDesc instanceof EntityJdbcCmp2Desc) {
                        jndiName = ((EntityJdbcCmp2Desc)ejbDesc).getDatasourceJndiName();
                    }
                    isDependent = rName.equals(jndiName);
                }
                IResourceRefDesc[] rrDesc = ejbDesc.getResourceRefDesc();
                for (i = 0; i < rrDesc.length; ++i) {
                    if (!rrDesc[i].getJndiName().equals(rName)) continue;
                    isDependent = true;
                    break;
                }
            } else {
                if (ejbType.equals("ejbmdb") && rName.equals(((MessageDrivenDesc)ejbDesc).getDestinationJndiName())) {
                    isDependent = true;
                }
                IResourceEnvRefDesc[] rerDesc = ejbDesc.getResourceEnvRefDesc();
                for (i = 0; i < rerDesc.length; ++i) {
                    if (!rerDesc[i].getJndiName().equals(rName)) continue;
                    isDependent = true;
                    break;
                }
            }
            if (!isDependent) continue;
            Properties toAdd = new Properties();
            toAdd.setProperty("type", ejbType);
            toAdd.setProperty("fname", this.getFileName());
            toAdd.setProperty("name", ejbDesc.getEjbName());
            toAdd.setProperty("cname", this.getName());
            String earFileName = this.getEarFileName();
            if (earFileName != null) {
                toAdd.setProperty("earFileName", earFileName);
            }
            result.add(toAdd);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSecurity(String ejbName, EJBInvocation ejbInv, boolean inRunAs) {
        String oldContextId = PolicyContext.getContextID();
        boolean accessIsOk = false;
        try {
            if (this.permissionManager != null) {
                accessIsOk = this.permissionManager.checkSecurity(ejbName, ejbInv, inRunAs);
            }
        }
        catch (Exception e) {
            TraceEjb.security.log(BasicLevel.ERROR, (Object)"Error while checking security", (Throwable)e);
        }
        finally {
            PolicyContext.setContextID(oldContextId);
        }
        if (!accessIsOk) {
            StringBuffer errMsg = new StringBuffer("Access Denied on bean '");
            errMsg.append(ejbName);
            errMsg.append("' with run-as = '");
            errMsg.append(inRunAs);
            errMsg.append("'. ");
            if (ejbInv != null && ejbInv.methodPermissionSignature != null) {
                errMsg.append(" Method signature = '");
                errMsg.append(ejbInv.methodPermissionSignature);
                errMsg.append("'.");
            }
            throw new AccessLocalException(errMsg.toString());
        }
    }

    @Override
    public BeanFactory getBeanFactory(String ejbName) {
        return (BeanFactory)this.beanList.get(ejbName);
    }

    public int getBeanNb() {
        return this.beanList.size();
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.loader == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"container has been removed");
            return null;
        }
        return this.loader;
    }

    @Override
    public JNamingManager getContainerNaming() {
        return this.naming;
    }

    public Set<Properties> getDataSourceDependence(String dsName) {
        return this.beansDependence(Collections.enumeration(this.beanList.values()), dsName, true);
    }

    @Override
    public String getEarFileName() {
        return this.earFileName;
    }

    public int getEntityBMPNb() {
        int total = 0;
        for (BeanFactory bf : this.beanList.values()) {
            if (!(bf.getDeploymentDescriptor() instanceof EntityBmpDesc)) continue;
            ++total;
        }
        return total;
    }

    public int getEntityCMPNb() {
        int total = 0;
        for (BeanFactory bf : this.beanList.values()) {
            if (!(bf.getDeploymentDescriptor() instanceof EntityCmpDesc)) continue;
            ++total;
        }
        return total;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getExternalFileName() {
        return this.externalFileName;
    }

    public Set<Properties> getJmsConnectionFactoryDependence(String cfName) {
        return this.beansDependence(Collections.enumeration(this.beanList.values()), cfName, true);
    }

    public Set<Properties> getJmsDestinationDependence(String destName) {
        return this.beansDependence(Collections.enumeration(this.beanList.values()), destName, false);
    }

    @Override
    public JmsManager getJmsManager() {
        return this.jms;
    }

    public Set<Properties> getMailFactoryDependence(String mfName) {
        return this.beansDependence(Collections.enumeration(this.beanList.values()), mfName, true);
    }

    public int getMessageDrivenNb() {
        int total = 0;
        for (BeanFactory bf : this.beanList.values()) {
            if (!(bf.getDeploymentDescriptor() instanceof MessageDrivenDesc)) continue;
            ++total;
        }
        return total;
    }

    @Override
    public String getName() {
        return this.myname;
    }

    @Override
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Override
    public PrincipalFactory getPrincipalFactory() {
        return this.principalFactory;
    }

    public int getStatefulSessionNb() {
        int total = 0;
        for (BeanFactory bf : this.beanList.values()) {
            if (!(bf.getDeploymentDescriptor() instanceof SessionStatefulDesc)) continue;
            ++total;
        }
        return total;
    }

    public int getStatelessSessionNb() {
        int total = 0;
        for (BeanFactory bf : this.beanList.values()) {
            if (!(bf.getDeploymentDescriptor() instanceof SessionStatelessDesc)) continue;
            ++total;
        }
        return total;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public boolean isInEarCase() {
        return this.earFileName != null;
    }

    @Override
    public String[] listBeanNames() {
        return this.beanList.keySet().toArray(new String[0]);
    }

    public void registerBF(BeanFactory bf) {
        this.swapper.addBeanFactory(bf);
    }

    public void registerBFS(BeanFactory bf) {
        this.swapper.addBeanFactorySync(bf);
    }

    @Override
    public synchronized void remove() {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.myname);
        }
        this.swapper.stopIt();
        this.syncAll(true, false);
        for (BeanFactory bf : this.beanList.values()) {
            try {
                bf.stop();
                TraceEjb.interp.log(BasicLevel.INFO, (Object)(this.myname + ": " + bf.getEJBName() + " no longer available"));
                Object[] params = new Object[]{this.fileName};
                String[] signature = new String[]{"java.lang.String"};
                ObjectName areaServiceName = new ObjectName("AreaService", "name", "Service");
                try {
                    if (!this.mbeanServer.isRegistered(areaServiceName)) continue;
                    this.mbeanServer.invoke(areaServiceName, "removePackageFromEJBArea", params, signature);
                }
                catch (Exception exc) {
                    TraceEjb.interp.log(BasicLevel.ERROR, (Object)("Area service unreachable : " + exc.getMessage()), (Throwable)exc);
                }
            }
            catch (Exception e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)this.myname, (Throwable)e);
            }
        }
        this.beanList.clear();
        this.loader = null;
        try {
            if (this.permissionManager != null) {
                this.permissionManager.delete();
            }
        }
        catch (PermissionManagerException pme) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)this.myname, (Throwable)pme);
        }
        this.permissionManager = null;
        Runtime.getRuntime().gc();
    }

    public void setBeanEnvironment(Context ctx, BeanDesc dd) throws NamingException {
        LinkRef lref;
        Context ctxold = this.naming.setComponentContext(ctx);
        Context envCtx = ctx.createSubcontext("comp/env");
        IEnvEntryDesc[] envt = dd.getEnvEntryDesc();
        for (int i = 0; i < envt.length; ++i) {
            String name = envt[i].getName();
            Object obj = envt[i].getValue();
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)(this.myname + ": Binding object " + name + " -> " + obj));
            }
            envCtx.rebind(name, obj);
        }
        IResourceRefDesc[] resref = dd.getResourceRefDesc();
        for (int i = 0; i < resref.length; ++i) {
            String name = resref[i].getName();
            String resname = resref[i].getJndiName();
            String type = resref[i].getTypeName();
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)(this.myname + ": Linking resource " + name + " -> " + resname));
            }
            if (type.equalsIgnoreCase("java.net.URL")) {
                Reference ref = new Reference("java.net.URL", URLFactory.class.getName(), null);
                StringRefAddr refAddr = new StringRefAddr("url", resname);
                ref.add(refAddr);
                envCtx.rebind(name, (Object)ref);
                continue;
            }
            lref = new LinkRef(resname);
            envCtx.rebind(name, (Object)lref);
        }
        IResourceEnvRefDesc[] resEnvref = dd.getResourceEnvRefDesc();
        for (int i = 0; i < resEnvref.length; ++i) {
            String name = resEnvref[i].getName();
            String resname = resEnvref[i].getJndiName();
            lref = new LinkRef(resname);
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)(this.myname + ": Linking resource environment " + name + " -> " + resname));
            }
            envCtx.rebind(name, (Object)lref);
        }
        EjbRefDesc[] ejbref = dd.getEjbRefDesc();
        for (int i = 0; i < ejbref.length; ++i) {
            String name = ejbref[i].getEjbRefName();
            String ejbname = null;
            ejbname = ejbref[i].getJndiName();
            LinkRef lref2 = new LinkRef(ejbname);
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)(this.myname + ": Linking ejb " + name + " -> " + ejbname));
            }
            envCtx.rebind(name, (Object)lref2);
        }
        EjbLocalRefDesc[] ejblocalref = dd.getEjbLocalRefDesc();
        for (int i = 0; i < ejblocalref.length; ++i) {
            String name = ejblocalref[i].getEjbRefName();
            String ejbname = ejblocalref[i].getJndiLocalName();
            LinkRef lref3 = new LinkRef(ejbname);
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)(this.myname + ": Linking ejb " + name + " -> " + ejbname));
            }
            envCtx.rebind(name, (Object)lref3);
        }
        IServiceRefDesc[] serviceRefs = dd.getServiceRefDesc();
        for (int i = 0; i < serviceRefs.length; ++i) {
            if (this.wsService == null) {
                TraceEjb.logger.log(BasicLevel.WARN, (Object)"WebServices service not started yet");
                break;
            }
            IServiceRefDesc srefdesc = serviceRefs[i];
            Reference ref = this.wsService.buildServiceRef(srefdesc, this.loader);
            String refname = srefdesc.getServiceRefName();
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("Adding service-ref 'java:comp/env/" + refname + "'"));
            }
            envCtx.rebind(refname, (Object)ref);
        }
        MessageDestinationRefDesc[] mdref = dd.getMessageDestinationRefDesc();
        for (int i = 0; i < mdref.length; ++i) {
            String name = mdref[i].getMessageDestinationRefName();
            String mdname = null;
            mdname = mdref[i].getJndiName();
            LinkRef lref4 = new LinkRef(mdname);
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)(this.myname + ": Linking message-destination " + name + " -> " + mdname));
            }
            envCtx.rebind(name, (Object)lref4);
        }
        this.naming.setComponentContext(ctxold);
    }

    @Override
    public void setContainerNaming(JNamingManager naming) {
        this.naming = naming;
    }

    @Override
    public void setEarFileName(String fileName) {
        this.earFileName = fileName;
    }

    @Override
    public void setJmsManager(JmsManager jms) {
        this.jms = jms;
    }

    @Override
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public void setPrincipalFactory(PrincipalFactory pf) {
        this.principalFactory = pf;
    }

    @Override
    public void setSecurity(boolean b) {
        this.securityFlag = b;
    }

    public void setSwapTime(int t) {
        if (t > 0) {
            if (TraceEjb.isDebugSwapper()) {
                TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)(this.myname + " sec=" + t));
            }
            this.swapper.setSwapperTimeout(t);
        }
    }

    public void setWorkManager(WorkManager wm) {
        workManager = wm;
    }

    public WorkManager getWorkManager() {
        return workManager;
    }

    @Override
    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    @Override
    public synchronized void syncAll(boolean store, boolean passivate) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.myname);
        }
        BeanFactory bf2 = null;
        for (BeanFactory bf2 : this.beanList.values()) {
            if (passivate) {
                bf2.reduceCache();
                continue;
            }
            bf2.syncDirty(store);
        }
    }

    @Override
    public String getContextId() {
        return this.externalFileName;
    }

    public synchronized void storeAll(Transaction tx) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.myname);
        }
        BeanFactory bf2 = null;
        for (BeanFactory bf2 : this.beanList.values()) {
            bf2.storeInstances(tx);
        }
    }

    @Override
    public JComponentContextFactory getComponentContextFactory() {
        return this.componentContextFactory;
    }

    @Override
    public void setComponentContextFactory(JComponentContextFactory factory) {
        this.componentContextFactory = factory;
    }

    public HaService getHaService() {
        return this.haService;
    }

    public CmiService getCmiService() {
        return this.cmiService;
    }
}

