/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.ejb.EJBException;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.ejb.SessionDesc;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.JFactory;
import org.ow2.jonas.lib.ejb21.JHome;
import org.ow2.jonas.lib.ejb21.JLocalHome;
import org.ow2.jonas.lib.ejb21.JSessionContext;
import org.ow2.jonas.lib.ejb21.JSessionHome;
import org.ow2.jonas.lib.ejb21.JSessionLocalHome;
import org.ow2.jonas.lib.ejb21.JSessionRemote;
import org.ow2.jonas.lib.ejb21.JSessionSwitch;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;

public abstract class JSessionFactory
extends JFactory {
    int timeout = 0;
    protected JSessionHome home = null;
    protected JSessionLocalHome localhome = null;
    protected boolean isSynchro = false;
    protected boolean isStateful;
    protected ArrayList sessionList = new ArrayList();
    protected JSessionSwitch uniqueSession = null;
    protected boolean singleswitch;

    public JSessionFactory(SessionDesc dd, JContainer cont) {
        super(dd, cont);
        Object[] pobj;
        Class[] ptype;
        int nbp;
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.txbeanmanaged = dd.isBeanManagedTransaction();
        this.timeout = dd.getSessionTimeout();
        Class<?> homeclass = null;
        String clname = dd.getFullWrpHomeName();
        if (clname != null) {
            try {
                homeclass = cont.getClassLoader().loadClass(clname);
            }
            catch (ClassNotFoundException e) {
                throw new EJBException(this.ejbname + " Cannot load " + clname, e);
            }
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)(this.ejbname + ": " + clname + " loaded"));
            }
            try {
                nbp = 2;
                ptype = new Class[nbp];
                pobj = new Object[nbp];
                ptype[0] = SessionDesc.class;
                pobj[0] = dd;
                ptype[1] = JSessionFactory.class;
                pobj[1] = this;
                this.home = (JSessionHome)homeclass.getConstructor(ptype).newInstance(pobj);
            }
            catch (Exception e) {
                throw new EJBException(this.ejbname + " Cannot create home ", e);
            }
            try {
                this.home.register();
            }
            catch (Exception e) {
                throw new EJBException(this.ejbname + " Cannot register home ", e);
            }
        }
        if ((clname = dd.getFullWrpLocalHomeName()) != null) {
            try {
                homeclass = cont.getClassLoader().loadClass(clname);
            }
            catch (ClassNotFoundException e) {
                throw new EJBException(this.ejbname + " Cannot load " + clname, e);
            }
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)(this.ejbname + ": " + clname + " loaded"));
            }
            try {
                nbp = 2;
                ptype = new Class[nbp];
                pobj = new Object[nbp];
                ptype[0] = SessionDesc.class;
                pobj[0] = dd;
                ptype[1] = JSessionFactory.class;
                pobj[1] = this;
                this.localhome = (JSessionLocalHome)homeclass.getConstructor(ptype).newInstance(pobj);
            }
            catch (Exception e) {
                throw new EJBException(this.ejbname + " Cannot create localhome ", e);
            }
            try {
                this.localhome.register();
            }
            catch (Exception e) {
                throw new EJBException(this.ejbname + " Cannot register localhome ", e);
            }
        }
    }

    public boolean singleSwitchOn() {
        return this.singleswitch;
    }

    public void stop() {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            if (this.home != null) {
                this.home.unregister();
            }
            if (this.localhome != null) {
                this.localhome.unregister();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (this.singleswitch) {
            this.uniqueSession.noLongerUsed();
        }
        this.stopContainer();
    }

    public void syncDirty(boolean notused) {
    }

    public JHome getHome() {
        return this.home;
    }

    public JLocalHome getLocalHome() {
        return this.localhome;
    }

    public synchronized JSessionSwitch createEJB() throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.singleswitch) {
            if (this.uniqueSession == null) {
                this.uniqueSession = this.createNewSession();
            }
            return this.uniqueSession;
        }
        JSessionSwitch bs = null;
        if (this.sessionList.size() > 0) {
            bs = (JSessionSwitch)this.sessionList.remove(0);
            JSessionRemote remote = bs.getRemote();
            if (remote != null && !remote.exportObject()) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"bad JSessionSwitch found in pool.");
                return null;
            }
        } else {
            bs = this.createNewSession();
        }
        if (this.timeout > 0) {
            bs.startTimer(this.timeout * 1000);
        }
        return bs;
    }

    public synchronized void removeEJB(JSessionSwitch bs) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.singleswitch) {
            this.uniqueSession = null;
        } else {
            this.sessionList.add(bs);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkTransaction(RequestCtx rctx) {
        if (this.txbeanmanaged) {
            try {
                rctx.clientTx = this.tm.suspend();
                if (!TraceEjb.isDebugTx()) return;
                TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("suspending tx:" + rctx.clientTx));
                return;
            }
            catch (SystemException e) {
                throw new EJBException("cannot suspend transaction", e);
            }
        } else {
            this.checkTransactionContainer(rctx);
        }
    }

    public boolean isSessionSynchro() {
        return this.isSynchro;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int t) {
        if (TraceEjb.isDebugTx()) {
            TraceEjb.tx.log(BasicLevel.DEBUG, (Object)"");
        }
        this.timeout = t;
    }

    public boolean isStateful() {
        return this.isStateful;
    }

    public abstract JSessionContext getJContext(JSessionSwitch var1);

    protected abstract JSessionSwitch createNewSession() throws RemoteException;
}

