/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.ha;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Stack;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.cmi.controller.common.AbsClusterViewManager;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.ha.RequestId;
import org.ow2.cmi.ha.interceptor.HACurrent;
import org.ow2.jonas.lib.ejb21.JEntityContext;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.JEntityRemote;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.ha.JRepUtil;
import org.ow2.jonas.lib.util.Log;

public abstract class JRepEntityRemote
extends JEntityRemote
implements Remote {
    protected static Logger cmilogger = Log.getLogger("org.ow2.jonas.lib.ejb21.ha");

    public JRepEntityRemote(JEntityFactory bf) throws RemoteException {
        super(bf);
        cmilogger.log(BasicLevel.DEBUG, (Object)"");
    }

    public RequestCtx preInvoke(int txa) throws RemoteException {
        RequestCtx rctx = super.preInvoke(txa);
        this.preInvokeHook(rctx);
        return rctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(RequestCtx rctx, JEntityContext bctx, Object response) throws RemoteException {
        try {
            this.postInvokeHook(bctx, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            cmilogger.log(BasicLevel.ERROR, (Object)"Error calling postInvokeHook in sfsb.", (Throwable)e);
        }
        finally {
            super.postInvoke(rctx);
            JRepUtil.removeCurrentRequest();
        }
    }

    protected boolean hasResponse() {
        HACurrent current = HACurrent.getHACurrent();
        Stack<RequestId> requests = current.getRequests();
        if (requests != null && !requests.isEmpty()) {
            RequestId reqId = requests.peek();
            if (reqId != null) {
                try {
                    return JRepUtil.hasBackupResponse(reqId);
                }
                catch (Exception e) {
                    cmilogger.log(BasicLevel.ERROR, (Object)("Cannot check response : " + reqId), (Throwable)e);
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    protected Object getResponse() {
        Object response = null;
        HACurrent current = HACurrent.getHACurrent();
        Stack<RequestId> requests = current.getRequests();
        if (requests != null && !requests.isEmpty()) {
            RequestId reqId = requests.peek();
            if (reqId != null) {
                try {
                    response = JRepUtil.getRepMgr().getBackupResponse(reqId);
                }
                catch (Exception e) {
                    cmilogger.log(BasicLevel.ERROR, (Object)("Cannot obtain response : " + reqId), (Throwable)e);
                    response = null;
                }
            } else {
                response = null;
            }
            requests.pop();
        }
        return response;
    }

    private void preInvokeHook(RequestCtx rctx) throws RemoteException {
        RequestId reqId;
        HACurrent current;
        Stack<RequestId> requests;
        ClusterViewManager clusterViewManager = AbsClusterViewManager.getClusterViewManager();
        if (clusterViewManager != null && (requests = (current = HACurrent.getHACurrent()).getRequests()) != null && !requests.isEmpty() && !(reqId = requests.peek()).getObjectId().getClientId().equals(clusterViewManager.getUUID())) {
            requests.clear();
            requests.push(reqId);
        }
    }

    private void postInvokeHook(JEntityContext bctx, Object response) {
        HACurrent current = HACurrent.getHACurrent();
        Stack<RequestId> requests = current.getRequests();
        if (requests != null && !requests.isEmpty()) {
            RequestId rootId = (RequestId)requests.get(0);
            if (requests.size() == 1) {
                try {
                    JRepUtil.getRepMgr().addResponse(rootId, response);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    cmilogger.log(BasicLevel.ERROR, (Object)"unable to obtain replication manager.", (Throwable)e);
                }
            }
        }
    }
}

