/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.ha.interceptors.iiop;

import java.io.IOException;
import java.util.Stack;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.ow2.cmi.ha.RequestId;
import org.ow2.cmi.ha.interceptor.HAContext;
import org.ow2.cmi.ha.interceptor.HACurrent;
import org.ow2.jonas.lib.ejb21.ha.interceptors.iiop.HAInterceptor;
import org.ow2.jonas.lib.util.Log;

public class HAClientInterceptor
extends HAInterceptor
implements ClientRequestInterceptor {
    private static final long serialVersionUID = 7391445843768730939L;
    private String interceptorName = "HAClientInterceptor";
    private static Logger logger = Log.getLogger("org.ow2.jonas.lib.ejb21.ha.interceptors.iiop");

    public String name() {
        return this.interceptorName;
    }

    public void send_request(ClientRequestInfo jri) throws ForwardRequest {
        logger.log(BasicLevel.DEBUG, (Object)"");
        HACurrent current = HACurrent.getHACurrent();
        HAContext newHACtx = new HAContext();
        Stack<RequestId> requests = current.getRequests();
        newHACtx.setRequests(requests);
        newHACtx.setOnFailover(current.isOnFailover());
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Propagating requests chain: " + newHACtx));
        }
        try {
            ServiceContext serviceContext = new ServiceContext(HA_CTX_ID, this.marshallHAContext(newHACtx));
            jri.add_request_service_context(serviceContext, true);
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)("Error while marshalling " + newHACtx), (Throwable)e);
        }
    }

    public void receive_reply(ClientRequestInfo jri) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.getHAContext(jri);
    }

    public void receive_exception(ClientRequestInfo jri) throws ForwardRequest {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.getHAContext(jri);
    }

    public void receive_other(ClientRequestInfo jri) throws ForwardRequest {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.getHAContext(jri);
    }

    public void destroy() {
    }

    public void send_poll(ClientRequestInfo jri) {
    }

    private void getHAContext(ClientRequestInfo clientRequestInfo) {
        try {
            ServiceContext serviceContext = clientRequestInfo.get_request_service_context(HA_CTX_ID);
            HAContext receivedCtx = this.unmarshallHAContext(serviceContext.context_data);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("receivedCtx: " + receivedCtx));
            }
            HACurrent current = HACurrent.getHACurrent();
            Stack<RequestId> requests = receivedCtx.getRequests();
            current.setRequests(requests);
        }
        catch (BAD_PARAM e) {
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)"Error while unmarshalling", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)"Error while unmarshalling", (Throwable)e);
        }
    }
}

