/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.ha.interceptors.iiop;

import java.io.IOException;
import java.util.Stack;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.ow2.cmi.ha.RequestId;
import org.ow2.cmi.ha.interceptor.HAContext;
import org.ow2.cmi.ha.interceptor.HACurrent;
import org.ow2.jonas.lib.ejb21.ha.interceptors.iiop.HAInterceptor;
import org.ow2.jonas.lib.ejb21.ha.interceptors.jrmp.HAServiceContext;
import org.ow2.jonas.lib.util.Log;

public class HAServerInterceptor
extends HAInterceptor
implements ServerRequestInterceptor {
    private static final long serialVersionUID = 686400419582706917L;
    private String interceptorName = "HAServerInterceptor";
    private static Logger logger = Log.getLogger("org.ow2.jonas.lib.ejb21.ha.interceptors.iiop");
    private HAContext receivedCtx;

    public String name() {
        return this.interceptorName;
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            ServiceContext serviceContext = ri.get_request_service_context(HAServiceContext.HA_CTX_ID);
            this.receivedCtx = this.unmarshallHAContext(serviceContext.context_data);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)this.receivedCtx.toString());
            }
        }
        catch (BAD_PARAM e) {
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)"Error while unmarshalling", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)"Error while unmarshalling", (Throwable)e);
        }
    }

    public void receive_request(ServerRequestInfo jri) throws ForwardRequest {
        if (this.receivedCtx != null) {
            HACurrent current = HACurrent.getHACurrent();
            Stack<RequestId> requests = this.receivedCtx.getRequests();
            current.setRequests(requests);
            boolean onFailover = this.receivedCtx.isOnFailover();
            current.setOnFailover(onFailover);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"HACtx associated to Thread");
            }
        }
    }

    public void send_reply(ServerRequestInfo jri) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.putHAContext(jri);
    }

    public void destroy() {
    }

    public void send_exception(ServerRequestInfo jri) throws ForwardRequest {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.putHAContext(jri);
    }

    public void send_other(ServerRequestInfo jri) throws ForwardRequest {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.putHAContext(jri);
    }

    private void putHAContext(ServerRequestInfo serverRequestInfo) {
        HACurrent current = HACurrent.getHACurrent();
        HAContext haContext = new HAContext();
        Stack<RequestId> requests = current.getRequests();
        haContext.setRequests(requests);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("newHACtx: " + haContext));
        }
        try {
            ServiceContext serviceContext = new ServiceContext(HA_CTX_ID, this.marshallHAContext(haContext));
            serverRequestInfo.add_reply_service_context(serviceContext, true);
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)("Error while marshalling " + haContext), (Throwable)e);
        }
    }
}

