/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.domain.DomainMap;
import org.ow2.jonas.deployment.domain.DomainMapException;
import org.ow2.jonas.deployment.domain.lib.DomainMapManager;
import org.ow2.jonas.deployment.domain.xml.Cluster;
import org.ow2.jonas.deployment.domain.xml.ClusterDaemon;
import org.ow2.jonas.deployment.domain.xml.Location;
import org.ow2.jonas.deployment.domain.xml.Server;
import org.ow2.jonas.discovery.DiscoveryEvent;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.management.domain.AuthenticationInformation;
import org.ow2.jonas.lib.management.domain.DeployAction;
import org.ow2.jonas.lib.management.domain.cluster.BaseCluster;
import org.ow2.jonas.lib.management.domain.cluster.ClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.cmi.CmiClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.ha.EjbHaClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.jk.JkClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.logical.LogicalCluster;
import org.ow2.jonas.lib.management.domain.cluster.logical.LogicalClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.tomcat.TomcatClusterFactory;
import org.ow2.jonas.lib.management.domain.proxy.clusterd.ClusterDaemonProxy;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;
import org.ow2.jonas.lib.management.javaee.J2EEState;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainMonitor {
    private static Logger logger = Log.getLogger("org.ow2.jonas.management.domain");
    private ArrayList<ClusterFactory> clusterFactoryList = new ArrayList(5);
    private HashMap<String, ClusterDaemonProxy> clusterDaemons = new HashMap();
    private HashMap<String, AuthenticationInformation> authInfo = new HashMap();
    private AuthenticationInformation defaultAuthInfo;
    private JmxService jmx = null;
    private StateMonitor stateMonitor = null;
    private String domainName;
    private String jonasServerName;
    private String masterName;
    private String description;
    private ArrayList<DeployAction> deployList = new ArrayList();
    private HashMap<String, ArrayList<String>> removedServerByClusterd = new HashMap();
    private LogicalClusterFactory lclFactory = null;
    private boolean ismaster = false;
    private static DomainMonitor unique;

    public DomainMonitor(String domain, String serverName) {
        this.domainName = domain;
        unique = this;
        this.jonasServerName = serverName;
    }

    public static DomainMonitor getInstance() {
        return unique;
    }

    public void setMaster() {
        this.ismaster = true;
        this.lclFactory = new LogicalClusterFactory(this);
        this.clusterFactoryList.add(this.lclFactory);
        this.clusterFactoryList.add(new JkClusterFactory(this));
        this.clusterFactoryList.add(new TomcatClusterFactory(this));
        this.clusterFactoryList.add(new CmiClusterFactory(this));
        this.clusterFactoryList.add(new EjbHaClusterFactory(this));
        ArrayList<String> theUrls = new ArrayList<String>();
        JMXServiceURL[] urls = this.jmx.getConnectorServerURLs();
        for (int i = 0; i < urls.length; ++i) {
            theUrls.add(urls[i].toString());
        }
        ServerProxy sp = new ServerProxy(this, this.jonasServerName, theUrls, null);
        ObjectName on = null;
        try {
            on = JonasObjectName.serverProxy(this.domainName, this.jonasServerName);
            sp.setObjectName(on.toString());
        }
        catch (MalformedObjectNameException e) {
            logger.log(BasicLevel.ERROR, (Object)("MalformedObjectName: " + this.jonasServerName));
        }
        MBeanServerConnection connection = this.getConnection(this.jonasServerName);
        sp.setConnection(connection);
        this.lclFactory.notifyServer(sp);
        sp.getMonitoringInfo();
        this.notifyServerProxyRunning(sp);
        this.readDomainConfig();
    }

    public boolean isMaster() {
        return this.ismaster;
    }

    public void readDomainConfig() {
        block2: {
            try {
                this.createDomainMap();
            }
            catch (Exception e) {
                logger.log(BasicLevel.INFO, (Object)"Cannot read domain.xml");
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block2;
                logger.log(BasicLevel.DEBUG, (Object)("Exception raised:" + e));
            }
        }
        this.stateMonitor = new StateMonitor(this);
        this.stateMonitor.start();
        logger.log(BasicLevel.DEBUG, (Object)"State monitor created");
    }

    public String getDescription() {
        return this.description;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setMonitoringPeriod(int sec) {
        this.stateMonitor.setSamplingPeriod(sec);
    }

    public int getMonitoringPeriod() {
        return this.stateMonitor.getSamplingPeriod();
    }

    private void createDomainMap() throws DomainMapException, JMException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        DomainMap domainMap = null;
        try {
            domainMap = DomainMapManager.getDomainMap(null, currentLoader);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Domain Map :" + domainMap));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String definedName = domainMap.getName();
        if (!this.domainName.equals(definedName)) {
            logger.log(BasicLevel.INFO, (Object)("Domain name in domain.xml is not the actual domain name: " + this.domainName));
            return;
        }
        this.description = domainMap.getDescription();
        String username = domainMap.getUsername();
        String password = domainMap.getPassword();
        if (username != null && password != null) {
            try {
                this.defaultAuthInfo = new AuthenticationInformation(username, password);
            }
            catch (UnsupportedEncodingException e) {
                logger.log(BasicLevel.ERROR, (Object)e);
            }
        } else {
            this.defaultAuthInfo = null;
        }
        Vector daemons = domainMap.getClusterDaemons();
        for (int i = 0; i < daemons.size(); ++i) {
            ClusterDaemon cd = (ClusterDaemon)daemons.elementAt(i);
            String cdname = cd.getName();
            username = cd.getUsername();
            password = cd.getPassword();
            if (username != null && password != null) {
                try {
                    this.authInfo.put(cdname, new AuthenticationInformation(username, password));
                }
                catch (UnsupportedEncodingException e) {
                    logger.log(BasicLevel.ERROR, (Object)e);
                }
            }
            Location loc = cd.getLocation();
            ClusterDaemonProxy cdp = new ClusterDaemonProxy(this, cdname, loc.getUrlList());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Adding clusterdaemon : " + cdname));
            }
            ObjectName on = JonasObjectName.clusterDaemonProxy(this.domainName, cdname);
            cdp.setObjectName(on.toString());
            this.clusterDaemons.put(cdname, cdp);
        }
        Vector servers = domainMap.getServers();
        for (int i = 0; i < servers.size(); ++i) {
            Server sv = (Server)servers.elementAt(i);
            String svname = sv.getName();
            String cdn = sv.getClusterDaemon();
            ClusterDaemonProxy cdp = null;
            if (cdn != null && (cdp = this.clusterDaemons.get(cdn)) == null) {
                logger.log(BasicLevel.WARN, (Object)("Undeclared ClusterDaemon :" + cdn));
            }
            username = sv.getUsername();
            password = sv.getPassword();
            if (username != null && password != null) {
                try {
                    this.authInfo.put(svname, new AuthenticationInformation(username, password));
                }
                catch (UnsupportedEncodingException e) {
                    logger.log(BasicLevel.ERROR, (Object)e);
                }
            }
            Location loc = sv.getLocation();
            ServerProxy sp = this.findServerProxy(svname);
            if (sp == null) {
                sp = new ServerProxy(this, svname, loc.getUrlList(), cdp);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Adding server : " + svname));
                }
                ObjectName on = JonasObjectName.serverProxy(this.domainName, svname);
                sp.setObjectName(on.toString());
                this.lclFactory.notifyServer(sp);
                continue;
            }
            logger.log(BasicLevel.WARN, (Object)("Server already declared: " + svname));
        }
        Vector clusters = domainMap.getClusters();
        for (int i = 0; i < clusters.size(); ++i) {
            Cluster cl = (Cluster)clusters.elementAt(i);
            String clname = cl.getName();
            LogicalCluster locl = (LogicalCluster)this.lclFactory.getCluster(clname);
            if (locl == null) {
                locl = this.createLogicalCluster(clname);
            }
            if (locl == null) continue;
            JLinkedList serverList = cl.getServerList();
            for (int j = 0; j < serverList.size(); ++j) {
                Server sv = (Server)serverList.get(j);
                String svname = sv.getName();
                ServerProxy sp = this.findServerProxy(svname);
                if (sp == null) {
                    String cdn = sv.getClusterDaemon();
                    ClusterDaemonProxy cdp = null;
                    if (cdn != null && (cdp = this.clusterDaemons.get(cdn)) == null) {
                        logger.log(BasicLevel.WARN, (Object)("Undeclared ClusterDaemon :" + cdn));
                    }
                    Location loc = sv.getLocation();
                    sp = new ServerProxy(this, svname, loc.getUrlList(), cdp);
                    ObjectName on = JonasObjectName.serverProxy(this.domainName, svname);
                    sp.setObjectName(on.toString());
                }
                locl.addServer(svname, sp);
                this.notifyServerProxyRunning(sp);
            }
        }
    }

    public BaseCluster findCluster(String name) {
        ClusterFactory cf;
        logger.log(BasicLevel.DEBUG, (Object)name);
        if (!this.ismaster) {
            throw new RuntimeException("This is not the master.");
        }
        BaseCluster cluster = null;
        Iterator<ClusterFactory> it = this.clusterFactoryList.iterator();
        while (it.hasNext() && (cluster = (cf = it.next()).getCluster(name)) == null) {
        }
        return cluster;
    }

    public ServerProxy findServerProxy(String name) {
        logger.log(BasicLevel.DEBUG, (Object)name);
        if (!this.ismaster) {
            throw new RuntimeException("This is not the master.");
        }
        BaseCluster cluster = this.lclFactory.getCluster(this.domainName);
        if (cluster == null) {
            return null;
        }
        return cluster.getServerProxy(name);
    }

    public ClusterDaemonProxy findClusterDaemonProxy(String name) {
        if (!this.ismaster) {
            throw new RuntimeException("This is not the master.");
        }
        return this.clusterDaemons.get(name);
    }

    public void registerClusterDaemonProxy(String cdName, String serverName, Collection urls) throws MalformedObjectNameException {
        if (!this.ismaster) {
            throw new RuntimeException("This is not the master.");
        }
        ObjectName on = JonasObjectName.clusterDaemonProxy(this.domainName, cdName);
        ClusterDaemonProxy cdp = new ClusterDaemonProxy(this, cdName, urls);
        cdp.setObjectName(on.toString());
        if (this.clusterDaemons.get(cdName) != null) {
            this.clusterDaemons.remove(cdName);
        }
        this.clusterDaemons.put(cdName, cdp);
    }

    public AuthenticationInformation getAuthenticationInformation(String name) {
        if (name == null) {
            return this.defaultAuthInfo;
        }
        AuthenticationInformation info = this.authInfo.get(name);
        if (info == null) {
            return this.defaultAuthInfo;
        }
        return info;
    }

    public void addAuthenticationInformation(String name, String username, String password) throws UnsupportedEncodingException {
        AuthenticationInformation info = new AuthenticationInformation(username, AuthenticationInformation.encodePassword(password));
        if (name == null) {
            this.defaultAuthInfo = info;
        } else {
            this.authInfo.put(name, info);
        }
    }

    public void removeAuthenticationInformation(String name) {
        if (name == null) {
            this.defaultAuthInfo = null;
        } else {
            this.authInfo.remove(name);
        }
    }

    public Collection getServerList() {
        if (!this.ismaster) {
            throw new RuntimeException("This is not the master.");
        }
        LogicalCluster domaincluster = (LogicalCluster)this.lclFactory.getCluster(this.domainName);
        if (domaincluster == null) {
            return new ArrayList();
        }
        return domaincluster.getServerProxyList();
    }

    public Collection<ClusterDaemonProxy> getClusterDaemonList() {
        if (!this.ismaster) {
            throw new RuntimeException("This is not the master.");
        }
        return this.clusterDaemons.values();
    }

    public Collection getTotalClusterList() {
        if (!this.ismaster) {
            throw new RuntimeException("This is not the master.");
        }
        ArrayList ret = new ArrayList();
        for (ClusterFactory cf : this.clusterFactoryList) {
            ret.addAll(cf.getClusterList());
        }
        return ret;
    }

    private LogicalCluster createLogicalCluster(String name) {
        if (!this.ismaster) {
            throw new RuntimeException("This is not the master.");
        }
        return this.lclFactory.createLogicalCluster(name);
    }

    public Collection getLogicalClusterList() {
        if (!this.ismaster) {
            throw new RuntimeException("This is not the master.");
        }
        return this.lclFactory.getClusterList();
    }

    public String[] getProxys() {
        if (!this.ismaster) {
            throw new RuntimeException("This is not the master.");
        }
        BaseCluster cluster = this.lclFactory.getCluster(this.domainName);
        Collection col = cluster.getServerProxyList();
        String[] ret = new String[col.size()];
        int i = 0;
        for (ServerProxy proxy : col) {
            ret[i++] = proxy.getObjectName();
        }
        return ret;
    }

    public String[] getClusters() {
        if (!this.ismaster) {
            throw new RuntimeException("This is not the master.");
        }
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < this.clusterFactoryList.size(); ++i) {
            ClusterFactory clFactory = this.clusterFactoryList.get(i);
            for (BaseCluster cl : clFactory.getClusterList()) {
                al.add(cl.getObjectName());
            }
        }
        String[] ret = new String[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            ret[i] = (String)al.get(i);
        }
        return ret;
    }

    public void discoveryNotification(DiscoveryEvent event) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Get notification:" + event));
        }
        if (!event.getDomainName().equals(this.domainName)) {
            logger.log(BasicLevel.WARN, (Object)("My domain is: '" + this.domainName + "'. Discovery notification from another domain '" + event.getDomainName() + "'. Forget it."));
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Notification Domain = " + event.getDomainName()));
            }
            return;
        }
        String state = event.getState();
        String svname = event.getServerName();
        ServerProxy proxy = this.findServerProxy(svname);
        if (state.equals("running") || state.equals("starting up")) {
            if (svname.equals(this.masterName)) {
                logger.log(BasicLevel.DEBUG, (Object)"Yes, I'm already running, I knew that.");
                return;
            }
            ArrayList<String> urls = new ArrayList<String>();
            String[] urlstr = event.getConnectorURL();
            for (int i = 0; i < urlstr.length; ++i) {
                urls.add(urlstr[i]);
            }
            if (proxy == null) {
                proxy = new ServerProxy(this, svname, urls, null);
                try {
                    ObjectName on = JonasObjectName.serverProxy(this.domainName, svname);
                    proxy.setObjectName(on.toString());
                }
                catch (MalformedObjectNameException e) {
                    logger.log(BasicLevel.ERROR, (Object)("MalformedObjectName - Cannot register MBEAN:" + svname));
                }
            } else {
                proxy.connect(urls);
            }
            this.notifyServerProxyRunning(proxy);
        } else if (state.equals("stopping") && proxy != null) {
            proxy.notifyStopping();
        }
    }

    public void discoveryNotificationForClusterd(DiscoveryEvent event) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Get notification:" + event + " from cluster daemon \n"));
        }
        if (!event.getDomainName().equals(this.domainName)) {
            logger.log(BasicLevel.WARN, (Object)"Discovery notification from another domain. Forget it.");
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Notification Domain = " + event.getDomainName()));
            }
            return;
        }
        String state = event.getState();
        String clusterdName = event.getServerName();
        ClusterDaemonProxy cdp = this.findClusterDaemonProxy(clusterdName);
        String[] urls = null;
        JLinkedList jUrls = null;
        if (cdp == null) {
            urls = event.getConnectorURL();
            jUrls = new JLinkedList("urls");
            for (int i = 0; i < urls.length; ++i) {
                jUrls.add(urls[i]);
            }
            cdp = new ClusterDaemonProxy(this, clusterdName, jUrls);
            try {
                ObjectName on = JonasObjectName.clusterDaemonProxy(this.domainName, clusterdName);
                cdp.setObjectName(on.toString());
                this.clusterDaemons.put(clusterdName, cdp);
                logger.log(BasicLevel.DEBUG, (Object)("Adding clusterdaemon : " + clusterdName));
            }
            catch (MalformedObjectNameException e) {
                logger.log(BasicLevel.ERROR, (Object)("MalformedObjectName - Cannot register MBean:" + clusterdName));
            }
        }
        if (state.equals("starting up") || state.equals("running")) {
            cdp.notifyStarting(jUrls);
        } else if (state.equals("stopping")) {
            // empty if block
        }
    }

    public void notifyServerProxyRunning(ServerProxy sp) {
        for (ClusterFactory cf : this.clusterFactoryList) {
            cf.notifyServer(sp);
        }
    }

    public synchronized boolean registerDeployAction(DeployAction action) {
        for (DeployAction act : this.deployList) {
            if (!act.getFileName().equals(action.getFileName()) || !act.getServerName().equals(action.getServerName())) continue;
            logger.log(BasicLevel.DEBUG, (Object)"Already a similar action");
            return false;
        }
        return this.deployList.add(action);
    }

    public synchronized String[] getDeployServers(String filename) {
        ArrayList<String> slist = new ArrayList<String>();
        for (DeployAction act : this.deployList) {
            if (!act.getFileName().equals(filename)) continue;
            slist.add(act.getServerName());
        }
        return slist.toArray(new String[0]);
    }

    public synchronized String getDeployState(String filename, String servername) {
        String ret = "error";
        for (DeployAction act : this.deployList) {
            if (!act.getFileName().equals(filename) || !act.getServerName().equals(servername)) continue;
            ret = act.getStateAsString();
            break;
        }
        return ret;
    }

    public synchronized String getErrorMessage(String filename, String servername) {
        String ret = "";
        for (DeployAction act : this.deployList) {
            if (!act.getFileName().equals(filename) || !act.getServerName().equals(servername)) continue;
            ret = act.getErrorMessage();
        }
        return ret;
    }

    public synchronized void forgetAllDeploy() {
        this.deployList.clear();
    }

    public void refreshStates() {
        try {
            this.checkServerStates(false);
        }
        catch (JMException e) {
            logger.log(BasicLevel.DEBUG, (Object)"Cannot refresh states:", (Throwable)e);
        }
    }

    private synchronized void checkServerStates(boolean readall) throws JMException {
        for (ServerProxy serverProxy : this.getServerList()) {
            serverProxy.checkit(readall);
        }
        for (ClusterDaemonProxy clusterDaemonProxy : this.getClusterDaemonList()) {
            clusterDaemonProxy.checkit();
        }
    }

    public MBeanServerConnection getConnection(String serverName) {
        if (serverName == null || this.jonasServerName.equals(serverName)) {
            return this.jmx.getJmxServerConnection();
        }
        if (!this.ismaster) {
            logger.log(BasicLevel.WARN, (Object)"This server is not the master");
            return null;
        }
        ServerProxy serverProxy = this.findServerProxy(serverName);
        if (serverProxy != null) {
            return serverProxy.getConnection();
        }
        return null;
    }

    public String[] getServers(boolean started) {
        Collection col = this.getServerList();
        ArrayList<String> al = new ArrayList<String>();
        for (ServerProxy proxy : col) {
            boolean adit = true;
            if (started && !J2EEState.RUNNING.toString().equals(proxy.getState())) {
                adit = false;
            }
            if (!adit) continue;
            al.add(proxy.getJ2eeObjectName());
        }
        return al.toArray(new String[al.size()]);
    }

    public String[] getServerNames() {
        Collection col = this.getServerList();
        String[] names = new String[col.size()];
        int i = 0;
        for (ServerProxy proxy : col) {
            names[i++] = proxy.getName();
        }
        return names;
    }

    public String[] getServerNames(String clusterName) {
        String[] names = null;
        BaseCluster cl = this.findCluster(clusterName);
        if (cl != null) {
            int nbServers = cl.getNbMembers();
            names = new String[nbServers];
            if (nbServers == 0) {
                return names;
            }
            Iterator sps = cl.getServerProxyList().iterator();
            int i = 0;
            while (sps.hasNext()) {
                ServerProxy sp = (ServerProxy)sps.next();
                names[i++] = sp.getServerName();
            }
        }
        return names;
    }

    public String getServerState(String serverName) {
        ServerProxy proxy = this.findServerProxy(serverName);
        if (proxy != null) {
            return proxy.getState();
        }
        return null;
    }

    public String getClusterState(String clusterName) {
        BaseCluster cl = this.findCluster(clusterName);
        if (cl != null) {
            return cl.getState();
        }
        return null;
    }

    public String getClusterdaemonState(String clusterdaemonName) {
        ClusterDaemonProxy cdProxy = this.findClusterDaemonProxy(clusterdaemonName);
        if (cdProxy != null) {
            return cdProxy.getState();
        }
        return null;
    }

    public String getClusterType(String clusterName) {
        BaseCluster cl = this.findCluster(clusterName);
        if (cl != null) {
            return cl.getType();
        }
        return null;
    }

    public String[] getClusterDaemons() {
        String[] sb = null;
        Collection<ClusterDaemonProxy> col = this.getClusterDaemonList();
        sb = new String[col.size()];
        int i = 0;
        for (ClusterDaemonProxy cdp : col) {
            sb[i++] = cdp.getObjectName();
        }
        return sb;
    }

    public String createCluster(String name) {
        LogicalCluster cl = this.createLogicalCluster(name);
        return cl.getObjectName();
    }

    public void startServer(String serverName) {
        ServerProxy proxy = this.findServerProxy(serverName);
        proxy.startit();
    }

    public void stopServer(String serverName) {
        ServerProxy proxy = this.findServerProxy(serverName);
        proxy.stopit();
    }

    public void deployOnTarget(String target, String fileName) {
        ServerProxy sp = this.findServerProxy(target);
        if (sp != null) {
            sp.deployModule(fileName);
        } else {
            BaseCluster cl = this.findCluster(target);
            if (cl != null) {
                cl.deployModule(fileName);
            } else {
                logger.log(BasicLevel.ERROR, (Object)("Can't deploy on unknown target " + target));
            }
        }
    }

    public void uploadDeployOnTarget(String target, String fileName, boolean replaceExisting) {
        ServerProxy sp = this.findServerProxy(target);
        if (sp != null) {
            sp.uploadDeployModule(fileName, replaceExisting);
        } else {
            BaseCluster cl = this.findCluster(target);
            if (cl != null) {
                cl.uploadDeployModule(fileName, replaceExisting);
            } else {
                logger.log(BasicLevel.ERROR, (Object)("Can't get deploy on unknown target " + target));
            }
        }
    }

    public void unDeployOnTarget(String target, String fileName) {
        ServerProxy sp = this.findServerProxy(target);
        if (sp != null) {
            sp.undeployModule(fileName);
        } else {
            BaseCluster cl = this.findCluster(target);
            if (cl != null) {
                cl.undeployModule(fileName);
            } else {
                logger.log(BasicLevel.ERROR, (Object)("Can't get undeploy on unknown target " + target));
            }
        }
    }

    public boolean stopRemoteTarget(String target) throws JMException {
        BaseCluster cluster = this.findCluster(target);
        if (cluster != null) {
            cluster.stopit();
            return true;
        }
        ServerProxy server = this.findServerProxy(target);
        if (server != null) {
            server.stopit();
            return true;
        }
        return false;
    }

    public boolean startRemoteTarget(String target) throws JMException {
        BaseCluster cluster = this.findCluster(target);
        if (cluster != null) {
            cluster.startit();
            return true;
        }
        ServerProxy server = this.findServerProxy(target);
        if (server != null) {
            server.startit();
            return true;
        }
        return false;
    }

    public boolean uploadDeployFileOn(String target, String filename) {
        BaseCluster cluster = this.findCluster(target);
        if (cluster != null) {
            cluster.uploadDeployModule(filename, true);
            return true;
        }
        ServerProxy server = this.findServerProxy(target);
        if (server != null) {
            server.uploadDeployModule(filename, true);
            return true;
        }
        return false;
    }

    public boolean isCluster(String clusterName) {
        BaseCluster cluster = this.findCluster(clusterName);
        return cluster != null;
    }

    public String[] getServersNotInCluster(String clusterName) {
        String[] allServers = this.getServerNames();
        BaseCluster clust = this.findCluster(clusterName);
        if (clust != null) {
            String[] allServersInCluster = this.getServerNames(clusterName);
            if (allServersInCluster.length == 0) {
                return allServers;
            }
            int nbServers = allServers.length - allServersInCluster.length;
            String[] allServersNotInCluster = new String[nbServers];
            int j = 0;
            for (int i = 0; i < allServers.length; ++i) {
                String server = allServers[i];
                if (clust.isMember(server)) continue;
                try {
                    allServersNotInCluster[j++] = server;
                    continue;
                }
                catch (IndexOutOfBoundsException be) {
                    logger.log(BasicLevel.DEBUG, (Object)("Can't get servers not in cluster " + clusterName + " correctly"));
                    break;
                }
            }
            return allServersNotInCluster;
        }
        return allServers;
    }

    public String[] getServersInCluster(String clusterName) {
        return this.getServerNames(clusterName);
    }

    public String getServerClusterdaemon(String serverName) {
        ServerProxy proxy = this.findServerProxy(serverName);
        if (proxy != null) {
            return proxy.getClusterDaemonName();
        }
        return null;
    }

    public void setJmxService(JmxService jmxService) {
        this.jmx = jmxService;
    }

    public JmxService getJmxService() {
        return this.jmx;
    }

    class StateMonitor
    extends Thread {
        private DomainMonitor domainMonitor;
        private Logger logger;
        private long samplingPeriod;
        private boolean stopped;

        public StateMonitor(DomainMonitor domainMonitor2) {
            super("DomainStateMonitor");
            this.logger = Log.getLogger("org.ow2.jonas.domain.management");
            this.samplingPeriod = 60000L;
            this.stopped = false;
            this.setDaemon(true);
            this.domainMonitor = domainMonitor2;
        }

        public void setSamplingPeriod(int sec) {
            this.samplingPeriod = (long)sec * 1000L;
        }

        public int getSamplingPeriod() {
            return new Long(this.samplingPeriod / 1000L).intValue();
        }

        public void stopit() {
            this.stopped = true;
        }

        public void run() {
            while (!this.stopped) {
                try {
                    StateMonitor.sleep(this.samplingPeriod);
                    this.domainMonitor.checkServerStates(true);
                }
                catch (JMException me) {
                    this.logger.log(BasicLevel.WARN, (Object)"Exception while checking server states", (Throwable)me);
                }
                catch (InterruptedException e) {
                    this.logger.log(BasicLevel.ERROR, (Object)"Interrupted", (Throwable)e);
                    break;
                }
            }
        }
    }
}

