/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.proxy;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.management.domain.AuthenticationInformation;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.management.domain.proxy.ConnectorUtils;
import org.ow2.jonas.lib.management.javaee.J2EEState;
import org.ow2.jonas.lib.util.Log;

public class JMXProxy {
    protected static Logger logger = Log.getLogger("org.ow2.jonas.management.domain");
    private String name = null;
    private String domain;
    private String objectName = null;
    private ArrayList urls;
    private String connectionUrl = null;
    private MBeanServerConnection connection = null;
    private JMXConnector connector = null;
    private JmxService jmx = null;
    private DomainMonitor dm = null;
    private J2EEState state = J2EEState.INITIAL;

    public JMXProxy(DomainMonitor dm, String name, Collection urls) {
        this.dm = dm;
        this.name = name;
        logger.log(BasicLevel.DEBUG, (Object)name);
        this.jmx = dm.getJmxService();
        this.domain = dm.getDomainName();
        if (urls != null && this.connect(urls)) {
            this.state = J2EEState.RUNNING;
        }
    }

    public String getState() {
        return this.state.toString();
    }

    protected J2EEState getJ2EEState() {
        return this.state;
    }

    protected void setState(J2EEState state) {
        this.state = state;
    }

    public void disconnect() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                logger.log(BasicLevel.WARN, (Object)e);
            }
        }
        this.connection = null;
        this.connectionUrl = null;
    }

    public boolean connect(Collection urls) {
        logger.log(BasicLevel.DEBUG, (Object)this.name);
        this.urls = new ArrayList(urls);
        JMXServiceURL url = null;
        String urlstr = (String)urls.iterator().next();
        try {
            url = new JMXServiceURL(urlstr);
        }
        catch (MalformedURLException e) {
            logger.log(BasicLevel.ERROR, (Object)("Malformed URL:" + urlstr));
            return false;
        }
        try {
            String username = null;
            String password = null;
            AuthenticationInformation authInfo = this.dm.getAuthenticationInformation(this.name);
            if (authInfo != null) {
                username = authInfo.getUsername();
                password = authInfo.decodePassword();
            }
            this.connector = ConnectorUtils.getConnector(url, username, password, logger);
            if (this.connector != null) {
                Subject subject = null;
                this.connection = this.connector.getMBeanServerConnection(subject);
                if (this.testConnection(this.connection)) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("connected to server " + this.name + " using URL: " + urlstr));
                    }
                    this.connectionUrl = urlstr;
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Could not establish connection for " + urlstr + ": " + e));
        }
        this.connectionUrl = null;
        return false;
    }

    private boolean testConnection(MBeanServerConnection connection) {
        try {
            connection.getMBeanCount().intValue();
            return true;
        }
        catch (IOException e) {
            logger.log(BasicLevel.DEBUG, (Object)(this.name + " : IOException"));
            return false;
        }
    }

    protected boolean checkConnection() {
        if (this.connection == null) {
            logger.log(BasicLevel.DEBUG, (Object)(this.name + " : null connection, try to connect"));
            return this.connect(this.urls);
        }
        return this.testConnection(this.connection);
    }

    public String getName() {
        return this.name;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String on) {
        this.objectName = on;
        this.jmx.registerMBean((Object)this, on);
    }

    public MBeanServerConnection getConnection() {
        return this.connection;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public ArrayList getUrls() {
        return this.urls;
    }

    public void setConnection(MBeanServerConnection connection) {
        this.connection = connection;
        this.state = J2EEState.RUNNING;
    }

    public DomainMonitor getDm() {
        return this.dm;
    }

    public boolean isRegistered(ObjectName on) {
        if (!this.checkConnection()) {
            logger.log(BasicLevel.ERROR, (Object)"Not yet connected!");
            return false;
        }
        try {
            return this.connection.isRegistered(on);
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)"IO ERROR", (Throwable)e);
            return false;
        }
    }

    public Object getAttribute(ObjectName on, String attribute) {
        if (!this.checkConnection()) {
            logger.log(BasicLevel.ERROR, (Object)"Not yet connected!");
            return null;
        }
        try {
            return this.connection.getAttribute(on, attribute);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot get attribute", (Throwable)e);
            return null;
        }
    }

    public AttributeList getAttributes(ObjectName on, String[] attributes) {
        if (!this.checkConnection()) {
            logger.log(BasicLevel.ERROR, (Object)"Not yet connected!");
            return null;
        }
        try {
            return this.connection.getAttributes(on, attributes);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot get attribute", (Throwable)e);
            return null;
        }
    }

    public Set queryNames(ObjectName on) {
        if (!this.checkConnection()) {
            logger.log(BasicLevel.ERROR, (Object)"Not yet connected!");
            return null;
        }
        try {
            return this.connection.queryNames(on, null);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot get attribute", (Throwable)e);
            return null;
        }
    }
}

