/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.proxy.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.management.domain.DeployAction;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.management.domain.proxy.JMXProxy;
import org.ow2.jonas.lib.management.domain.proxy.clusterd.ClusterDaemonProxy;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxyMBean;
import org.ow2.jonas.lib.management.javaee.J2EEState;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.JoramObjectName;

public class ServerProxy
extends JMXProxy
implements ServerProxyMBean {
    private ObjectName serverOn = null;
    private ClusterDaemonProxy clusterdaemon = null;
    private String description = null;
    private String xprem = null;
    String autoBoot = null;
    private static final int BUFFER_SIZE = 1024;
    private ObjectName jvmOn = null;
    private String hostName = null;
    private String jonasVersion = null;
    private String jonasRoot = null;
    private String jonasBase = null;
    private String javaHome = null;
    private String javaVendor = null;
    private String javaVersion = null;
    private Long currentUsedMemory = new Long(-1L);
    private Long currentTotalMemory = new Long(-1L);
    private int allThreadsCount;
    private String protocols = null;
    private String loadCPU = null;
    private boolean tomcat;
    private int maxThreadsByConnectorTomcat = 0;
    private int currentThreadCountByConnectorTomcat = 0;
    private int currentThreadBusyByConnectorTomcat = 0;
    private long bytesReceivedByConnectorTomcat = 0L;
    private long bytesSentByConnectorTomcat = 0L;
    private int errorCountByConnectorTomcat = 0;
    private long processingTimeByConnectorTomcat = 0L;
    private int requestCountByConnectorTomcat = 0;
    private boolean transaction;
    private int totalBegunTransactions;
    private int totalCommittedTransactions;
    private int totalCurrentTransactions;
    private int totalExpiredTransactions;
    private int totalRolledbackTransactions;
    private boolean workers;
    private int currentWorkerPoolSize;
    private int maxWorkerPoolSize;
    private int minWorkerPoolSize;
    private boolean jcaConnection;
    private int connectionFailuresJCAConnection = 0;
    private int connectionLeaksJCAConnection = 0;
    private int currentBusyJCAConnection = 0;
    private int currentOpenedJCAConnection = 0;
    private int rejectedOpenJCAConnection = 0;
    private int servedOpenJCAConnection = 0;
    private int waiterCountJCAConnection = 0;
    private long waitingTimeJCAConnection = 0L;
    private boolean jdbcDatasource;
    private int connectionFailuresJDBCResource;
    private int connectionLeaksJDBCResource;
    private int currentBusyJDBCResource;
    private int currentOpenedJDBCResource;
    private int rejectedOpenJDBCResource;
    private int servedOpenJDBCResource;
    private int waiterCountJDBCResource;
    private long waitingTimeJDBCResource;
    private boolean jmsJoram;
    private int jmsQueuesNbMsgsReceiveSinceCreation;
    private int jmsQueuesNbMsgsSendToDMQSinceCreation;
    private int jmsQueuesNbMsgsDeliverSinceCreation;
    private int jmsTopicsNbMsgsReceiveSinceCreation;
    private int jmsTopicsNbMsgsSendToDMQSinceCreation;
    private int jmsTopicsNbMsgsDeliverSinceCreation;
    private int currentNumberOfEntityBean;
    private int currentNumberOfEJB;
    private int currentNumberOfMDB;
    private int currentNumberOfSBF;
    private int currentNumberOfSBL;
    private boolean infoSet;

    public ServerProxy(DomainMonitor dm, String serverName, Collection urls, ClusterDaemonProxy cdp) {
        super(dm, serverName, urls);
        if (urls == null) {
            this.setConnection(this.getDm().getJmxService().getJmxServerConnection());
        }
        this.clusterdaemon = cdp;
        this.serverOn = J2eeObjectName.J2EEServer(dm.getDomainName(), serverName);
    }

    public void notifyStopping() {
        logger.log(BasicLevel.DEBUG, (Object)this.getName());
        this.setInfoSet(false);
        this.setState(J2EEState.STOPPING);
    }

    public void checkit(boolean readall) {
        logger.log(BasicLevel.DEBUG, (Object)this.getName());
        if (this.checkConnection()) {
            ObjectName on = J2eeObjectName.J2EEServer(this.getDomain(), this.getName());
            String serverState = null;
            try {
                serverState = (String)this.getConnection().getAttribute(on, "state");
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstanceNotFoundException e) {
                e.printStackTrace();
            }
            catch (MBeanException e) {
                e.printStackTrace();
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                this.setState(J2EEState.UNREACHABLE);
            }
            J2EEState newState = this.translateState(serverState);
            J2EEState oldState = this.getJ2EEState();
            if (!oldState.equals((Object)newState)) {
                if (J2EEState.RUNNING.equals((Object)newState)) {
                    this.getDm().notifyServerProxyRunning(this);
                } else if (J2EEState.UNREACHABLE.equals((Object)newState)) {
                    this.disconnect();
                }
                this.setState(newState);
            }
        } else {
            this.setState(J2EEState.UNREACHABLE);
            this.disconnect();
        }
        if (readall && J2EEState.RUNNING.equals((Object)this.getJ2EEState())) {
            this.getMonitoringInfo();
        }
    }

    private J2EEState translateState(String serverState) {
        if (J2EEState.STARTING.getName().equals(serverState)) {
            return J2EEState.STARTING;
        }
        if (J2EEState.RUNNING.getName().equals(serverState)) {
            return J2EEState.RUNNING;
        }
        if (J2EEState.STOPPING.getName().equals(serverState)) {
            return J2EEState.STOPPING;
        }
        if (J2EEState.STOPPED.getName().equals(serverState)) {
            return J2EEState.STOPPED;
        }
        if (J2EEState.FAILED.getName().equals(serverState)) {
            return J2EEState.FAILED;
        }
        if (J2EEState.UNKNOWN.getName().equals(serverState)) {
            return J2EEState.UNKNOWN;
        }
        return J2EEState.UNKNOWN;
    }

    public String getServerName() {
        return this.getName();
    }

    public String getClusterDaemonName() {
        if (this.clusterdaemon == null) {
            return null;
        }
        return this.clusterdaemon.getName();
    }

    public void startit() {
        logger.log(BasicLevel.DEBUG, (Object)this.getName());
        if (this.clusterdaemon == null) {
            logger.log(BasicLevel.ERROR, (Object)("No ClusterDaemon associated to " + this.getName()));
            return;
        }
        if (!J2EEState.RUNNING.equals((Object)this.getJ2EEState())) {
            this.setState(J2EEState.STARTING);
            this.clusterdaemon.startServer(this.getName(), null);
        }
        this.checkit(true);
    }

    public void stopit() {
        logger.log(BasicLevel.DEBUG, (Object)this.getName());
        if (this.clusterdaemon == null) {
            logger.log(BasicLevel.ERROR, (Object)("No ClusterDaemon associated to " + this.getName()));
            return;
        }
        if (!J2EEState.STOPPED.equals(this.getState())) {
            this.setState(J2EEState.STOPPING);
            if (this.clusterdaemon.stopServer(this.getName(), null)) {
                this.setState(J2EEState.STOPPED);
            }
        }
    }

    public void deployModule(String fileName) {
        logger.log(BasicLevel.DEBUG, (Object)fileName);
        DeployAction act = new DeployAction(this, fileName, 1);
        if (this.getDm() == null) {
            logger.log(BasicLevel.ERROR, (Object)"Operation reserved to the master");
            return;
        }
        if (!this.getDm().registerDeployAction(act)) {
            logger.log(BasicLevel.WARN, (Object)("Operation already running for " + fileName));
            return;
        }
        if (!this.checkConnection()) {
            logger.log(BasicLevel.WARN, (Object)("Cannot deploy: Server " + this.getName() + " not running"));
            act.setError("server not running");
            return;
        }
        String opName = "deploy";
        Object[] params = new String[]{fileName};
        String[] signature = new String[]{"java.lang.String"};
        try {
            this.getConnection().invoke(this.serverOn, opName, params, signature);
        }
        catch (InstanceNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot deploy file: " + fileName + " :"), (Throwable)e);
            act.setError("Remote J2EEServer not registered");
            return;
        }
        catch (MBeanException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot deploy file: " + fileName + " :"), (Throwable)e);
            Exception t = e.getTargetException();
            String errmess = t.getMessage();
            Throwable c = t.getCause();
            if (c != null) {
                errmess = errmess + " - " + c.getMessage();
            }
            act.setError(errmess);
            return;
        }
        catch (ReflectionException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot deploy file: " + fileName + " :"), (Throwable)e);
            act.setError(e.getCause().getMessage());
            return;
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot deploy file: " + fileName + " :"), (Throwable)e);
            act.setError(e.getMessage());
            return;
        }
        catch (RuntimeOperationsException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot deploy file: " + fileName + " :"), (Throwable)e);
            RuntimeException t = e.getTargetException();
            String errmess = t.getMessage();
            Throwable c = t.getCause();
            if (c != null) {
                errmess = errmess + " - " + c.getMessage();
            }
            act.setError(errmess);
            return;
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Unexpected exception: " + e));
            act.setError(e.getMessage());
            return;
        }
        act.setOK();
    }

    public void undeployModule(String fileName) {
        logger.log(BasicLevel.DEBUG, (Object)fileName);
        DeployAction act = new DeployAction(this, fileName, 2);
        if (this.getDm() == null) {
            logger.log(BasicLevel.ERROR, (Object)"Operation reserved to the master");
            return;
        }
        if (!this.getDm().registerDeployAction(act)) {
            logger.log(BasicLevel.WARN, (Object)("Operation already running for " + fileName));
            return;
        }
        if (!this.checkConnection()) {
            logger.log(BasicLevel.WARN, (Object)("Cannot undeploy: Server " + this.getName() + " not running"));
            act.setError("server not running");
            return;
        }
        String opName = "undeploy";
        Object[] params = new String[]{fileName};
        String[] signature = new String[]{"java.lang.String"};
        try {
            this.getConnection().invoke(this.serverOn, opName, params, signature);
        }
        catch (InstanceNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot undeploy file: " + fileName + " :"), (Throwable)e);
            act.setError("Remote J2EEServer not registered");
            return;
        }
        catch (MBeanException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot undeploy file: " + fileName + " :"), (Throwable)e);
            Exception t = e.getTargetException();
            String errmess = t.getMessage();
            Throwable c = t.getCause();
            if (c != null) {
                errmess = errmess + " - " + c.getMessage();
            }
            act.setError(errmess);
            return;
        }
        catch (ReflectionException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot undeploy file: " + fileName + " :"), (Throwable)e);
            act.setError(e.getCause().getMessage());
            return;
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot undeploy file: " + fileName + " :"), (Throwable)e);
            act.setError(e.getMessage());
            return;
        }
        act.setOK();
    }

    public void uploadFile(String fileName, boolean replaceExisting) {
        logger.log(BasicLevel.DEBUG, (Object)fileName);
        DeployAction act = new DeployAction(this, fileName, 3);
        if (this.getDm() == null) {
            logger.log(BasicLevel.ERROR, (Object)"Operation reserved to the master");
            return;
        }
        if (!this.getDm().registerDeployAction(act)) {
            logger.log(BasicLevel.WARN, (Object)("Operation already running for " + fileName));
            return;
        }
        if (!this.checkConnection()) {
            logger.log(BasicLevel.WARN, (Object)("Cannot upload file: Server " + this.getName() + " not running"));
            act.setError("server not running");
            return;
        }
        File file = null;
        try {
            file = new File(fileName).getCanonicalFile();
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot upload file " + fileName), (Throwable)e);
            act.setError(e.getMessage());
            return;
        }
        String deployName = file.getName();
        if (!file.exists()) {
            String dir2 = this.getFolderDir(fileName);
            if (dir2 == null) {
                act.setError("Directory not found");
                return;
            }
            file = new File(dir2, fileName);
            deployName = fileName;
        }
        if (file == null || !file.exists()) {
            act.setError("File not found");
            return;
        }
        try {
            int len;
            FileInputStream inputStream = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            byte[] bytesOfFile = baos.toByteArray();
            Object[] opParams = new Object[]{bytesOfFile, deployName, replaceExisting};
            String[] opSignature = new String[]{"[B", "java.lang.String", "boolean"};
            this.getConnection().invoke(this.serverOn, "sendFile", opParams, opSignature);
        }
        catch (InstanceNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot upload file: " + fileName + " :"), (Throwable)e);
            act.setError("Remote J2EEServer not registered");
            return;
        }
        catch (MBeanException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot upload file: " + fileName + " :"), (Throwable)e);
            Exception t = e.getTargetException();
            String errmess = t.getMessage();
            Throwable c = t.getCause();
            if (c != null) {
                errmess = errmess + " - " + c.getMessage();
            }
            act.setError(errmess);
            return;
        }
        catch (ReflectionException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot upload file: " + fileName + " :"), (Throwable)e);
            act.setError(e.getCause().getMessage());
            return;
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot upload file: " + fileName + " :"), (Throwable)e);
            act.setError(e.getMessage());
            return;
        }
        act.setOK();
    }

    public void uploadDeployModule(String fileName, boolean replaceExisting) {
        logger.log(BasicLevel.DEBUG, (Object)fileName);
        DeployAction act = new DeployAction(this, fileName, 4);
        if (this.getDm() == null) {
            logger.log(BasicLevel.ERROR, (Object)"Operation only allowed to the master");
            return;
        }
        if (!this.getDm().registerDeployAction(act)) {
            logger.log(BasicLevel.WARN, (Object)("Operation already running for " + fileName));
            return;
        }
        if (!this.checkConnection()) {
            logger.log(BasicLevel.WARN, (Object)("Cannot upload file: Server " + this.getName() + " not running"));
            act.setError("server not running");
            return;
        }
        File file = null;
        try {
            file = new File(fileName).getCanonicalFile();
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot upload file " + fileName), (Throwable)e);
            act.setError(e.getMessage());
            return;
        }
        String deployName = file.getName();
        if (!file.exists()) {
            String dir2 = this.getFolderDir(fileName);
            if (dir2 == null) {
                act.setError("Directory not found");
                return;
            }
            file = new File(dir2, fileName);
            deployName = fileName;
        }
        if (file == null || !file.exists()) {
            act.setError("File not found");
            return;
        }
        try {
            int len;
            FileInputStream inputStream = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            byte[] bytesOfFile = baos.toByteArray();
            Object[] opParams = new Object[]{bytesOfFile, deployName, replaceExisting};
            String[] opSignature = new String[]{"[B", "java.lang.String", "boolean"};
            this.getConnection().invoke(this.serverOn, "sendFile", opParams, opSignature);
        }
        catch (InstanceNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot upload file: " + fileName + " :"), (Throwable)e);
            act.setError("Remote J2EEServer not registered");
            return;
        }
        catch (MBeanException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot upload file: " + fileName + " :"), (Throwable)e);
            Exception t = e.getTargetException();
            String errmess = t.getMessage();
            Throwable c = t.getCause();
            if (c != null) {
                errmess = errmess + " - " + c.getMessage();
            }
            act.setError(errmess);
            return;
        }
        catch (ReflectionException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot upload file: " + fileName + " :"), (Throwable)e);
            act.setError(e.getCause().getMessage());
            return;
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot upload file: " + fileName + " :"), (Throwable)e);
            act.setError(e.getMessage());
            return;
        }
        act.setDeploying();
        String opName = null;
        if (fileName.endsWith(".jar")) {
            opName = "deployJar";
        } else if (fileName.endsWith(".war")) {
            opName = "deployWar";
        } else if (fileName.endsWith(".rar")) {
            opName = "deployRar";
        } else if (fileName.endsWith(".ear")) {
            opName = "deployEar";
        } else {
            logger.log(BasicLevel.ERROR, (Object)("Cannot deploy this type of file: " + fileName));
            return;
        }
        Object[] params = new String[]{fileName};
        String[] signature = new String[]{"java.lang.String"};
        try {
            this.getConnection().invoke(this.serverOn, opName, params, signature);
        }
        catch (InstanceNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot deploy file: " + fileName + " :"), (Throwable)e);
            act.setError("Remote J2EEServer not registered");
            return;
        }
        catch (MBeanException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot deploy file: " + fileName + " :"), (Throwable)e);
            Exception t = e.getTargetException();
            String errmess = t.getMessage();
            Throwable c = t.getCause();
            if (c != null) {
                errmess = errmess + " - " + c.getMessage();
            }
            act.setError(errmess);
            return;
        }
        catch (ReflectionException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot deploy file: " + fileName + " :"), (Throwable)e);
            act.setError(e.getCause().getMessage());
            return;
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot deploy file: " + fileName + " :"), (Throwable)e);
            act.setError(e.getMessage());
            return;
        }
        act.setOK();
    }

    private String getFolderDir(String fileName) {
        String jBase = JProp.getJonasBase();
        String dir2 = null;
        if (fileName.toLowerCase().endsWith(".jar")) {
            dir2 = jBase + File.separator + "ejbjars";
        } else if (fileName.toLowerCase().endsWith(".war")) {
            dir2 = jBase + File.separator + "webapps";
        } else if (fileName.toLowerCase().endsWith(".ear")) {
            dir2 = jBase + File.separator + "apps";
        } else if (fileName.toLowerCase().endsWith(".rar")) {
            dir2 = jBase + File.separator + "rars";
        } else {
            logger.log(BasicLevel.ERROR, (Object)("Invalid extension for " + fileName));
        }
        return dir2;
    }

    public boolean isInfoSet() {
        return this.infoSet;
    }

    public void setInfoSet(boolean infoSet) {
        this.infoSet = infoSet;
    }

    private void getInfo() {
        logger.log(BasicLevel.DEBUG, (Object)this.getName());
        if (!this.checkConnection()) {
            logger.log(BasicLevel.INFO, (Object)("Cannot set info for " + this.getName()));
            logger.log(BasicLevel.INFO, (Object)"Connection is not established yet");
            return;
        }
        String domain = this.getDomain();
        this.jvmOn = J2eeObjectName.JVM(domain, this.getName(), this.getName());
        String attr = "";
        boolean infoServerRead = false;
        boolean infoJvmRead = false;
        try {
            String name;
            Attribute at;
            int i;
            AttributeList al;
            String[] attributes;
            if (this.serverOn != null && this.getConnection().isRegistered(this.serverOn)) {
                attributes = new String[]{"serverVersion", "jonasBase", "jonasRoot"};
                al = this.getConnection().getAttributes(this.serverOn, attributes);
                for (i = 0; i < al.size(); ++i) {
                    at = (Attribute)al.get(i);
                    name = at.getName();
                    if ("serverVersion".equals(name)) {
                        this.jonasVersion = (String)at.getValue();
                        continue;
                    }
                    if ("jonasBase".equals(name)) {
                        this.jonasBase = (String)at.getValue();
                        continue;
                    }
                    if (!"jonasRoot".equals(name)) continue;
                    this.jonasRoot = (String)at.getValue();
                }
                infoServerRead = true;
            }
            if (this.jvmOn != null && this.getConnection().isRegistered(this.jvmOn)) {
                attributes = new String[]{"javaVersion", "javaVendor", "node", "javaHome"};
                al = this.getConnection().getAttributes(this.jvmOn, attributes);
                for (i = 0; i < al.size(); ++i) {
                    at = (Attribute)al.get(i);
                    name = at.getName();
                    if ("javaVersion".equals(name)) {
                        this.javaVersion = (String)at.getValue();
                        continue;
                    }
                    if ("javaVendor".equals(name)) {
                        this.javaVendor = (String)at.getValue();
                        continue;
                    }
                    if ("node".equals(name)) {
                        this.hostName = (String)at.getValue();
                        continue;
                    }
                    if (!"javaHome".equals(name)) continue;
                    this.javaHome = (String)at.getValue();
                }
                infoJvmRead = true;
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Error while getting attribute " + attr));
            logger.log(BasicLevel.WARN, (Object)("serverObjectName=" + this.serverOn));
            logger.log(BasicLevel.WARN, (Object)("jvmObjectName=" + this.jvmOn));
            throw new RuntimeException("Error while getting attribute " + attr + " from " + this.getName(), e);
        }
        if (infoJvmRead && infoServerRead) {
            this.setInfoSet(true);
        }
    }

    public void getMonitoringInfo() {
        logger.log(BasicLevel.DEBUG, (Object)this.getName());
        if (!this.isInfoSet()) {
            this.getInfo();
        }
        if (!this.checkConnection()) {
            logger.log(BasicLevel.INFO, (Object)("Cannot get monitoring info for " + this.getName()));
            logger.log(BasicLevel.INFO, (Object)"Connection is not established yed");
            return;
        }
        ObjectName on = null;
        try {
            if (this.jvmOn != null && this.getConnection().isRegistered(this.jvmOn)) {
                on = this.jvmOn;
                this.allThreadsCount = (Integer)this.getConnection().getAttribute(on, "allThreadsCount");
            }
            if (this.serverOn != null && this.getConnection().isRegistered(this.serverOn)) {
                on = this.serverOn;
                String[] attributes = new String[]{"currentUsedMemory", "currentTotalMemory", "protocols"};
                AttributeList al = this.getConnection().getAttributes(on, attributes);
                for (int i = 0; i < al.size(); ++i) {
                    Attribute at = (Attribute)al.get(i);
                    String name = at.getName();
                    if ("currentUsedMemory".equals(name)) {
                        this.currentUsedMemory = (Long)at.getValue();
                        continue;
                    }
                    if ("currentTotalMemory".equals(name)) {
                        this.currentTotalMemory = (Long)at.getValue();
                        continue;
                    }
                    if (!"protocols".equals(name)) continue;
                    this.protocols = (String)at.getValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(BasicLevel.WARN, (Object)("Error while monitoting MBean " + on + ", " + e));
        }
        this.getMonitoringInfoTomcat();
        this.getMonitoringInfoWorkers();
        this.getMonitoringInfoTransaction();
        this.getMonitoringInfoJCAConnection();
        this.getMonitoringInfoJDBCResource();
        this.getMonitoringInfoEJBs();
        this.getMonitoringInfoJmsJoram();
    }

    private void getMonitoringInfoJmsJoram() {
        ObjectName on2 = null;
        try {
            this.jmsJoram = false;
            on2 = J2eeObjectName.getResourceAdapters(this.getDomain(), this.getName());
            QueryExp query = Query.match(Query.attr("resourceAdapterClassname"), Query.value("org.objectweb.joram.client.connector.JoramAdapter"));
            Iterator<ObjectName> it = this.getConnection().queryNames(on2, query).iterator();
            if (it.hasNext()) {
                this.jmsJoram = true;
                Hashtable statistic = null;
                this.jmsQueuesNbMsgsReceiveSinceCreation = 0;
                this.jmsQueuesNbMsgsSendToDMQSinceCreation = 0;
                this.jmsQueuesNbMsgsDeliverSinceCreation = 0;
                this.jmsTopicsNbMsgsReceiveSinceCreation = 0;
                this.jmsTopicsNbMsgsSendToDMQSinceCreation = 0;
                this.jmsTopicsNbMsgsDeliverSinceCreation = 0;
                on2 = JoramObjectName.joramQueues();
                Set<ObjectName> onSet = this.getConnection().queryNames(on2, null);
                for (ObjectName on2 : onSet) {
                    statistic = (Hashtable)this.getConnection().getAttribute(on2, "Statistic");
                    this.jmsQueuesNbMsgsReceiveSinceCreation = (int)((double)this.jmsQueuesNbMsgsReceiveSinceCreation + ((Long)statistic.get("nbMsgsReceiveSinceCreation")).doubleValue());
                    this.jmsQueuesNbMsgsSendToDMQSinceCreation = (int)((double)this.jmsQueuesNbMsgsSendToDMQSinceCreation + ((Long)statistic.get("nbMsgsSendToDMQSinceCreation")).doubleValue());
                    this.jmsQueuesNbMsgsDeliverSinceCreation = (int)((double)this.jmsQueuesNbMsgsDeliverSinceCreation + ((Long)statistic.get("nbMsgsDeliverSinceCreation")).doubleValue());
                }
                on2 = JoramObjectName.joramTopics();
                onSet = this.getConnection().queryNames(on2, null);
                for (ObjectName on2 : onSet) {
                    statistic = (Hashtable)this.getConnection().getAttribute(on2, "Statistic");
                    this.jmsTopicsNbMsgsReceiveSinceCreation = (int)((double)this.jmsTopicsNbMsgsReceiveSinceCreation + ((Long)statistic.get("nbMsgsReceiveSinceCreation")).doubleValue());
                    this.jmsTopicsNbMsgsSendToDMQSinceCreation = (int)((double)this.jmsTopicsNbMsgsSendToDMQSinceCreation + ((Long)statistic.get("nbMsgsSendToDMQSinceCreation")).doubleValue());
                    this.jmsTopicsNbMsgsDeliverSinceCreation = (int)((double)this.jmsTopicsNbMsgsDeliverSinceCreation + ((Long)statistic.get("nbMsgsDeliverSinceCreation")).doubleValue());
                }
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Error while monitoring MBean " + on2 + ", " + e));
        }
    }

    private void getMonitoringInfoTomcat() {
        ObjectName on = null;
        try {
            String name;
            Attribute at;
            int i;
            AttributeList al;
            String[] attributes;
            ObjectName ons = ObjectName.getInstance(this.getDomain() + ":type=ThreadPool,*");
            this.tomcat = false;
            this.maxThreadsByConnectorTomcat = 0;
            this.currentThreadCountByConnectorTomcat = 0;
            this.currentThreadBusyByConnectorTomcat = 0;
            Iterator<ObjectName> it = this.getConnection().queryNames(ons, null).iterator();
            while (it.hasNext()) {
                this.tomcat = true;
                on = it.next();
                attributes = new String[]{"maxThreads", "currentThreadCount", "currentThreadsBusy"};
                al = this.getConnection().getAttributes(on, attributes);
                for (i = 0; i < al.size(); ++i) {
                    at = (Attribute)al.get(i);
                    name = at.getName();
                    if ("maxThreads".equals(name)) {
                        this.maxThreadsByConnectorTomcat += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("currentThreadCount".equals(name)) {
                        this.currentThreadCountByConnectorTomcat += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if (!"currentThreadsBusy".equals(name)) continue;
                    int value = (Integer)at.getValue();
                    this.currentThreadBusyByConnectorTomcat += value;
                }
            }
            ons = ObjectName.getInstance(this.getDomain() + ":type=GlobalRequestProcessor,*");
            this.bytesReceivedByConnectorTomcat = 0L;
            this.bytesSentByConnectorTomcat = 0L;
            this.errorCountByConnectorTomcat = 0;
            this.processingTimeByConnectorTomcat = 0L;
            this.requestCountByConnectorTomcat = 0;
            it = this.getConnection().queryNames(ons, null).iterator();
            while (it.hasNext()) {
                this.tomcat = true;
                on = it.next();
                attributes = new String[]{"bytesReceived", "bytesSent", "errorCount", "maxTime", "processingTime", "requestCount"};
                al = this.getConnection().getAttributes(on, attributes);
                for (i = 0; i < al.size(); ++i) {
                    at = (Attribute)al.get(i);
                    name = at.getName();
                    if ("bytesReceived".equals(name)) {
                        this.bytesReceivedByConnectorTomcat += ((Long)at.getValue()).longValue();
                        continue;
                    }
                    if ("bytesSent".equals(name)) {
                        this.bytesSentByConnectorTomcat += ((Long)at.getValue()).longValue();
                        continue;
                    }
                    if ("errorCount".equals(name)) {
                        this.errorCountByConnectorTomcat += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("processingTime".equals(name)) {
                        this.processingTimeByConnectorTomcat += ((Long)at.getValue()).longValue();
                        continue;
                    }
                    if (!"requestCount".equals(name)) continue;
                    this.requestCountByConnectorTomcat += ((Integer)at.getValue()).intValue();
                }
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Error while monitoring MBean " + on));
        }
    }

    private void getMonitoringInfoTransaction() {
        ObjectName jtaOn = J2eeObjectName.JTAResource(this.getDomain(), this.getName(), null);
        this.transaction = false;
        try {
            if (jtaOn != null && this.getConnection().isRegistered(jtaOn)) {
                this.transaction = true;
                String[] attributes = new String[]{"totalBegunTransactions", "totalCommittedTransactions", "totalCurrentTransactions", "totalExpiredTransactions", "totalRolledbackTransactions"};
                AttributeList al = this.getConnection().getAttributes(jtaOn, attributes);
                for (int i = 0; i < al.size(); ++i) {
                    Attribute at = (Attribute)al.get(i);
                    String name = at.getName();
                    if ("totalBegunTransactions".equals(name)) {
                        this.totalBegunTransactions = (Integer)at.getValue();
                        continue;
                    }
                    if ("totalCommittedTransactions".equals(name)) {
                        this.totalCommittedTransactions = (Integer)at.getValue();
                        continue;
                    }
                    if ("totalCurrentTransactions".equals(name)) {
                        this.totalCurrentTransactions = (Integer)at.getValue();
                        continue;
                    }
                    if (!"totalRolledbackTransactions".equals(name)) continue;
                    this.totalRolledbackTransactions = (Integer)at.getValue();
                }
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Error while monitoring MBean " + jtaOn));
        }
    }

    private void getMonitoringInfoWorkers() {
        ObjectName wpoolOn = JonasObjectName.workManager(this.getDomain());
        this.workers = false;
        try {
            if (wpoolOn != null && this.getConnection().isRegistered(wpoolOn)) {
                this.workers = true;
                String[] attributes = new String[]{"currentPoolSize", "maxPoolSize", "minPoolSize"};
                AttributeList al = this.getConnection().getAttributes(wpoolOn, attributes);
                for (int i = 0; i < al.size(); ++i) {
                    Attribute at = (Attribute)al.get(i);
                    String name = at.getName();
                    if ("currentPoolSize".equals(name)) {
                        this.currentWorkerPoolSize = (Integer)at.getValue();
                        continue;
                    }
                    if ("maxPoolSize".equals(name)) {
                        this.maxWorkerPoolSize = (Integer)at.getValue();
                        continue;
                    }
                    if (!"minPoolSize".equals(name)) continue;
                    this.minWorkerPoolSize = (Integer)at.getValue();
                }
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Error while monitoring MBean " + wpoolOn));
        }
    }

    private void getMonitoringInfoJDBCResource() {
        ObjectName jdbcDatasourcesOn = J2eeObjectName.getJDBCDataSources(this.getDomain(), this.getName());
        ObjectName jdbcDatasourceOn2 = null;
        this.jdbcDatasource = false;
        try {
            Set<ObjectName> jdbcDatasourceOns = this.getConnection().queryNames(jdbcDatasourcesOn, null);
            if (jdbcDatasourceOns.isEmpty()) {
                return;
            }
            String[] attributes = new String[]{"connectionFailures", "connectionLeaks", "currentBusy", "currentOpened", "rejectedOpen", "servedOpen", "waiterCount", "waitingTime"};
            this.jdbcDatasource = true;
            this.connectionFailuresJDBCResource = 0;
            this.connectionLeaksJDBCResource = 0;
            this.currentBusyJDBCResource = 0;
            this.currentOpenedJDBCResource = 0;
            this.rejectedOpenJDBCResource = 0;
            this.servedOpenJDBCResource = 0;
            this.waiterCountJDBCResource = 0;
            this.waitingTimeJDBCResource = 0L;
            for (ObjectName jdbcDatasourceOn2 : jdbcDatasourceOns) {
                AttributeList al = this.getConnection().getAttributes(jdbcDatasourceOn2, attributes);
                for (int i = 0; i < al.size(); ++i) {
                    Attribute at = (Attribute)al.get(i);
                    String name = at.getName();
                    if ("connectionFailures".equals(name)) {
                        this.connectionFailuresJDBCResource += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("connectionLeaks".equals(name)) {
                        this.connectionLeaksJDBCResource += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("currentBusy".equals(name)) {
                        this.currentBusyJDBCResource += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("currentOpened".equals(name)) {
                        this.currentOpenedJDBCResource += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("rejectedOpen".equals(name)) {
                        this.rejectedOpenJDBCResource += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("servedOpen".equals(name)) {
                        this.servedOpenJDBCResource += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("waiterCount".equals(name)) {
                        this.waiterCountJDBCResource += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if (!"waitingTime".equals(name)) continue;
                    this.waitingTimeJDBCResource += (long)((Long)at.getValue()).intValue();
                }
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Error while monitoring MBean " + jdbcDatasourceOn2));
        }
    }

    private void getMonitoringInfoJCAConnection() {
        ObjectName jcaFactoriesOn = J2eeObjectName.getJCAConnectionFactories(this.getDomain(), this.getName());
        ObjectName jcaFactoryOn2 = null;
        this.jcaConnection = false;
        try {
            Set<ObjectName> jcaFactoryOns = this.getConnection().queryNames(jcaFactoriesOn, null);
            if (jcaFactoryOns.isEmpty()) {
                return;
            }
            String[] attributes = new String[]{"connectionFailures", "connectionLeaks", "currentBusy", "currentOpened", "rejectedOpen", "servedOpen", "waiterCount", "waitingTime"};
            this.jcaConnection = true;
            this.connectionFailuresJCAConnection = 0;
            this.connectionLeaksJCAConnection = 0;
            this.currentBusyJCAConnection = 0;
            this.currentOpenedJCAConnection = 0;
            this.rejectedOpenJCAConnection = 0;
            this.servedOpenJCAConnection = 0;
            this.waiterCountJCAConnection = 0;
            this.waitingTimeJCAConnection = 0L;
            for (ObjectName jcaFactoryOn2 : jcaFactoryOns) {
                AttributeList al = this.getConnection().getAttributes(jcaFactoryOn2, attributes);
                for (int i = 0; i < al.size(); ++i) {
                    Attribute at = (Attribute)al.get(i);
                    String name = at.getName();
                    if ("connectionFailures".equals(name)) {
                        this.connectionFailuresJCAConnection += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("connectionLeaks".equals(name)) {
                        this.connectionLeaksJCAConnection += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("currentBusy".equals(name)) {
                        this.currentBusyJCAConnection += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("currentOpened".equals(name)) {
                        this.currentOpenedJCAConnection += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("rejectedOpen".equals(name)) {
                        this.rejectedOpenJCAConnection += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("servedOpen".equals(name)) {
                        this.servedOpenJCAConnection += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if ("waiterCount".equals(name)) {
                        this.waiterCountJCAConnection += ((Integer)at.getValue()).intValue();
                        continue;
                    }
                    if (!"waitingTime".equals(name)) continue;
                    this.waitingTimeJCAConnection += (long)((Long)at.getValue()).intValue();
                }
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Error while monitoring MBean " + jcaFactoryOn2 + ", " + e));
        }
    }

    private void getMonitoringInfoEJBs() {
        ObjectName entityBeansOn = J2eeObjectName.getEntityBeans(this.getDomain());
        ObjectName on = null;
        try {
            on = J2eeObjectName.getEntityBeans(this.getDomain());
            Set<ObjectName> ons = this.getConnection().queryNames(on, null);
            this.currentNumberOfEntityBean = ons.size();
            on = J2eeObjectName.getStatefulSessionBeans(this.getDomain());
            ons = this.getConnection().queryNames(on, null);
            this.currentNumberOfSBF = ons.size();
            on = J2eeObjectName.getStatelessSessionBeans(this.getDomain());
            ons = this.getConnection().queryNames(on, null);
            this.currentNumberOfSBL = ons.size();
            on = J2eeObjectName.getMessageDrivenBeans(this.getDomain());
            ons = this.getConnection().queryNames(on, null);
            this.currentNumberOfMDB = ons.size();
            this.currentNumberOfEJB = this.currentNumberOfEntityBean + this.currentNumberOfSBF + this.currentNumberOfSBL + this.currentNumberOfMDB;
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Error while monitoring MBean " + on + ", " + e));
        }
    }

    public int getAllThreadsCount() {
        return this.allThreadsCount;
    }

    public long getBytesReceivedByConnectorTomcat() {
        return this.bytesReceivedByConnectorTomcat;
    }

    public long getBytesSentByConnectorTomcat() {
        return this.bytesSentByConnectorTomcat;
    }

    public int getConnectionFailuresJCAConnection() {
        return this.connectionFailuresJCAConnection;
    }

    public int getConnectionLeaksJCAConnection() {
        return this.connectionLeaksJCAConnection;
    }

    public int getCurrentBusyJCAConnection() {
        return this.currentBusyJCAConnection;
    }

    public int getCurrentNumberOfEntityBean() {
        return this.currentNumberOfEntityBean;
    }

    public int getCurrentNumberOfEJB() {
        return this.currentNumberOfEJB;
    }

    public int getCurrentNumberOfMDB() {
        return this.currentNumberOfMDB;
    }

    public int getCurrentNumberOfSBF() {
        return this.currentNumberOfSBF;
    }

    public int getCurrentNumberOfSBL() {
        return this.currentNumberOfSBL;
    }

    public int getCurrentOpenedJCAConnection() {
        return this.currentOpenedJCAConnection;
    }

    public int getCurrentThreadBusyByConnectorTomcat() {
        return this.currentThreadBusyByConnectorTomcat;
    }

    public int getCurrentThreadCountByConnectorTomcat() {
        return this.currentThreadCountByConnectorTomcat;
    }

    public Long getCurrentTotalMemory() {
        return this.currentTotalMemory;
    }

    public Long getCurrentUsedMemory() {
        return this.currentUsedMemory;
    }

    public int getCurrentWorkerPoolSize() {
        return this.currentWorkerPoolSize;
    }

    public int getErrorCountByConnectorTomcat() {
        return this.errorCountByConnectorTomcat;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getJavaVendor() {
        return this.javaVendor;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public int getJmsQueuesNbMsgsDeliverSinceCreation() {
        return this.jmsQueuesNbMsgsDeliverSinceCreation;
    }

    public int getJmsQueuesNbMsgsReceiveSinceCreation() {
        return this.jmsQueuesNbMsgsReceiveSinceCreation;
    }

    public int getJmsQueuesNbMsgsSendToDMQSinceCreation() {
        return this.jmsQueuesNbMsgsSendToDMQSinceCreation;
    }

    public int getJmsTopicsNbMsgsDeliverSinceCreation() {
        return this.jmsTopicsNbMsgsDeliverSinceCreation;
    }

    public int getJmsTopicsNbMsgsReceiveSinceCreation() {
        return this.jmsTopicsNbMsgsReceiveSinceCreation;
    }

    public int getJmsTopicsNbMsgsSendToDMQSinceCreation() {
        return this.jmsTopicsNbMsgsSendToDMQSinceCreation;
    }

    public String getJOnASVersion() {
        return this.jonasVersion;
    }

    public String getLoadCPU() {
        return this.loadCPU;
    }

    public int getMaxThreadsByConnectorTomcat() {
        return this.maxThreadsByConnectorTomcat;
    }

    public int getMaxWorkerPoolSize() {
        return this.maxWorkerPoolSize;
    }

    public int getMinWorkerPoolSize() {
        return this.minWorkerPoolSize;
    }

    public long getProcessingTimeByConnectorTomcat() {
        return this.processingTimeByConnectorTomcat;
    }

    public String getProtocols() {
        return this.protocols;
    }

    public int getRequestCountByConnectorTomcat() {
        return this.requestCountByConnectorTomcat;
    }

    public int getTotalBegunTransactions() {
        return this.totalBegunTransactions;
    }

    public int getTotalCommittedTransactions() {
        return this.totalCommittedTransactions;
    }

    public int getTotalCurrentTransactions() {
        return this.totalCurrentTransactions;
    }

    public int getTotalExpiredTransactions() {
        return this.totalExpiredTransactions;
    }

    public int getTotalRolledbackTransactions() {
        return this.totalRolledbackTransactions;
    }

    public int getWaiterCountJCAConnection() {
        return this.waiterCountJCAConnection;
    }

    public long getWaitingTimeJCAConnection() {
        return this.waitingTimeJCAConnection;
    }

    public boolean getTomcat() {
        return this.tomcat;
    }

    public boolean getTransaction() {
        return this.transaction;
    }

    public boolean getWorkers() {
        return this.workers;
    }

    public int getConnectionFailuresJDBCResource() {
        return this.connectionFailuresJDBCResource;
    }

    public int getConnectionLeaksJDBCResource() {
        return this.connectionLeaksJDBCResource;
    }

    public int getCurrentBusyJDBCResource() {
        return this.currentBusyJDBCResource;
    }

    public int getCurrentOpenedJDBCResource() {
        return this.currentOpenedJDBCResource;
    }

    public int getRejectedOpenJDBCResource() {
        return this.rejectedOpenJDBCResource;
    }

    public int getServedOpenJDBCResource() {
        return this.servedOpenJDBCResource;
    }

    public int getWaiterCountJDBCResource() {
        return this.waiterCountJDBCResource;
    }

    public long getWaitingTimeJDBCResource() {
        return this.waitingTimeJDBCResource;
    }

    public int getServedOpenJCAConnection() {
        return this.servedOpenJCAConnection;
    }

    public int getRejectedOpenJCAConnection() {
        return this.rejectedOpenJCAConnection;
    }

    public boolean getJcaConnection() {
        return this.jcaConnection;
    }

    public boolean getJdbcDatasource() {
        return this.jdbcDatasource;
    }

    public boolean getJmsJoram() {
        return this.jmsJoram;
    }

    public ClusterDaemonProxy getClusterdaemon() {
        return this.clusterdaemon;
    }

    public void setClusterdaemon(ClusterDaemonProxy clusterdaemon) {
        this.clusterdaemon = clusterdaemon;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getJonasRoot() {
        return this.jonasRoot;
    }

    public void setJonasRoot(String jonasRoot) {
        this.jonasRoot = jonasRoot;
    }

    public String getJonasBase() {
        return this.jonasBase;
    }

    public void setJonasBase(String jonasBase) {
        this.jonasBase = jonasBase;
    }

    public String getXprem() {
        return this.xprem;
    }

    public void setXprem(String xprem) {
        this.xprem = xprem;
    }

    public String getAutoBoot() {
        return this.autoBoot;
    }

    public void setAutoBoot(String autoBoot) {
        this.autoBoot = autoBoot;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getName().equals(((ServerProxy)obj).getName());
    }

    public String getJ2eeObjectName() {
        return this.serverOn.toString();
    }
}

