/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.reconfig;

import java.util.Hashtable;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.management.reconfig.IConfigurationActuator;
import org.ow2.jonas.lib.management.reconfig.ReconfigException;
import org.ow2.jonas.lib.management.reconfig.ReconfigManagerMBean;
import org.ow2.jonas.lib.management.reconfig.actuator.BaseConfigurationActuator;
import org.ow2.jonas.lib.management.reconfig.actuator.PropertiesConfigurationActuator;
import org.ow2.jonas.lib.management.reconfig.actuator.XMLConfigurationActuator;
import org.ow2.jonas.lib.reconfig.IConfigurationData;
import org.ow2.jonas.lib.reconfig.PropertiesConfigurationData;
import org.ow2.jonas.lib.reconfig.XMLConfigurationData;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;

public class ReconfigManager
implements ReconfigManagerMBean,
NotificationListener {
    private static Logger logger = null;
    MBeanServer jmxServer = null;
    private static final String SERVICE_TYPE = "service";
    private static final String DATASOURCE_TYPE = "datasource";
    private static final String MAIL_RESOURCE_TYPE = "JavaMailResource";
    private static final String JTA_RESOURCE_TYPE = "JTAResource";
    private static final String JDBC_RESOURCE_TYPE = "JDBCDataSource";
    private static final String SECURITYREALM_FACTORY = "securityfactory";
    private static final String SECURITYREALM_FILE = "jonas-realm.xml";
    ObjectName reconfigManagerObectName = null;
    Properties serverProperties = null;
    String serverConfigFileName = null;
    Hashtable reconfigurators = new Hashtable();

    public ReconfigManager(Properties serverProperties, String domainName, MBeanServer jmxServer) throws ReconfigException {
        logger = Log.getLogger("org.ow2.jonas.management");
        this.serverProperties = serverProperties;
        this.jmxServer = jmxServer;
        try {
            this.serverConfigFileName = JProp.getInstance().getPropFile();
        }
        catch (Exception e) {
            throw new ReconfigException("Can't initialize ReconfigManager because of exception: " + e.toString());
        }
        try {
            ObjectName delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            jmxServer.addNotificationListener(delegate, this, null, null);
        }
        catch (JMException me) {
            throw new ReconfigException("ReconfigManager can't listen to MBeanServerNotifications because of exception: " + me.toString());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ReconfigManager MBean registered itself as listner to MBeanServerNotifications");
        }
        this.reconfigManagerObectName = JonasObjectName.serverConfig(domainName);
    }

    public void handleNotification(Notification notification, Object handback) {
        String notificationType = notification.getType();
        if (notification instanceof MBeanServerNotification) {
            if (notificationType.equals("JMX.mbean.registered")) {
                try {
                    this.handleRegistrationNotification((MBeanServerNotification)notification);
                }
                catch (ReconfigException re) {
                    logger.log(BasicLevel.ERROR, (Object)"ReconfigManager error when trying to handle REGISTRATION_NOTIFICATION", (Throwable)re);
                }
            } else if (notificationType.equals("JMX.mbean.unregistered") && logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Received UNREGISTRATION_NOTIFICATION for MBean " + ((MBeanServerNotification)notification).getMBeanName().toString()));
            }
        } else {
            String name = notification.getMessage();
            long sequence = notification.getSequenceNumber();
            if (notificationType.equals("jonas.management.reconfiguration")) {
                IConfigurationData data = (IConfigurationData)notification.getUserData();
                if (data instanceof PropertiesConfigurationData) {
                    PropertiesConfigurationData prop = (PropertiesConfigurationData)data;
                    this.handleReconfig(name, sequence, prop);
                } else {
                    XMLConfigurationData xmlData = (XMLConfigurationData)data;
                    this.handleReconfig(name, sequence, xmlData);
                }
            } else if (notificationType.equals("jonas.management.reconfiguration.save")) {
                this.handleSave(name, sequence);
            }
        }
    }

    private void handleRegistrationNotification(MBeanServerNotification notification) throws ReconfigException {
        ObjectName notificationSender = notification.getMBeanName();
        String senderType = notificationSender.getKeyProperty("type");
        String senderName = notificationSender.getKeyProperty("name");
        String senderJ2eeType = notificationSender.getKeyProperty("j2eeType");
        BaseConfigurationActuator reconfig = null;
        if (senderJ2eeType != null) {
            senderType = senderJ2eeType;
        }
        if (senderType == null) {
            return;
        }
        if (senderType.equals(SERVICE_TYPE)) {
            if (!senderName.equals("jonasServer")) {
                if (senderName.equals("log")) {
                    String configFileName = notificationSender.getKeyProperty("fname");
                    try {
                        reconfig = new PropertiesConfigurationActuator(senderName, JProp.getInstance(configFileName).getPropFile(), JProp.getInstance(configFileName).getConfigFileEnv());
                    }
                    catch (Exception e) {
                        logger.log(BasicLevel.WARN, (Object)"Cannot do persistent reconfiguration for dynamically loaded resources!");
                    }
                } else {
                    reconfig = new PropertiesConfigurationActuator(senderName, this.serverConfigFileName, this.serverProperties);
                }
            }
        } else {
            String resourceName = null;
            try {
                if (senderType.equals(MAIL_RESOURCE_TYPE)) {
                    resourceName = (String)this.jmxServer.getAttribute(notificationSender, "FactoryName");
                } else if (senderType.equals(JDBC_RESOURCE_TYPE)) {
                    resourceName = (String)this.jmxServer.getAttribute(notificationSender, "name");
                } else if (senderType.equals(JTA_RESOURCE_TYPE)) {
                    reconfig = new PropertiesConfigurationActuator(senderName, this.serverConfigFileName, this.serverProperties);
                }
                if (senderType.equals(SECURITYREALM_FACTORY)) {
                    JProp jprop = JProp.getInstance(SECURITYREALM_FILE);
                    String propsFilename = jprop.getPropFile();
                    String txt = jprop.getConfigFileXml();
                    reconfig = new XMLConfigurationActuator(SECURITYREALM_FILE, propsFilename, txt);
                } else if (resourceName != null) {
                    JProp jprop = JProp.getInstance(resourceName);
                    String propsFilename = jprop.getPropFile();
                    Properties props = JProp.getInstance(resourceName).getConfigFileEnv();
                    reconfig = new PropertiesConfigurationActuator(resourceName, propsFilename, props);
                }
            }
            catch (JMException me) {
                logger.log(BasicLevel.ERROR, (Object)("Catched Exception when trying to treat reconfiguration of the following resource: " + me));
                throw new ReconfigException("Catched Exception when trying to treat reconfiguration of the following resource: ", me);
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Catched Exception when calling JProp.getInstance(" + resourceName + "): " + e));
                throw new ReconfigException("Catched Exception when calling JProp.getInstance(" + resourceName + "): ", e);
            }
        }
        if (reconfig != null) {
            try {
                this.jmxServer.addNotificationListener(notificationSender, this.reconfigManagerObectName, null, null);
            }
            catch (JMException me) {
                logger.log(BasicLevel.ERROR, (Object)("ReconfigManager can't listen to Notifications because of exception: " + me.toString()));
                throw new ReconfigException("ReconfigManager can't listen to Notifications because of exception: ", me);
            }
            this.reconfigurators.put(senderName, reconfig);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Received Registration Notification from " + notificationSender.toString()));
            }
        }
    }

    private void handleReconfig(String name, long sequence, PropertiesConfigurationData prop) throws ReconfigException {
        PropertiesConfigurationActuator actuator;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Received 'jonas.management.reconfiguration' notification concerning service or resource: " + name));
        }
        if ((actuator = (PropertiesConfigurationActuator)this.reconfigurators.get(name)) == null) {
            throw new ReconfigException("Can't find IConfigurationActuator associated to service or resource " + name);
        }
        if (prop.getPropValue() != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Try to reconfigure property : " + prop.getPropName() + " using value value : " + prop.getPropValue()));
            }
            if (prop.replaceProp()) {
                actuator.updateConfig(prop.getPropName(), prop.getPropValue(), sequence);
            } else {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    if (prop.addProp()) {
                        logger.log(BasicLevel.DEBUG, (Object)"This value has to be added to the values sequence");
                    } else {
                        logger.log(BasicLevel.DEBUG, (Object)"This value has to be removed from the values sequence");
                    }
                }
                actuator.updateConfig(prop.getPropName(), prop.getPropValue(), prop.addProp(), sequence);
            }
        } else {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Reconfiguration made on a group of properties");
            }
            actuator.updateConfig(prop.getProps(), sequence);
        }
    }

    private void handleReconfig(String name, long sequence, XMLConfigurationData data) throws ReconfigException {
        XMLConfigurationActuator actuator;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Received 'jonas.management.reconfiguration' notification concerning service or resource: " + name));
        }
        if ((actuator = (XMLConfigurationActuator)this.reconfigurators.get(name)) == null) {
            throw new ReconfigException("Can't find IConfigurationActuator associated to service or resource " + name);
        }
        actuator.updateConfig(data.getXml(), sequence);
    }

    private void handleSave(String name, long sequence) throws ReconfigException {
        IConfigurationActuator actuator;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Received 'jonas.management.reconfiguration.save' notification concerning service or resource: " + name));
        }
        if ((actuator = (IConfigurationActuator)this.reconfigurators.get(name)) == null) {
            throw new ReconfigException("Can't find IConfigurationActuator associated to service or resource " + name);
        }
        actuator.saveConfig(sequence);
    }
}

