/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.mail.internal.factory;

import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.JNDIUtils;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.PropDump;
import org.ow2.jonas.mail.internal.factory.lib.JAuthenticator;

public class JavaMailSessionFactory
implements ObjectFactory {
    protected static final String FACTORY_TYPE = "javax.mail.Session";
    private static Logger logger = null;

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (logger == null) {
            logger = Log.getLogger("org.ow2.jonas.mail");
        }
        Reference ref = (Reference)obj;
        String clname = ref.getClassName();
        if (!ref.getClassName().equals(FACTORY_TYPE)) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot create object : required type is 'javax.mail.Session', but found type is '" + clname + "'."));
            return null;
        }
        Properties props = new Properties();
        Properties authenticationProps = new Properties();
        RefAddr refAddr = null;
        refAddr = ref.get("javaxmailSession.properties");
        if (refAddr != null) {
            props = (Properties)JNDIUtils.getObjectFromBytes((byte[])refAddr.getContent());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                PropDump.print("These are the properties attached to the Reference object used to construct a Session", props, logger, BasicLevel.DEBUG);
            }
        }
        if ((refAddr = ref.get("authentication.properties")) != null) {
            authenticationProps = (Properties)JNDIUtils.getObjectFromBytes((byte[])refAddr.getContent());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                PropDump.print("These are the authentication properties used to construct a Authenticator", authenticationProps, logger, BasicLevel.DEBUG);
            }
        }
        String mailAuthenticationUsername = authenticationProps.getProperty("mail.authentication.username");
        String mailAuthenticationPassword = authenticationProps.getProperty("mail.authentication.password");
        JAuthenticator jAuthenticator = null;
        if (mailAuthenticationUsername != null && mailAuthenticationPassword != null) {
            jAuthenticator = new JAuthenticator(mailAuthenticationUsername, mailAuthenticationPassword);
        }
        Session session = Session.getInstance(props, jAuthenticator);
        return session;
    }
}

