/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap.osgi;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.properties.ServerProperties;

public class JMXAgent {
    private static Logger logger = Log.getLogger("org.ow2.jonas.bootstrap");
    private MBeanServer mbeanServer = null;
    private ServiceRegistration serverRegistration;
    private BundleContext bc = null;
    private ServerProperties serverProperties = null;

    public JMXAgent(BundleContext bc) {
        this.bc = bc;
    }

    public void start() throws Exception {
        logger.log(BasicLevel.DEBUG, (Object)"Starting MBean Server");
        this.initMBeanServer();
        this.serverRegistration = this.bc.registerService(MBeanServer.class.getName(), (Object)this.mbeanServer, null);
    }

    public void stop() {
        logger.log(BasicLevel.DEBUG, (Object)"Stopping MBean Server");
        this.serverRegistration.unregister();
    }

    private void initMBeanServer() {
        String domainName = this.serverProperties.getDomainName();
        ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
        this.mbeanServer = mbeanServers.size() > 0 ? (MBeanServer)mbeanServers.get(0) : MBeanServerFactory.createMBeanServer(domainName);
    }
}

