/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.workcleaner.internal;

import java.util.LinkedList;
import java.util.List;
import javax.management.ObjectName;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.workcleaner.CleanTask;
import org.ow2.jonas.workcleaner.WorkCleanerException;
import org.ow2.jonas.workcleaner.WorkCleanerService;
import org.ow2.jonas.workcleaner.internal.WorkCleanerServiceMBean;
import org.ow2.jonas.workcleaner.internal.WorkCleanerTimer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JOnASWorkCleanerService
extends AbsServiceImpl
implements WorkCleanerService,
WorkCleanerServiceMBean {
    private Log logger = LogFactory.getLog(JOnASWorkCleanerService.class);
    private static final int DEFAULT_CLEAN_PERIOD = 300;
    private int period = 300;
    private JmxService jmxService;
    private List<CleanTask> taskList = new LinkedList<CleanTask>();
    private WorkCleanerTimer workCleanerTimer = new WorkCleanerTimer();

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
        this.workCleanerTimer.setPeriod(period);
    }

    protected void doStart() throws ServiceException {
        this.workCleanerTimer.setWorkCleanerService(this);
        this.workCleanerTimer.setPriority(1);
        this.workCleanerTimer.start();
        this.registerWorkCleanerMBean(this, this.getDomainName());
        this.logger.info("WorkCleaner Service started.", new Object[0]);
    }

    protected void doStop() throws ServiceException {
        this.workCleanerTimer.setStarted(false);
        if (this.jmxService != null) {
            this.unregisterWorkCleanerMBean(this.getDomainName());
        }
        this.logger.info("WorkCleaner Service stopped.", new Object[0]);
    }

    public synchronized void registerTask(CleanTask cleanTask) throws WorkCleanerException {
        this.logger.debug("Register task {0}", cleanTask);
        if (this.taskList == null) {
            throw new WorkCleanerException("Can not add an entry, the vector is null");
        }
        if (cleanTask == null) {
            throw new WorkCleanerException("Can not add a null entry");
        }
        if (!this.taskList.contains(cleanTask)) {
            this.taskList.add(cleanTask);
        }
    }

    public synchronized void unregisterTask(CleanTask cleanTask) throws WorkCleanerException {
        this.logger.debug("Unregister task {0}", cleanTask);
        if (this.taskList == null) {
            throw new WorkCleanerException("Can not unregister an entry, the vector is null");
        }
        if (cleanTask == null) {
            throw new WorkCleanerException("Can not add a null entry");
        }
        if (this.taskList.contains(cleanTask)) {
            this.taskList.remove(cleanTask);
        }
    }

    public synchronized void executeTasks() {
        this.logger.debug("Execute tasks", new Object[0]);
        for (CleanTask cleanTask : this.taskList) {
            try {
                cleanTask.execute();
            }
            catch (WorkCleanerException e) {
                e.printStackTrace();
            }
        }
    }

    private void registerWorkCleanerMBean(Object service, String domainName) {
        ObjectName on = JonasObjectName.workCleaner(domainName);
        try {
            this.jmxService.registerModelMBean(service, on.toString());
        }
        catch (Exception e) {
            this.logger.warn("Could not register WorkCleaner MBean", e);
        }
    }

    private void unregisterWorkCleanerMBean(String domainName) {
        ObjectName on = JonasObjectName.workCleaner(domainName);
        try {
            this.jmxService.unregisterModelMBean(on);
        }
        catch (Exception e) {
            this.logger.warn("Could not unregister WorkCleaner MBean", e);
        }
    }
}

