/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.workmanager.internal;

import java.util.LinkedList;
import java.util.List;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.tm.TransactionService;

public class JWorkManager
implements WorkManager {
    protected List workList = new LinkedList();
    protected static int poolnumber = 0;
    protected static int threadnumber = 0;
    protected int maxpoolsz;
    protected int minpoolsz;
    protected int poolsz;
    protected int freeThreads;
    protected long waitingTime;
    protected boolean valid = true;
    protected static final long FEW_MORE_SECONDS = 3000L;
    private static Logger logger = null;
    private TransactionService transactionService;

    public JWorkManager(int minsz, int maxsz, TransactionService transactionService, long threadwait) {
        this.minpoolsz = minsz;
        this.maxpoolsz = maxsz;
        this.waitingTime = threadwait * 1000L;
        this.transactionService = transactionService;
        ++poolnumber;
        logger = Log.getLogger("org.ow2.jonas.lib.work");
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("thread pool #" + poolnumber));
            logger.log(BasicLevel.DEBUG, (Object)("minpoolsz = " + minsz + " maxpoolsz = " + maxsz));
        }
        this.poolsz = 0;
        while (this.poolsz < minsz) {
            WorkThread st = new WorkThread(this, threadnumber++, poolnumber);
            st.start();
            ++this.poolsz;
        }
    }

    public int getCurrentPoolSize() {
        return this.poolsz;
    }

    public int getMinPoolSize() {
        return this.minpoolsz;
    }

    public int getMaxPoolSize() {
        return this.maxpoolsz;
    }

    public void setMinPoolSize(int minsz) {
        this.minpoolsz = minsz;
    }

    public void setMaxPoolSize(int maxsz) {
        this.maxpoolsz = maxsz;
    }

    public void doWork(Work work) throws WorkException {
        this.doMyWork(work, Long.MAX_VALUE, null, null, 0L);
    }

    public void doWork(Work work, long timeout, ExecutionContext ectx, WorkListener listener) throws WorkException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        if (listener != null) {
            listener.workAccepted(new WorkEvent(this, 1, work, null));
        }
        this.doMyWork(work, timeout, ectx, listener, System.currentTimeMillis());
    }

    public long startWork(Work work) throws WorkException {
        return this.startWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startWork(Work work, long timeout, ExecutionContext ectx, WorkListener listener) throws WorkException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        JWork mywork = new JWork(work, timeout, ectx, listener);
        if (listener != null) {
            listener.workAccepted(new WorkEvent(this, 1, work, null));
        }
        long starttime = System.currentTimeMillis();
        long duration = 0L;
        List list = this.workList;
        synchronized (list) {
            this.workList.add(mywork);
            if (this.poolsz < this.maxpoolsz && this.workList.size() > this.freeThreads) {
                ++this.poolsz;
                WorkThread st = new WorkThread(this, threadnumber++, poolnumber);
                st.start();
            } else {
                this.workList.notify();
            }
        }
        boolean started = false;
        Object object = mywork;
        synchronized (object) {
            if (!mywork.isStarted()) {
                try {
                    long waittime = this.waitingTime;
                    if (timeout < waittime) {
                        waittime = timeout + 3000L;
                    }
                    mywork.wait(waittime);
                }
                catch (InterruptedException e) {
                    throw new WorkRejectedException("Interrupted");
                }
            }
            started = mywork.isStarted();
        }
        duration = System.currentTimeMillis() - starttime;
        if (!started) {
            object = this.workList;
            synchronized (object) {
                if (!this.workList.remove(mywork) && logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"cannot remove work");
                }
                throw new WorkRejectedException("1");
            }
        }
        return duration;
    }

    public void scheduleWork(Work work) throws WorkException {
        this.scheduleWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleWork(Work work, long timeout, ExecutionContext ectx, WorkListener listener) throws WorkException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        JWork mywork = new JWork(work, timeout, ectx, listener);
        if (listener != null) {
            listener.workAccepted(new WorkEvent(this, 1, work, null));
        }
        List list = this.workList;
        synchronized (list) {
            this.workList.add(mywork);
            if (this.poolsz < this.maxpoolsz && this.workList.size() > this.freeThreads) {
                ++this.poolsz;
                WorkThread st = new WorkThread(this, threadnumber++, poolnumber);
                st.start();
            } else {
                this.workList.notify();
            }
        }
    }

    private void doMyWork(Work work, long timeout, ExecutionContext ectx, WorkListener listener, long creationTime) throws WorkException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("timeout=" + timeout));
        }
        if (listener != null) {
            long duration = System.currentTimeMillis() - creationTime;
            if (duration > timeout) {
                logger.log(BasicLevel.WARN, (Object)("REJECTED: duration=" + duration));
                listener.workRejected(new WorkEvent(this, 2, work, null));
                return;
            }
            listener.workStarted(new WorkEvent(this, 3, work, null));
        }
        Xid xid = null;
        if (ectx != null && (xid = ectx.getXid()) != null) {
            long txtimeout = ectx.getTransactionTimeout();
            try {
                this.transactionService.attachTransaction(xid, txtimeout);
            }
            catch (NotSupportedException e) {
                throw new WorkException("Error starting a new transaction", e);
            }
            catch (SystemException e) {
                throw new WorkException("Error starting a new transaction", e);
            }
        }
        try {
            work.run();
            if (listener != null) {
                listener.workCompleted(new WorkEvent(this, 4, work, null));
            }
        }
        catch (Exception e) {
            if (listener != null) {
                listener.workCompleted(new WorkEvent(this, 4, work, null));
            }
            throw new WorkCompletedException(e);
        }
        finally {
            if (xid != null) {
                this.transactionService.detachTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextWork() throws WorkException, InterruptedException {
        JWork run = null;
        boolean haswait = false;
        List list = this.workList;
        synchronized (list) {
            while (this.workList.isEmpty()) {
                if (haswait && this.freeThreads > this.minpoolsz || !this.valid) {
                    --this.poolsz;
                    throw new InterruptedException("Thread ending");
                }
                try {
                    ++this.freeThreads;
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"waiting");
                    }
                    this.workList.wait(this.waitingTime);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"notified");
                    }
                    --this.freeThreads;
                    haswait = true;
                }
                catch (InterruptedException e) {
                    --this.freeThreads;
                    --this.poolsz;
                    throw e;
                }
            }
            JWork jWork = run = (JWork)this.workList.remove(0);
            synchronized (jWork) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"start new work");
                }
                run.setStarted();
                run.notify();
            }
        }
        this.doMyWork(run.getWork(), run.getTimeout(), run.getExecutionContext(), run.getWorkListener(), run.getCreationTime());
    }

    public synchronized void stopThreads() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        this.valid = false;
        this.notifyAll();
        --poolnumber;
    }

    class WorkThread
    extends Thread {
        private JWorkManager mgr;
        private int number;

        WorkThread(JWorkManager m, int num, int wm) {
            super("WorkThread-" + wm + "/" + num);
            this.mgr = m;
            this.number = num;
        }

        public void run() {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"running");
            }
            while (true) {
                try {
                    while (true) {
                        this.mgr.nextWork();
                    }
                }
                catch (InterruptedException e) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"Exiting: ", (Throwable)e);
                    }
                    return;
                }
                catch (WorkException e) {
                    logger.log(BasicLevel.ERROR, (Object)"Exception during work run: ", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class JWork {
        private Work work;
        private long timeout;
        private ExecutionContext ectx;
        private WorkListener listener;
        private long creationTime;
        private boolean started = false;

        public JWork(Work work, long timeout, ExecutionContext ectx, WorkListener listener) {
            this.work = work;
            this.timeout = timeout;
            this.ectx = ectx;
            this.listener = listener;
            this.creationTime = System.currentTimeMillis();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("timeout=" + timeout));
            }
        }

        public Work getWork() {
            return this.work;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public ExecutionContext getExecutionContext() {
            return this.ectx;
        }

        public WorkListener getWorkListener() {
            return this.listener;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public boolean isStarted() {
            return this.started;
        }

        public void setStarted() {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"");
            }
            this.started = true;
        }
    }
}

