/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.deployment.impl.annotations.analyzer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.ow2.easybeans.asm.ClassReader;
import org.ow2.util.deployment.annotations.analyzer.AnalyzerException;
import org.ow2.util.deployment.annotations.analyzer.ArchiveHelper;
import org.ow2.util.deployment.annotations.analyzer.ArchiveScanner;
import org.ow2.util.deployment.impl.annotations.analyzer.ScanClassVisitor;
import org.ow2.util.ee.deploy.api.archive.IArchive;

public final class ArchiveScannerImpl
extends ArchiveScanner {
    public ArchiveScannerImpl(IArchive archive) {
        super(archive);
    }

    public ArchiveScannerImpl(IArchive archive, ArchiveHelper archiveHelper) {
        super(archive, archiveHelper);
    }

    protected void doScan(URL url) throws AnalyzerException {
        InputStream is = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDefaultUseCaches(false);
            is = urlConnection.getInputStream();
            new ClassReader(is).accept(new ScanClassVisitor(this.getArchiveConfigurators()), 0);
        }
        catch (Exception ioe) {
            throw new AnalyzerException("Error while analyzing file entry '" + url + "' in archive '" + this.getArchive().getName() + "'", ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new AnalyzerException("Error while closing input stream of the entry '" + url + "' in archive '" + this.getArchive().getName() + "'", e);
                }
            }
        }
    }
}

