/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.deployment.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.util.deployment.metadata.CommonMetadata;
import org.ow2.util.deployment.metadata.FieldMetadata;
import org.ow2.util.deployment.metadata.MethodMetadata;
import org.ow2.util.deployment.metadata.structures.JClass;
import org.ow2.util.deployment.metadata.structures.JField;
import org.ow2.util.deployment.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassMetadata<C extends ClassMetadata<C, M, F>, M extends MethodMetadata<C, M, F>, F extends FieldMetadata<C, M, F>>
extends CommonMetadata {
    private JClass jClass;
    private Map<JMethod, M> methodsAnnotationMetadata = null;
    private Map<JField, F> fieldsAnnotationMetadata = null;

    public ClassMetadata(JClass jClass) {
        this.jClass = jClass;
        this.methodsAnnotationMetadata = new HashMap<JMethod, M>();
        this.fieldsAnnotationMetadata = new HashMap<JField, F>();
    }

    public final void addMethodMetadata(M methodAnnotationMetadata) {
        JMethod key = ((MethodMetadata)methodAnnotationMetadata).getJMethod();
        this.methodsAnnotationMetadata.put(key, methodAnnotationMetadata);
    }

    public final M getMethodMetadata(JMethod jMethod) {
        return (M)((MethodMetadata)this.methodsAnnotationMetadata.get(jMethod));
    }

    public final List<M> searchMethodMetadata(String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("Cannot search null methods");
        }
        ArrayList<MethodMetadata> list = new ArrayList<MethodMetadata>();
        for (MethodMetadata method : this.methodsAnnotationMetadata.values()) {
            if (!methodName.equals(method.getJMethod().getName())) continue;
            list.add(method);
        }
        return list;
    }

    public final List<F> searchFieldMetadata(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Cannot search null fields");
        }
        ArrayList<FieldMetadata> list = new ArrayList<FieldMetadata>();
        for (FieldMetadata field : this.fieldsAnnotationMetadata.values()) {
            if (!fieldName.equals(field.getJField().getName())) continue;
            list.add(field);
        }
        return list;
    }

    public final Collection<M> getMethodMetadataCollection() {
        return this.methodsAnnotationMetadata.values();
    }

    public final void addFieldMetadata(F fieldAnnotationMetadata) {
        JField key = ((FieldMetadata)fieldAnnotationMetadata).getJField();
        if (this.fieldsAnnotationMetadata.containsKey(key)) {
            throw new IllegalStateException();
        }
        this.fieldsAnnotationMetadata.put(key, fieldAnnotationMetadata);
    }

    public final F getFieldMetadata(JField jField) {
        return (F)((FieldMetadata)this.fieldsAnnotationMetadata.get(jField));
    }

    public final Collection<F> getFieldMetadataCollection() {
        return this.fieldsAnnotationMetadata.values();
    }

    public final JClass getJClass() {
        return this.jClass;
    }

    public final void setJClass(JClass jClass) {
        this.jClass = jClass;
    }
}

