/*
 * Decompiled with CFR 0.152.
 */
package wssec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.message.WSSAddUsernameToken;
import org.apache.ws.security.message.WSSignEnvelope;
import org.w3c.dom.Document;
import wssec.SOAPUtil;

public class TestWSSecurity13
extends TestCase
implements CallbackHandler {
    private static Log log = LogFactory.getLog(class$wssec$TestWSSecurity13 == null ? (class$wssec$TestWSSecurity13 = TestWSSecurity13.class$("wssec.TestWSSecurity13")) : class$wssec$TestWSSecurity13);
    static final String NS = "http://www.w3.org/2000/09/xmldsig#";
    static final String soapMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body>\r\n       \r\n</SOAP-ENV:Envelope>";
    static final WSSecurityEngine secEngine = new WSSecurityEngine();
    MessageContext msgContext;
    SOAPEnvelope unsignedEnvelope;
    static /* synthetic */ Class class$wssec$TestWSSecurity13;

    public TestWSSecurity13(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$wssec$TestWSSecurity13 == null ? (class$wssec$TestWSSecurity13 = TestWSSecurity13.class$("wssec.TestWSSecurity13")) : class$wssec$TestWSSecurity13);
    }

    public static void main(String[] args) {
        TestRunner.run(TestWSSecurity13.suite());
    }

    protected void setUp() throws Exception {
        AxisClient tmpEngine = new AxisClient(new NullProvider());
        this.msgContext = new MessageContext(tmpEngine);
        this.unsignedEnvelope = this.getSOAPEnvelope();
    }

    protected SOAPEnvelope getSOAPEnvelope() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(soapMsg.getBytes());
        Message msg = new Message(in);
        msg.setMessageContext(this.msgContext);
        return msg.getSOAPEnvelope();
    }

    public void testUsernameTokenSigning() throws Exception {
        Object envelope = null;
        Document doc = this.unsignedEnvelope.getAsDocument();
        WSSAddUsernameToken builder = new WSSAddUsernameToken();
        builder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        builder.preSetUsernameToken(doc, "wernerd", "verySecret");
        builder.addCreated(doc);
        builder.addNonce(doc);
        WSSignEnvelope sign = new WSSignEnvelope(null, true);
        sign.setUsernameToken(builder);
        sign.setKeyIdentifierType(7);
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        log.info("Before signing....");
        sign.build(doc, null);
        log.info("Before adding UsernameToken PW Text....");
        Document signedDoc = builder.build(doc, "wernerd", "verySecret");
        Message signedMsg = (Message)SOAPUtil.toSOAPMessage(signedDoc);
        if (log.isDebugEnabled()) {
            log.debug("Message with UserNameToken PW Text:");
            XMLUtils.PrettyElementToWriter(signedMsg.getSOAPEnvelope().getAsDOM(), new PrintWriter(System.out));
        }
        signedDoc = signedMsg.getSOAPEnvelope().getAsDocument();
        log.info("After adding UsernameToken PW Text....");
        this.verify(signedDoc);
    }

    private void verify(Document doc) throws Exception {
        log.info("Before verifying UsernameToken....");
        secEngine.processSecurityHeader(doc, null, this, null);
        log.info("After verifying UsernameToken....");
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof WSPasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
            pc.setPassword("verySecret");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

