/*
 * Decompiled with CFR 0.152.
 */
package wssec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSEncryptBody;
import org.w3c.dom.Document;
import wssec.SOAPUtil;

public class TestWSSecurity7
extends TestCase
implements CallbackHandler {
    private static Log log = LogFactory.getLog(class$wssec$TestWSSecurity7 == null ? (class$wssec$TestWSSecurity7 = TestWSSecurity7.class$("wssec.TestWSSecurity7")) : class$wssec$TestWSSecurity7);
    static final String soapMsg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"urn:LogTestService7\"></ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    static final WSSecurityEngine secEngine = new WSSecurityEngine();
    static final Crypto crypto = CryptoFactory.getInstance();
    MessageContext msgContext;
    Message message;
    static /* synthetic */ Class class$wssec$TestWSSecurity7;

    public TestWSSecurity7(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(class$wssec$TestWSSecurity7 == null ? (class$wssec$TestWSSecurity7 = TestWSSecurity7.class$("wssec.TestWSSecurity7")) : class$wssec$TestWSSecurity7);
    }

    public static void main(String[] args) {
        TestRunner.run(TestWSSecurity7.suite());
    }

    protected void setUp() throws Exception {
        AxisClient tmpEngine = new AxisClient(new NullProvider());
        this.msgContext = new MessageContext(tmpEngine);
        this.message = this.getSOAPMessage();
    }

    protected Message getSOAPMessage() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(soapMsg.getBytes());
        Message msg = new Message(in);
        msg.setMessageContext(this.msgContext);
        return msg;
    }

    public void testEncryptionEncryption() throws Exception {
        SOAPEnvelope unsignedEnvelope = this.message.getSOAPEnvelope();
        Object envelope = null;
        WSEncryptBody encrypt = new WSEncryptBody();
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e");
        log.info("Before Encryption....");
        Document doc = unsignedEnvelope.getAsDocument();
        Document encryptedDoc = encrypt.build(doc, crypto);
        Document encryptedEncryptedDoc = encrypt.build(encryptedDoc, crypto);
        Message encryptedMsg = (Message)SOAPUtil.toSOAPMessage(encryptedEncryptedDoc);
        encryptedEncryptedDoc = encryptedMsg.getSOAPEnvelope().getAsDocument();
        log.info("After Encryption....");
        this.verify(encryptedEncryptedDoc);
    }

    private void verify(Document doc) throws Exception {
        secEngine.processSecurityHeader(doc, null, this, crypto);
        SOAPUtil.updateSOAPMessage(doc, this.message);
        XMLUtils.PrettyElementToWriter(this.message.getSOAPEnvelope().getAsDOM(), new PrintWriter(System.out));
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof WSPasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
            pc.setPassword("security");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

