/*
 * Decompiled with CFR 0.152.
 */
package wssec;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.NullProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.axis.security.WSDoAllReceiver;
import org.apache.ws.axis.security.WSDoAllSender;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.Merlin;
import wssec.PrivilegedAccessor;

public class TestWSSecurityHooks
extends TestCase
implements CallbackHandler {
    private static Log log = LogFactory.getLog(class$wssec$TestWSSecurityHooks == null ? (class$wssec$TestWSSecurityHooks = TestWSSecurityHooks.class$("wssec.TestWSSecurityHooks")) : class$wssec$TestWSSecurityHooks);
    private static final String soapMessage = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Header></soapenv:Header><soapenv:Body><ns1:echo xmlns:ns1=\"http://org.apache.wss4j.wssec/TESTCASE\" soapenv:encodingStyle=\"http://www.w3.org/2003/05/soap-encoding\"><inStr xsi:type=\"xsd:string\">ECHO ECHo ECho Echo echo echO ecHO eCHO ECHO</inStr></ns1:echo></soapenv:Body></soapenv:Envelope>";
    KeyStore keystore = null;
    MessageContext mc = null;
    static /* synthetic */ Class class$wssec$TestWSSecurityHooks;

    public TestWSSecurityHooks(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        AxisClient tmpEngine = new AxisClient(new NullProvider());
        this.mc = new MessageContext(tmpEngine);
        this.mc.setCurrentMessage(this.getSOAPMessage(soapMessage));
        this.mc.setProperty("passwordCallbackRef", this);
        this.keystore = this.loadKeyStore();
    }

    public static Test suite() {
        return new TestSuite(class$wssec$TestWSSecurityHooks == null ? (class$wssec$TestWSSecurityHooks = TestWSSecurityHooks.class$("wssec.TestWSSecurityHooks")) : class$wssec$TestWSSecurityHooks);
    }

    public static void main(String[] args) {
        TestRunner.run(TestWSSecurityHooks.suite());
    }

    public void testCryptoHook() throws Exception {
        TestWSSecurityHooks.assertNotNull("", this.keystore);
        TestCryptoImpl crypto = new TestCryptoImpl(this.keystore);
        TestWSSecurityHooks.assertNotNull(PrivilegedAccessor.getValue(crypto, "keystore"));
    }

    public void testSenderLoadSignatureHook() throws Exception {
        TestSenderImpl sender = new TestSenderImpl();
        PrivilegedAccessor.setValue(sender, "msgContext", this.mc);
        PrivilegedAccessor.invokeMethod((Object)sender, "decodeSignatureParameter", new Object[0]);
        TestWSSecurityHooks.assertNotNull(PrivilegedAccessor.getValue(sender, "sigCrypto"));
    }

    public void testSenderLoadEncryptionHook() throws Exception {
        TestSenderImpl sender = new TestSenderImpl();
        sender.setOption("encryptionUser", "anyUserWillDo");
        PrivilegedAccessor.setValue(sender, "msgContext", this.mc);
        PrivilegedAccessor.invokeMethod((Object)sender, "decodeEncryptionParameter", new Object[0]);
        TestWSSecurityHooks.assertNotNull(PrivilegedAccessor.getValue(sender, "encCrypto"));
    }

    public void testReceiverLoadSignatureHook() throws Exception {
        TestReceiverImpl receiver = new TestReceiverImpl();
        PrivilegedAccessor.invokeMethod((Object)receiver, "decodeSignatureParameter", new Object[0]);
        TestWSSecurityHooks.assertNotNull(PrivilegedAccessor.getValue(receiver, "sigCrypto"));
    }

    public void testReceiverLoadDecryptionHook() throws Exception {
        TestReceiverImpl receiver = new TestReceiverImpl();
        PrivilegedAccessor.invokeMethod((Object)receiver, "decodeDecryptionParameter", new Object[0]);
        TestWSSecurityHooks.assertNotNull(PrivilegedAccessor.getValue(receiver, "decCrypto"));
    }

    public void testRoundTripWithHooks() throws Exception {
        TestSenderImpl sender = new TestSenderImpl();
        sender.setOption("actor", "test");
        sender.setOption("user", "16c73ab6-b892-458f-abf5-2f875f74882e");
        sender.setOption("action", "Encrypt Signature");
        sender.setOption("signatureKeyIdentifier", "DirectReference");
        sender.setOption("encryptionKeyIdentifier", "X509KeyIdentifier");
        sender.invoke(this.mc);
        String soapPart = this.mc.getCurrentMessage().getSOAPPartAsString();
        TestWSSecurityHooks.assertNotSame("The message has not been Encrypted or Signed", soapPart, soapMessage);
        Message message = this.getSOAPMessage(soapPart);
        this.mc.setPastPivot(true);
        this.mc.setCurrentMessage(message);
        TestReceiverImpl receiver = new TestReceiverImpl();
        receiver.setOption("actor", "test");
        receiver.setOption("action", "Encrypt Signature");
        receiver.invoke(this.mc);
    }

    protected Message getSOAPMessage(String message) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(message.getBytes());
        Message msg = new Message(in);
        msg.setMessageContext(this.mc);
        return msg;
    }

    protected KeyStore loadKeyStore() throws Exception {
        KeyStore ks = null;
        FileInputStream is = null;
        is = new FileInputStream("keys/x509.PFX.MSFT");
        ks = KeyStore.getInstance("pkcs12");
        String password = "security";
        ks.load(is, password.toCharArray());
        return ks;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof WSPasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
            pc.setPassword("security");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class TestSenderImpl
    extends WSDoAllSender {
        protected Crypto loadEncryptionCrypto() throws AxisFault {
            try {
                return new TestCryptoImpl(TestWSSecurityHooks.this.keystore);
            }
            catch (Exception e) {
                Assert.fail("Failed to create a Crypto instance.");
                throw new AxisFault("Failed to create a Crypto instance.", e);
            }
        }

        protected Crypto loadSignatureCrypto() throws AxisFault {
            try {
                return new TestCryptoImpl(TestWSSecurityHooks.this.keystore);
            }
            catch (Exception e) {
                Assert.fail("Failed to create a Crypto instance.");
                throw new AxisFault("Failed to create a Crypto instance.", e);
            }
        }
    }

    public class TestReceiverImpl
    extends WSDoAllReceiver {
        protected Crypto loadDecryptionCrypto() throws AxisFault {
            try {
                return new TestCryptoImpl(TestWSSecurityHooks.this.keystore);
            }
            catch (Exception e) {
                Assert.fail("Failed to create a Crypto instance.");
                throw new AxisFault("Failed to create a Crypto instance.", e);
            }
        }

        protected Crypto loadSignatureCrypto() throws AxisFault {
            try {
                return new TestCryptoImpl(TestWSSecurityHooks.this.keystore);
            }
            catch (Exception e) {
                Assert.fail("Failed to create a Crypto instance.");
                throw new AxisFault("Failed to create a Crypto instance.", e);
            }
        }
    }

    public class TestCryptoImpl
    extends Merlin {
        TestCryptoImpl(KeyStore ks) throws Exception {
            super(null);
            Assert.assertNotNull(ks);
            this.setKeyStore(ks);
        }
    }
}

